/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.util;

import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiUtilCore;
import java.util.Comparator;
import org.jetbrains.annotations.NotNull;

public class PsiClassUtil {
    private PsiClassUtil() {
    }

    public static boolean isRunnableClass(PsiClass aClass, boolean mustBePublic) {
        return PsiClassUtil.isRunnableClass(aClass, mustBePublic, true);
    }

    public static boolean isRunnableClass(PsiClass aClass, boolean mustBePublic, boolean mustNotBeAbstract) {
        if (aClass instanceof PsiAnonymousClass) {
            return false;
        }
        if (mustBePublic && !aClass.hasModifierProperty("public") && (mustNotBeAbstract || !aClass.hasModifierProperty("abstract"))) {
            return false;
        }
        if (aClass.hasModifierProperty("private")) {
            return false;
        }
        if (mustNotBeAbstract && aClass.hasModifierProperty("abstract")) {
            return false;
        }
        return aClass.getContainingClass() == null || aClass.hasModifierProperty("static");
    }

    @NotNull
    public static Comparator<PsiClass> createScopeComparator(@NotNull GlobalSearchScope scope) {
        if (scope == null) {
            PsiClassUtil.$$$reportNull$$$0(0);
        }
        Comparator comparator = (c1, c2) -> {
            if (scope == null) {
                PsiClassUtil.$$$reportNull$$$0(2);
            }
            VirtualFile file1 = PsiUtilCore.getVirtualFile((PsiElement)c1);
            VirtualFile file2 = PsiUtilCore.getVirtualFile((PsiElement)c2);
            if (file1 == null) {
                return file2 == null ? 0 : -1;
            }
            if (file2 == null) {
                return 1;
            }
            return scope.compare(file2, file1);
        };
        if (comparator == null) {
            PsiClassUtil.$$$reportNull$$$0(1);
        }
        return comparator;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/util/PsiClassUtil";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/util/PsiClassUtil";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createScopeComparator";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createScopeComparator";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "lambda$createScopeComparator$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

