/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.common.descriptors;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IndexedValue;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.builtins.FunctionTypesKt;
import org.jetbrains.kotlin.builtins.functions.FunctionClassDescriptor;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.ParameterDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.incremental.components.NoLookupLocation;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.resolve.scopes.MemberScope;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.TypeConstructor;
import org.jetbrains.kotlin.types.TypeProjectionImpl;
import org.jetbrains.kotlin.types.TypeSubstitutionKt;
import org.jetbrains.kotlin.types.TypeSubstitutor;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=2, d1={"\u0000J\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\u001a \u0010\u000e\u001a\u00020\u000f*\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\n0\u0001\u001a \u0010\u0014\u001a\u00020\u0015*\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\n0\u0001\u001a \u0010\u0016\u001a\u00020\u000f*\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\n0\u0001\u001a\u0018\u0010\u0017\u001a\u00020\n*\u00020\n2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\n0\u0001\u001a#\u0010\u0018\u001a\u00020\u000f*\u00020\u000f2\u0012\u0010\u0013\u001a\n\u0012\u0006\b\u0001\u0012\u00020\n0\u0019\"\u00020\n\u00a2\u0006\u0002\u0010\u001a\u001a\u001e\u0010\u0018\u001a\u00020\u000f*\u00020\u000f2\u0012\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00020\u001d\u0012\u0004\u0012\u00020\n0\u001c\"\u001b\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001*\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005\"\u001b\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001*\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\u0005\"\u0015\u0010\b\u001a\u00020\t*\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\u000b\"\u0015\u0010\f\u001a\u00020\t*\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\r\u00a8\u0006\u001e"}, d2={"allParameters", "", "Lorg/jetbrains/kotlin/descriptors/ParameterDescriptor;", "Lorg/jetbrains/kotlin/descriptors/CallableDescriptor;", "getAllParameters", "(Lorg/jetbrains/kotlin/descriptors/CallableDescriptor;)Ljava/util/List;", "explicitParameters", "getExplicitParameters", "isFunctionOrKFunctionType", "", "Lorg/jetbrains/kotlin/types/KotlinType;", "(Lorg/jetbrains/kotlin/types/KotlinType;)Z", "isSuspend", "(Lorg/jetbrains/kotlin/descriptors/CallableDescriptor;)Z", "getFunction", "Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "name", "", "types", "getProperty", "Lorg/jetbrains/kotlin/descriptors/PropertyDescriptor;", "getStaticFunction", "replace", "substitute", "", "(Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;[Lorg/jetbrains/kotlin/types/KotlinType;)Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "typeArguments", "", "Lorg/jetbrains/kotlin/descriptors/TypeParameterDescriptor;", "ir.backend.common"})
public final class DescriptorUtilsKt {
    public static final boolean isSuspend(@NotNull CallableDescriptor $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        return $receiver instanceof FunctionDescriptor && ((FunctionDescriptor)$receiver).isSuspend();
    }

    @NotNull
    public static final List<ParameterDescriptor> getAllParameters(@NotNull CallableDescriptor $receiver) {
        List list2;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        if ($receiver instanceof ConstructorDescriptor) {
            ClassDescriptor classDescriptor2 = ((ConstructorDescriptor)$receiver).getConstructedClass();
            Intrinsics.checkExpressionValueIsNotNull((Object)classDescriptor2, (String)"this.constructedClass");
            list2 = CollectionsKt.plus((Collection)CollectionsKt.listOf((Object)classDescriptor2.getThisAsReceiverParameter()), (Iterable)DescriptorUtilsKt.getExplicitParameters($receiver));
        } else {
            list2 = DescriptorUtilsKt.getExplicitParameters($receiver);
        }
        return list2;
    }

    @NotNull
    public static final List<ParameterDescriptor> getExplicitParameters(@NotNull CallableDescriptor $receiver) {
        ReceiverParameterDescriptor it;
        ReceiverParameterDescriptor receiverParameterDescriptor;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        ArrayList<ReceiverParameterDescriptor> result2 = new ArrayList<ReceiverParameterDescriptor>($receiver.getValueParameters().size() + 2);
        ReceiverParameterDescriptor receiverParameterDescriptor2 = $receiver.getDispatchReceiverParameter();
        if (receiverParameterDescriptor2 != null) {
            it = receiverParameterDescriptor = receiverParameterDescriptor2;
            result2.add(it);
        }
        ReceiverParameterDescriptor receiverParameterDescriptor3 = $receiver.getExtensionReceiverParameter();
        if (receiverParameterDescriptor3 != null) {
            it = receiverParameterDescriptor = receiverParameterDescriptor3;
            result2.add(it);
        }
        result2.addAll((Collection)$receiver.getValueParameters());
        return result2;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final KotlinType replace(@NotNull KotlinType $receiver, @NotNull List<? extends KotlinType> types) {
        Collection<TypeProjectionImpl> collection;
        void $receiver$iv$iv;
        void $receiver$iv;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        Intrinsics.checkParameterIsNotNull(types, (String)"types");
        Iterable iterable = types;
        KotlinType kotlinType = $receiver;
        void var3_4 = $receiver$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void p1;
            KotlinType kotlinType2 = (KotlinType)item$iv$iv;
            collection = destination$iv$iv;
            TypeProjectionImpl typeProjectionImpl = new TypeProjectionImpl((KotlinType)p1);
            collection.add(typeProjectionImpl);
        }
        collection = (List)destination$iv$iv;
        return TypeSubstitutionKt.replace$default(kotlinType, (List)collection, null, 2, null);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final FunctionDescriptor substitute(@NotNull FunctionDescriptor $receiver, KotlinType ... types) {
        void $receiver$iv$iv;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        Intrinsics.checkParameterIsNotNull((Object)types, (String)"types");
        List<TypeParameterDescriptor> list2 = $receiver.getTypeParameters();
        Intrinsics.checkExpressionValueIsNotNull(list2, (String)"typeParameters");
        Iterable $receiver$iv = CollectionsKt.withIndex((Iterable)list2);
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10)), (int)16);
        Iterable iterable = $receiver$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        for (Object element$iv$iv : $receiver$iv$iv) {
            IndexedValue it;
            IndexedValue indexedValue = (IndexedValue)element$iv$iv;
            Map map2 = destination$iv$iv;
            Object object = it.getValue();
            Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"it.value");
            TypeConstructor typeConstructor2 = ((TypeParameterDescriptor)object).getTypeConstructor();
            it = (IndexedValue)element$iv$iv;
            TypeProjectionImpl typeProjectionImpl = new TypeProjectionImpl(types[it.getIndex()]);
            map2.put(typeConstructor2, typeProjectionImpl);
        }
        TypeSubstitutor typeSubstitutor2 = TypeSubstitutor.create(destination$iv$iv);
        Intrinsics.checkExpressionValueIsNotNull((Object)typeSubstitutor2, (String)"TypeSubstitutor.create(\n\u2026types[it.index]) })\n    )");
        TypeSubstitutor typeSubstitutor3 = typeSubstitutor2;
        FunctionDescriptor functionDescriptor2 = $receiver.substitute(typeSubstitutor3);
        if (functionDescriptor2 == null) {
            Intrinsics.throwNpe();
        }
        return functionDescriptor2;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final FunctionDescriptor substitute(@NotNull FunctionDescriptor $receiver, @NotNull Map<TypeParameterDescriptor, ? extends KotlinType> typeArguments2) {
        void $receiver$iv$iv;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        Intrinsics.checkParameterIsNotNull(typeArguments2, (String)"typeArguments");
        List<TypeParameterDescriptor> list2 = $receiver.getTypeParameters();
        Intrinsics.checkExpressionValueIsNotNull(list2, (String)"typeParameters");
        Iterable $receiver$iv = list2;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10)), (int)16);
        Iterable iterable = $receiver$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        for (Object element$iv$iv : $receiver$iv$iv) {
            TypeParameterDescriptor it;
            TypeParameterDescriptor typeParameterDescriptor = (TypeParameterDescriptor)element$iv$iv;
            Map map2 = destination$iv$iv;
            void v1 = it;
            Intrinsics.checkExpressionValueIsNotNull((Object)v1, (String)"it");
            TypeConstructor typeConstructor2 = v1.getTypeConstructor();
            it = (TypeParameterDescriptor)element$iv$iv;
            KotlinType kotlinType = typeArguments2.get(it);
            if (kotlinType == null) {
                Intrinsics.throwNpe();
            }
            TypeProjectionImpl typeProjectionImpl = new TypeProjectionImpl(kotlinType);
            map2.put(typeConstructor2, typeProjectionImpl);
        }
        TypeSubstitutor typeSubstitutor2 = TypeSubstitutor.create(destination$iv$iv);
        Intrinsics.checkExpressionValueIsNotNull((Object)typeSubstitutor2, (String)"TypeSubstitutor.create(\n\u2026Arguments[it]!!) })\n    )");
        TypeSubstitutor typeSubstitutor3 = typeSubstitutor2;
        FunctionDescriptor functionDescriptor2 = $receiver.substitute(typeSubstitutor3);
        if (functionDescriptor2 == null) {
            Intrinsics.throwNpe();
        }
        return functionDescriptor2;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final FunctionDescriptor getFunction(@NotNull ClassDescriptor $receiver, @NotNull String name2, @NotNull List<? extends KotlinType> types) {
        void $receiver$iv$iv;
        void $receiver$iv;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        Intrinsics.checkParameterIsNotNull((Object)name2, (String)"name");
        Intrinsics.checkParameterIsNotNull(types, (String)"types");
        List<TypeParameterDescriptor> list2 = $receiver.getDeclaredTypeParameters();
        Intrinsics.checkExpressionValueIsNotNull(list2, (String)"declaredTypeParameters");
        Iterable iterable = CollectionsKt.withIndex((Iterable)list2);
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10)), (int)16);
        void var6_5 = $receiver$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        for (Object element$iv$iv : $receiver$iv$iv) {
            IndexedValue it;
            IndexedValue indexedValue = (IndexedValue)element$iv$iv;
            Map map2 = destination$iv$iv;
            Object object = it.getValue();
            Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"it.value");
            TypeConstructor typeConstructor2 = ((TypeParameterDescriptor)object).getTypeConstructor();
            it = (IndexedValue)element$iv$iv;
            TypeProjectionImpl typeProjectionImpl = new TypeProjectionImpl(types.get(it.getIndex()));
            map2.put(typeConstructor2, typeProjectionImpl);
        }
        TypeSubstitutor typeSubstitutor2 = TypeSubstitutor.create(destination$iv$iv);
        Intrinsics.checkExpressionValueIsNotNull((Object)typeSubstitutor2, (String)"TypeSubstitutor.create(\n\u2026types[it.index]) })\n    )");
        TypeSubstitutor typeSubstitutor3 = typeSubstitutor2;
        MemberScope memberScope2 = $receiver.getUnsubstitutedMemberScope();
        Name name3 = Name.identifier(name2);
        Intrinsics.checkExpressionValueIsNotNull((Object)name3, (String)"Name.identifier(name)");
        FunctionDescriptor functionDescriptor2 = ((SimpleFunctionDescriptor)CollectionsKt.single((Iterable)memberScope2.getContributedFunctions(name3, NoLookupLocation.FROM_BACKEND))).substitute(typeSubstitutor3);
        if (functionDescriptor2 == null) {
            Intrinsics.throwNpe();
        }
        return functionDescriptor2;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final FunctionDescriptor getStaticFunction(@NotNull ClassDescriptor $receiver, @NotNull String name2, @NotNull List<? extends KotlinType> types) {
        void $receiver$iv$iv;
        void $receiver$iv;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        Intrinsics.checkParameterIsNotNull((Object)name2, (String)"name");
        Intrinsics.checkParameterIsNotNull(types, (String)"types");
        List<TypeParameterDescriptor> list2 = $receiver.getDeclaredTypeParameters();
        Intrinsics.checkExpressionValueIsNotNull(list2, (String)"declaredTypeParameters");
        Iterable iterable = CollectionsKt.withIndex((Iterable)list2);
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10)), (int)16);
        void var6_5 = $receiver$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        for (Object element$iv$iv : $receiver$iv$iv) {
            IndexedValue it;
            IndexedValue indexedValue = (IndexedValue)element$iv$iv;
            Map map2 = destination$iv$iv;
            Object object = it.getValue();
            Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"it.value");
            TypeConstructor typeConstructor2 = ((TypeParameterDescriptor)object).getTypeConstructor();
            it = (IndexedValue)element$iv$iv;
            TypeProjectionImpl typeProjectionImpl = new TypeProjectionImpl(types.get(it.getIndex()));
            map2.put(typeConstructor2, typeProjectionImpl);
        }
        TypeSubstitutor typeSubstitutor2 = TypeSubstitutor.create(destination$iv$iv);
        Intrinsics.checkExpressionValueIsNotNull((Object)typeSubstitutor2, (String)"TypeSubstitutor.create(\n\u2026types[it.index]) })\n    )");
        TypeSubstitutor typeSubstitutor3 = typeSubstitutor2;
        MemberScope memberScope2 = $receiver.getStaticScope();
        Name name3 = Name.identifier(name2);
        Intrinsics.checkExpressionValueIsNotNull((Object)name3, (String)"Name.identifier(name)");
        FunctionDescriptor functionDescriptor2 = ((SimpleFunctionDescriptor)CollectionsKt.single((Iterable)memberScope2.getContributedFunctions(name3, NoLookupLocation.FROM_BACKEND))).substitute(typeSubstitutor3);
        if (functionDescriptor2 == null) {
            Intrinsics.throwNpe();
        }
        return functionDescriptor2;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final PropertyDescriptor getProperty(@NotNull ClassDescriptor $receiver, @NotNull String name2, @NotNull List<? extends KotlinType> types) {
        void $receiver$iv$iv;
        void $receiver$iv;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        Intrinsics.checkParameterIsNotNull((Object)name2, (String)"name");
        Intrinsics.checkParameterIsNotNull(types, (String)"types");
        List<TypeParameterDescriptor> list2 = $receiver.getDeclaredTypeParameters();
        Intrinsics.checkExpressionValueIsNotNull(list2, (String)"declaredTypeParameters");
        Iterable iterable = CollectionsKt.withIndex((Iterable)list2);
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10)), (int)16);
        void var6_5 = $receiver$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        for (Object element$iv$iv : $receiver$iv$iv) {
            IndexedValue it;
            IndexedValue indexedValue = (IndexedValue)element$iv$iv;
            Map map2 = destination$iv$iv;
            Object object = it.getValue();
            Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"it.value");
            TypeConstructor typeConstructor2 = ((TypeParameterDescriptor)object).getTypeConstructor();
            it = (IndexedValue)element$iv$iv;
            TypeProjectionImpl typeProjectionImpl = new TypeProjectionImpl(types.get(it.getIndex()));
            map2.put(typeConstructor2, typeProjectionImpl);
        }
        TypeSubstitutor typeSubstitutor2 = TypeSubstitutor.create(destination$iv$iv);
        Intrinsics.checkExpressionValueIsNotNull((Object)typeSubstitutor2, (String)"TypeSubstitutor.create(\n\u2026types[it.index]) })\n    )");
        TypeSubstitutor typeSubstitutor3 = typeSubstitutor2;
        MemberScope memberScope2 = $receiver.getUnsubstitutedMemberScope();
        Name name3 = Name.identifier(name2);
        Intrinsics.checkExpressionValueIsNotNull((Object)name3, (String)"Name.identifier(name)");
        PropertyDescriptor propertyDescriptor = ((PropertyDescriptor)CollectionsKt.single((Iterable)memberScope2.getContributedVariables(name3, NoLookupLocation.FROM_BACKEND))).substitute(typeSubstitutor3);
        if (propertyDescriptor == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.descriptors.PropertyDescriptor");
        }
        return propertyDescriptor;
    }

    public static final boolean isFunctionOrKFunctionType(@NotNull KotlinType $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        ClassifierDescriptor classifierDescriptor = $receiver.getConstructor().getDeclarationDescriptor();
        FunctionClassDescriptor.Kind kind = classifierDescriptor != null ? FunctionTypesKt.getFunctionalClassKind(classifierDescriptor) : null;
        return kind == FunctionClassDescriptor.Kind.Function || kind == FunctionClassDescriptor.Kind.KFunction;
    }
}

