/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.configuration;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.projectRoots.Sdk;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.config.JvmTarget;
import org.jetbrains.kotlin.idea.configuration.GradleKotlinJavaFrameworkSupportProvider;
import org.jetbrains.kotlin.idea.configuration.SettingsScriptBuilder;
import org.jetbrains.kotlin.idea.versions.KotlinRuntimeLibraryUtilKt;
import org.jetbrains.plugins.gradle.frameworkSupport.BuildScriptDataBuilder;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J*\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\b\u0010\r\u001a\u00020\u000eH\u0014J\b\u0010\u000f\u001a\u00020\u000eH\u0014J\b\u0010\u0010\u001a\u00020\u000eH\u0014J\u000e\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0012H\u0014J\u0018\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u000b\u001a\u00020\fH\u0014\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/idea/configuration/GradleKotlinMPPJavaFrameworkSupportProvider;", "Lorg/jetbrains/kotlin/idea/configuration/GradleKotlinJavaFrameworkSupportProvider;", "()V", "addSupport", "", "buildScriptData", "Lorg/jetbrains/plugins/gradle/frameworkSupport/BuildScriptDataBuilder;", "module", "Lcom/intellij/openapi/module/Module;", "sdk", "Lcom/intellij/openapi/projectRoots/Sdk;", "specifyPluginVersionIfNeeded", "", "getDescription", "", "getPluginExpression", "getPluginId", "getTestDependencies", "", "updateSettingsScript", "settingsBuilder", "Lorg/jetbrains/kotlin/idea/configuration/SettingsScriptBuilder;", "idea-gradle"})
public final class GradleKotlinMPPJavaFrameworkSupportProvider
extends GradleKotlinJavaFrameworkSupportProvider {
    @Override
    @NotNull
    protected String getPluginId() {
        return "kotlin-platform-jvm";
    }

    @Override
    @NotNull
    protected String getPluginExpression() {
        return "id 'kotlin-platform-jvm'";
    }

    @Override
    @NotNull
    protected String getDescription() {
        return "JVM-specific code for a Kotlin multiplatform project";
    }

    @Override
    @NotNull
    protected List<String> getTestDependencies() {
        return CollectionsKt.listOf((Object[])new String[]{"kotlin-test", "kotlin-test-junit", "junit:junit:4.12"});
    }

    @Override
    public void addSupport(@NotNull BuildScriptDataBuilder buildScriptData, @NotNull Module module, @Nullable Sdk sdk2, boolean specifyPluginVersionIfNeeded) {
        Intrinsics.checkParameterIsNotNull((Object)buildScriptData, (String)"buildScriptData");
        Intrinsics.checkParameterIsNotNull((Object)module, (String)"module");
        super.addSupport(buildScriptData, module, sdk2, specifyPluginVersionIfNeeded);
        JvmTarget jvmTarget = KotlinRuntimeLibraryUtilKt.getDefaultJvmTarget(sdk2, KotlinRuntimeLibraryUtilKt.bundledRuntimeVersion());
        if (jvmTarget != null) {
            String description2 = jvmTarget.getDescription();
            buildScriptData.addOther("sourceCompatibility = \"" + description2 + "\"\n\n");
        }
    }

    @Override
    protected void updateSettingsScript(@NotNull SettingsScriptBuilder settingsBuilder, boolean specifyPluginVersionIfNeeded) {
        Intrinsics.checkParameterIsNotNull((Object)settingsBuilder, (String)"settingsBuilder");
        if (specifyPluginVersionIfNeeded) {
            settingsBuilder.addResolutionStrategy("kotlin-platform-jvm");
        }
    }

    public GradleKotlinMPPJavaFrameworkSupportProvider() {
        super("KOTLIN_MPP_JVM", "Kotlin (Multiplatform JVM - Experimental)");
    }
}

