/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.core;

import com.intellij.ide.util.DirectoryChooserUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.ModulePackageIndex;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.SourceFolder;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaDirectoryService;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.Query;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.ArraysKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.java.JavaModuleSourceRootTypes;
import org.jetbrains.jps.model.java.JavaSourceRootProperties;
import org.jetbrains.jps.model.module.JpsModuleSourceRootType;
import org.jetbrains.kotlin.config.KotlinSourceRootType;
import org.jetbrains.kotlin.idea.caches.PerModulePackageCacheService;
import org.jetbrains.kotlin.idea.core.PackageUtilsKt;
import org.jetbrains.kotlin.idea.roots.RootUtilsKt;
import org.jetbrains.kotlin.idea.util.ProjectRootsUtilKt;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.utils.CollectionsKt;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=2, d1={"\u0000`\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u001a\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002\u001a\u0018\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t\u001a#\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000b0\r2\u0006\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u00a2\u0006\u0002\u0010\u000f\u001a(\u0010\u0010\u001a\u0004\u0018\u00010\u000b2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0014\u001a\u00020\u0015H\u0002\u001a\n\u0010\u0016\u001a\u00020\u0017*\u00020\u0018\u001a\n\u0010\u0019\u001a\u00020\u0017*\u00020\u000b\u001a\u0012\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00130\u001b*\u00020\u0007H\u0002\u001a\u0012\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00130\u001b*\u00020\u0007H\u0002\u001a\f\u0010\u001d\u001a\u0004\u0018\u00010\u0005*\u00020\u000b\u001a\n\u0010\u001e\u001a\u00020\u001f*\u00020 \u001a\n\u0010!\u001a\u00020\u001f*\u00020 \"\u001a\u0010\u0000\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"kotlinSourceRootTypes", "", "Lorg/jetbrains/jps/model/module/JpsModuleSourceRootType;", "Lorg/jetbrains/jps/model/java/JavaSourceRootProperties;", "findLongestExistingPackage", "Lcom/intellij/psi/PsiPackage;", "module", "Lcom/intellij/openapi/module/Module;", "packageName", "", "findOrCreateDirectoryForPackage", "Lcom/intellij/psi/PsiDirectory;", "getPackageDirectoriesInModule", "", "rootPackage", "(Lcom/intellij/psi/PsiPackage;Lcom/intellij/openapi/module/Module;)[Lcom/intellij/psi/PsiDirectory;", "getWritableModuleDirectory", "vFiles", "Lcom/intellij/util/Query;", "Lcom/intellij/openapi/vfs/VirtualFile;", "manager", "Lcom/intellij/psi/PsiManager;", "getFqNameByDirectory", "Lorg/jetbrains/kotlin/name/FqName;", "Lcom/intellij/psi/PsiFile;", "getFqNameWithImplicitPrefix", "getNonGeneratedKotlinSourceRoots", "", "getOrConfigureKotlinSourceRoots", "getPackage", "packageMatchesDirectory", "", "Lorg/jetbrains/kotlin/psi/KtFile;", "packageMatchesDirectoryOrImplicit", "idea-core"})
public final class PackageUtilsKt {
    private static final Set<JpsModuleSourceRootType<JavaSourceRootProperties>> kotlinSourceRootTypes;

    @Nullable
    public static final PsiPackage getPackage(@NotNull PsiDirectory $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        JavaDirectoryService javaDirectoryService = JavaDirectoryService.getInstance();
        if (javaDirectoryService == null) {
            Intrinsics.throwNpe();
        }
        return javaDirectoryService.getPackage($receiver);
    }

    @NotNull
    public static final FqName getFqNameByDirectory(@NotNull PsiFile $receiver) {
        FqName fqName2;
        String qualifiedNameByDirectory;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        PsiDirectory psiDirectory = $receiver.getParent();
        String string = qualifiedNameByDirectory = psiDirectory != null && (psiDirectory = PackageUtilsKt.getPackage(psiDirectory)) != null ? psiDirectory.getQualifiedName() : null;
        if (string != null) {
            String string2;
            String p1 = string2 = string;
            fqName2 = new FqName(p1);
        } else {
            FqName fqName3 = FqName.ROOT;
            fqName2 = fqName3;
            Intrinsics.checkExpressionValueIsNotNull((Object)fqName3, (String)"FqName.ROOT");
        }
        return fqName2;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final FqName getFqNameWithImplicitPrefix(@NotNull PsiDirectory $receiver) {
        FqName fqName2;
        Object object;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        Object object2 = PackageUtilsKt.getPackage($receiver);
        if (object2 != null && (object2 = object2.getQualifiedName()) != null) {
            Object p1 = object = object2;
            fqName2 = new FqName((String)p1);
        } else {
            fqName2 = FqName.ROOT;
        }
        FqName packageFqName = fqName2;
        VirtualFile virtualFile = ProjectRootsUtilKt.getSourceRoot((PsiFileSystemItem)$receiver);
        if (virtualFile != null) {
            void $receiver$iv$iv;
            Iterable $receiver$iv;
            Object sourceRoot = object = virtualFile;
            Project project = $receiver.getProject();
            Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"project");
            FqName implicitPrefix = PerModulePackageCacheService.Companion.getInstance(project).getImplicitPackagePrefix((VirtualFile)sourceRoot);
            List<Name> list2 = implicitPrefix.pathSegments();
            Intrinsics.checkExpressionValueIsNotNull(list2, (String)"implicitPrefix.pathSegments()");
            Collection collection = list2;
            List<Name> list3 = packageFqName.pathSegments();
            Intrinsics.checkExpressionValueIsNotNull(list3, (String)"packageFqName.pathSegments()");
            Iterable iterable = $receiver$iv = (Iterable)kotlin.collections.CollectionsKt.plus((Collection)collection, (Iterable)list3);
            Collection destination$iv$iv = new ArrayList(kotlin.collections.CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
            for (Object item$iv$iv : $receiver$iv$iv) {
                void it;
                Name name2 = (Name)item$iv$iv;
                Collection collection2 = destination$iv$iv;
                String string = it.asString();
                collection2.add(string);
            }
            FqName fqName3 = FqName.fromSegments((List)destination$iv$iv);
            Intrinsics.checkExpressionValueIsNotNull((Object)fqName3, (String)"FqName.fromSegments((imp\u2026)).map { it.asString() })");
            return fqName3;
        }
        FqName fqName4 = packageFqName;
        Intrinsics.checkExpressionValueIsNotNull((Object)fqName4, (String)"packageFqName");
        return fqName4;
    }

    public static final boolean packageMatchesDirectory(@NotNull KtFile $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        return Intrinsics.areEqual((Object)$receiver.getPackageFqName(), (Object)PackageUtilsKt.getFqNameByDirectory((PsiFile)$receiver));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean packageMatchesDirectoryOrImplicit(@NotNull KtFile $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        if (Intrinsics.areEqual((Object)$receiver.getPackageFqName(), (Object)PackageUtilsKt.getFqNameByDirectory((PsiFile)$receiver))) return true;
        PsiDirectory psiDirectory = $receiver.getParent();
        if (!Intrinsics.areEqual((Object)$receiver.getPackageFqName(), (Object)(psiDirectory != null ? PackageUtilsKt.getFqNameWithImplicitPrefix(psiDirectory) : null))) return false;
        return true;
    }

    private static final PsiDirectory getWritableModuleDirectory(Query<VirtualFile> vFiles, Module module, PsiManager manager) {
        for (VirtualFile vFile : vFiles) {
            PsiDirectory directory;
            if (ModuleUtil.findModuleForFile((VirtualFile)vFile, (Project)module.getProject()) != module || (directory = manager.findDirectory(vFile)) == null || !directory.isValid() || !directory.isWritable()) continue;
            return directory;
        }
        return null;
    }

    private static final PsiPackage findLongestExistingPackage(Module module, String packageName) {
        PsiManager psiManager = PsiManager.getInstance((Project)module.getProject());
        Intrinsics.checkExpressionValueIsNotNull((Object)psiManager, (String)"PsiManager.getInstance(module.project)");
        PsiManager manager = psiManager;
        String nameToMatch = packageName;
        while (true) {
            Query vFiles;
            Intrinsics.checkExpressionValueIsNotNull((Object)ModulePackageIndex.getInstance((Module)module).getDirsByPackageName(nameToMatch, false), (String)"ModulePackageIndex.getIn\u2026eName(nameToMatch, false)");
            PsiDirectory directory = PackageUtilsKt.getWritableModuleDirectory((Query<VirtualFile>)vFiles, module, manager);
            if (directory != null) {
                return PackageUtilsKt.getPackage(directory);
            }
            int lastDotIndex = StringsKt.lastIndexOf$default((CharSequence)nameToMatch, (char)'.', (int)0, (boolean)false, (int)6, null);
            if (lastDotIndex < 0) {
                return null;
            }
            String string = nameToMatch;
            int n = 0;
            String string2 = string;
            if (string2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)string2.substring(n, lastDotIndex), (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
        }
    }

    private static final List<VirtualFile> getNonGeneratedKotlinSourceRoots(@NotNull Module $receiver) {
        ModuleRootManager rootManager;
        List result2 = new ArrayList();
        ModuleRootManager moduleRootManager = rootManager = ModuleRootManager.getInstance((Module)$receiver);
        Intrinsics.checkExpressionValueIsNotNull((Object)moduleRootManager, (String)"rootManager");
        for (ContentEntry contentEntry : moduleRootManager.getContentEntries()) {
            List sourceFolders;
            Intrinsics.checkExpressionValueIsNotNull((Object)contentEntry.getSourceFolders(kotlinSourceRootTypes), (String)"contentEntry.getSourceFo\u2026rs(kotlinSourceRootTypes)");
            Iterator iterator2 = sourceFolders.iterator();
            while (iterator2.hasNext()) {
                SourceFolder sourceFolder;
                SourceFolder sourceFolder2 = sourceFolder = (SourceFolder)iterator2.next();
                Intrinsics.checkExpressionValueIsNotNull((Object)sourceFolder2, (String)"sourceFolder");
                JavaSourceRootProperties javaSourceRootProperties = (JavaSourceRootProperties)sourceFolder2.getJpsElement().getProperties(kotlinSourceRootTypes);
                if (javaSourceRootProperties != null) {
                    if (javaSourceRootProperties.isForGeneratedSources()) {
                        continue;
                    }
                }
                CollectionsKt.addIfNotNull(result2, sourceFolder.getFile());
            }
        }
        return result2;
    }

    private static final List<VirtualFile> getOrConfigureKotlinSourceRoots(@NotNull Module $receiver) {
        List<VirtualFile> sourceRoots = PackageUtilsKt.getNonGeneratedKotlinSourceRoots($receiver);
        Collection collection = sourceRoots;
        if (!collection.isEmpty()) {
            return sourceRoots;
        }
        return (List)ApplicationManager.getApplication().runWriteAction(new Computable<T>($receiver){
            final /* synthetic */ Module $this_getOrConfigureKotlinSourceRoots$inlined;
            {
                this.$this_getOrConfigureKotlinSourceRoots$inlined = module;
            }

            public final T compute() {
                VirtualFile rootDir;
                Object[] objectArray = ProjectRootsUtilKt.getRootManager(this.$this_getOrConfigureKotlinSourceRoots$inlined).getContentRoots();
                Intrinsics.checkExpressionValueIsNotNull((Object)objectArray, (String)"rootManager.contentRoots");
                VirtualFile virtualFile = rootDir = (VirtualFile)ArraysKt.firstOrNull((Object[])objectArray);
                if (virtualFile != null) {
                    virtualFile.createChildDirectory((Object)this.$this_getOrConfigureKotlinSourceRoots$inlined.getProject(), "kotlin");
                }
                Project project = this.$this_getOrConfigureKotlinSourceRoots$inlined.getProject();
                Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"project");
                RootUtilsKt.invalidateProjectRoots(project);
                return (T)PackageUtilsKt.access$getNonGeneratedKotlinSourceRoots(this.$this_getOrConfigureKotlinSourceRoots$inlined);
            }
        });
    }

    private static final PsiDirectory[] getPackageDirectoriesInModule(PsiPackage rootPackage, Module module) {
        PsiDirectory[] psiDirectoryArray = rootPackage.getDirectories(GlobalSearchScope.moduleScope((Module)module));
        Intrinsics.checkExpressionValueIsNotNull((Object)psiDirectoryArray, (String)"rootPackage.getDirectori\u2026cope.moduleScope(module))");
        return psiDirectoryArray;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public static final PsiDirectory findOrCreateDirectoryForPackage(@NotNull Module module, @NotNull String packageName) {
        void psiDirectory;
        PsiDirectory[] sourceDirectories;
        PsiDirectory psiDirectory2;
        PsiPackage rootPackage;
        Intrinsics.checkParameterIsNotNull((Object)module, (String)"module");
        Intrinsics.checkParameterIsNotNull((Object)packageName, (String)"packageName");
        Project project = module.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"module.project");
        Project project2 = project;
        PsiDirectory existingDirectoryByPackage = null;
        String restOfName = packageName;
        CharSequence charSequence = packageName;
        if (!(charSequence.length() == 0) && (rootPackage = PackageUtilsKt.findLongestExistingPackage(module, packageName)) != null) {
            String string;
            int beginIndex = rootPackage.getQualifiedName().length() + 1;
            if (beginIndex < packageName.length()) {
                String string2 = packageName;
                String string3 = string2.substring(beginIndex);
                string = string3;
                Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(this as java.lang.String).substring(startIndex)");
            } else {
                string = "";
            }
            String subPackageName = string;
            Object postfixToShow = StringsKt.replace$default((String)subPackageName, (char)'.', (char)File.separatorChar, (boolean)false, (int)4, null);
            CharSequence charSequence2 = subPackageName;
            if (charSequence2.length() > 0) {
                char c = File.separatorChar;
                postfixToShow = String.valueOf(c) + (String)postfixToShow;
            }
            PsiDirectory[] moduleDirectories = PackageUtilsKt.getPackageDirectoriesInModule(rootPackage, module);
            PsiDirectory psiDirectory3 = DirectoryChooserUtil.selectDirectory((Project)project2, (PsiDirectory[])moduleDirectories, null, (String)postfixToShow);
            if (psiDirectory3 == null) {
                return null;
            }
            existingDirectoryByPackage = psiDirectory3;
            restOfName = subPackageName;
        }
        if ((psiDirectory2 = existingDirectoryByPackage) == null) {
            List<VirtualFile> sourceRoots = PackageUtilsKt.getOrConfigureKotlinSourceRoots(module);
            if (sourceRoots.isEmpty()) {
                return null;
            }
            List directoryList = new ArrayList();
            for (VirtualFile sourceRoot : sourceRoots) {
                PsiDirectory directory;
                if (PsiManager.getInstance((Project)project2).findDirectory(sourceRoot) == null) {
                    continue;
                }
                Intrinsics.checkExpressionValueIsNotNull((Object)directory, (String)"PsiManager.getInstance(p\u2026y(sourceRoot) ?: continue");
                Collection collection = directoryList;
                collection.add(directory);
            }
            Collection $receiver$iv22 = directoryList;
            Object thisCollection$iv = $receiver$iv22;
            PsiDirectory[] psiDirectoryArray = thisCollection$iv.toArray(new PsiDirectory[0]);
            if (psiDirectoryArray == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
            }
            sourceDirectories = psiDirectoryArray;
            char $receiver$iv22 = File.separatorChar;
            thisCollection$iv = StringsKt.replace$default((String)packageName, (char)'.', (char)File.separatorChar, (boolean)false, (int)4, null);
            PsiDirectory psiDirectory4 = null;
            PsiDirectory[] psiDirectoryArray2 = sourceDirectories;
            Project project3 = project2;
            String string = String.valueOf($receiver$iv22) + (String)thisCollection$iv;
            PsiDirectory psiDirectory5 = DirectoryChooserUtil.selectDirectory((Project)project3, (PsiDirectory[])psiDirectoryArray2, psiDirectory4, (String)string);
            if (psiDirectory5 == null) {
                return null;
            }
            psiDirectory2 = psiDirectory5;
            Intrinsics.checkExpressionValueIsNotNull((Object)psiDirectory5, (String)"run {\n        val source\u2026   ) ?: return null\n    }");
        }
        PsiDirectory existingDirectory = psiDirectory2;
        findOrCreateDirectoryForPackage.1 getLeftPart$ = findOrCreateDirectoryForPackage.1.INSTANCE;
        findOrCreateDirectoryForPackage.2 cutLeftPart$ = findOrCreateDirectoryForPackage.2.INSTANCE;
        Ref.ObjectRef $receiver$iv22 = new Ref.ObjectRef();
        $receiver$iv22.element = existingDirectory;
        while ((sourceDirectories = (PsiDirectory[])restOfName).length() > 0) {
            String name2 = getLeftPart$.invoke(restOfName);
            PsiDirectory foundExistingDirectory = ((PsiDirectory)psiDirectory.element).findSubdirectory(name2);
            PsiDirectory psiDirectory6 = foundExistingDirectory;
            if (psiDirectory6 == null) {
                Object object = WriteAction.compute((ThrowableComputable)new ThrowableComputable<T, E>((Ref.ObjectRef)psiDirectory, name2){
                    final /* synthetic */ Ref.ObjectRef $psiDirectory;
                    final /* synthetic */ String $name;

                    @NotNull
                    public final PsiDirectory compute() {
                        return ((PsiDirectory)this.$psiDirectory.element).createSubdirectory(this.$name);
                    }
                    {
                        this.$psiDirectory = objectRef;
                        this.$name = string;
                    }
                });
                Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"WriteAction.compute<PsiD\u2026reateSubdirectory(name) }");
                psiDirectory6 = (PsiDirectory)object;
            }
            psiDirectory.element = psiDirectory6;
            restOfName = cutLeftPart$.invoke(restOfName);
        }
        return (PsiDirectory)psiDirectory.element;
    }

    static {
        Set set2 = SetsKt.setOf((Object[])new KotlinSourceRootType[]{(KotlinSourceRootType)KotlinSourceRootType.Source.INSTANCE, (KotlinSourceRootType)KotlinSourceRootType.TestSource.INSTANCE});
        Set set3 = JavaModuleSourceRootTypes.SOURCES;
        Intrinsics.checkExpressionValueIsNotNull((Object)set3, (String)"JavaModuleSourceRootTypes.SOURCES");
        kotlinSourceRootTypes = SetsKt.plus((Set)set2, (Iterable)set3);
    }

    @NotNull
    public static final /* synthetic */ List access$getNonGeneratedKotlinSourceRoots(@NotNull Module $receiver) {
        return PackageUtilsKt.getNonGeneratedKotlinSourceRoots($receiver);
    }
}

