/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.core.script.dependencies;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.TransactionGuard;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ex.ProjectRootManagerEx;
import com.intellij.openapi.util.EmptyRunnable;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.script.experimental.dependencies.AsyncDependenciesResolver;
import kotlin.script.experimental.dependencies.DependenciesResolver;
import kotlin.script.experimental.dependencies.ScriptDependencies;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.core.script.ScriptDependenciesCache;
import org.jetbrains.kotlin.idea.core.script.ScriptDependenciesFileAttributeKt;
import org.jetbrains.kotlin.idea.core.script.ScriptDependenciesModificationTracker;
import org.jetbrains.kotlin.idea.core.script.ScriptNewDependenciesNotificationKt;
import org.jetbrains.kotlin.idea.core.script.dependencies.AsyncScriptDependenciesLoader;
import org.jetbrains.kotlin.idea.core.script.dependencies.ScriptDependenciesLoader;
import org.jetbrains.kotlin.idea.core.script.dependencies.SyncScriptDependenciesLoader;
import org.jetbrains.kotlin.idea.util.application.ApplicationUtilsKt;
import org.jetbrains.kotlin.script.KotlinScriptDefinition;
import org.jetbrains.kotlin.script.LegacyResolverWrapper;
import org.jetbrains.kotlin.script.ScriptContentLoader;
import org.jetbrains.kotlin.script.ScriptContentLoaderKt;
import org.jetbrains.kotlin.script.ScriptReportSink;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b&\u0018\u0000 %2\u00020\u0001:\u0001%B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\b\u0010\u0019\u001a\u00020\u001aH$J\b\u0010\u001b\u001a\u00020\u001aH\u0004J\u0010\u0010\u001c\u001a\u00020\u001a2\u0006\u0010\u001d\u001a\u00020\u001eH\u0004J\u0010\u0010\u001f\u001a\u00020\u001a2\u0006\u0010 \u001a\u00020!H\u0002J\b\u0010\"\u001a\u00020\tH$J\b\u0010#\u001a\u00020\tH$J\u0006\u0010$\u001a\u00020\u001aR\u0014\u0010\u000b\u001a\u00020\fX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u000f\u001a\u00020\u0010X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0002\u001a\u00020\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0014\u0010\u0006\u001a\u00020\u0007X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0014\u0010\u0004\u001a\u00020\u0005X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lorg/jetbrains/kotlin/idea/core/script/dependencies/ScriptDependenciesLoader;", "", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "scriptDef", "Lorg/jetbrains/kotlin/script/KotlinScriptDefinition;", "project", "Lcom/intellij/openapi/project/Project;", "shouldNotifyRootsChanged", "", "(Lcom/intellij/openapi/vfs/VirtualFile;Lorg/jetbrains/kotlin/script/KotlinScriptDefinition;Lcom/intellij/openapi/project/Project;Z)V", "cache", "Lorg/jetbrains/kotlin/idea/core/script/ScriptDependenciesCache;", "getCache", "()Lorg/jetbrains/kotlin/idea/core/script/ScriptDependenciesCache;", "contentLoader", "Lorg/jetbrains/kotlin/script/ScriptContentLoader;", "getContentLoader", "()Lorg/jetbrains/kotlin/script/ScriptContentLoader;", "getFile", "()Lcom/intellij/openapi/vfs/VirtualFile;", "getProject", "()Lcom/intellij/openapi/project/Project;", "getScriptDef", "()Lorg/jetbrains/kotlin/script/KotlinScriptDefinition;", "loadDependencies", "", "notifyRootsChanged", "processResult", "result", "Lkotlin/script/experimental/dependencies/DependenciesResolver$ResolveResult;", "saveDependencies", "dependencies", "Lkotlin/script/experimental/dependencies/ScriptDependencies;", "shouldShowNotification", "shouldUseBackgroundThread", "updateDependencies", "Companion", "idea-core"})
public abstract class ScriptDependenciesLoader {
    @NotNull
    private final ScriptContentLoader contentLoader;
    @NotNull
    private final ScriptDependenciesCache cache;
    @NotNull
    private final VirtualFile file;
    @NotNull
    private final KotlinScriptDefinition scriptDef;
    @NotNull
    private final Project project;
    private final boolean shouldNotifyRootsChanged;
    private static final ConcurrentHashMap<VirtualFile, ScriptDependenciesLoader> loaders;
    public static final Companion Companion;

    public final void updateDependencies() {
        if (this.shouldUseBackgroundThread()) {
            new Task.Backgroundable(this, this.project, "Kotlin: Loading dependencies for " + this.file.getName() + " ...", true){
                final /* synthetic */ ScriptDependenciesLoader this$0;

                public void run(@NotNull ProgressIndicator indicator) {
                    Intrinsics.checkParameterIsNotNull((Object)indicator, (String)"indicator");
                    this.this$0.loadDependencies();
                }
                {
                    this.this$0 = $outer;
                    super($super_call_param$1, $super_call_param$2, $super_call_param$3);
                }
            }.queue();
        } else {
            this.loadDependencies();
        }
    }

    protected abstract void loadDependencies();

    protected abstract boolean shouldUseBackgroundThread();

    protected abstract boolean shouldShowNotification();

    @NotNull
    protected final ScriptContentLoader getContentLoader() {
        return this.contentLoader;
    }

    @NotNull
    protected final ScriptDependenciesCache getCache() {
        return this.cache;
    }

    /*
     * Enabled aggressive block sorting
     */
    protected final void processResult(@NotNull DependenciesResolver.ResolveResult result2) {
        Intrinsics.checkParameterIsNotNull((Object)result2, (String)"result");
        loaders.remove(this.file);
        ScriptReportSink scriptReportSink = (ScriptReportSink)ServiceManager.getService((Project)this.project, ScriptReportSink.class);
        if (scriptReportSink != null) {
            scriptReportSink.attachReports(this.file, result2.getReports());
        }
        ScriptDependencies scriptDependencies2 = result2.getDependencies();
        ScriptDependencies scriptDependencies3 = scriptDependencies2;
        if (scriptDependencies2 == null) return;
        ScriptDependencies scriptDependencies4 = ScriptContentLoaderKt.adjustByDefinition(scriptDependencies3, this.scriptDef);
        scriptDependencies3 = scriptDependencies4;
        if (scriptDependencies4 == null) return;
        ScriptDependencies newDependencies = scriptDependencies3;
        if (!(Intrinsics.areEqual((Object)this.cache.get(this.file), (Object)newDependencies) ^ true)) {
            if (!this.shouldShowNotification()) return;
            ScriptNewDependenciesNotificationKt.removeScriptDependenciesNotificationPanel(this.file, this.project);
            return;
        }
        if (this.shouldShowNotification() && this.cache.get(this.file) != null) {
            Application application = ApplicationManager.getApplication();
            Intrinsics.checkExpressionValueIsNotNull((Object)application, (String)"ApplicationManager.getApplication()");
            if (!application.isUnitTestMode()) {
                ScriptNewDependenciesNotificationKt.addScriptDependenciesNotificationPanel(this.file, newDependencies, this.project, (Function1<? super ScriptDependencies, Unit>)((Function1)new Function1<ScriptDependencies, Unit>(this, newDependencies){
                    final /* synthetic */ ScriptDependenciesLoader this$0;
                    final /* synthetic */ ScriptDependencies $newDependencies;

                    public final void invoke(@NotNull ScriptDependencies it) {
                        Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                        ScriptDependenciesLoader.access$saveDependencies(this.this$0, this.$newDependencies);
                    }
                    {
                        this.this$0 = scriptDependenciesLoader;
                        this.$newDependencies = scriptDependencies2;
                        super(1);
                    }
                }));
                return;
            }
        }
        this.saveDependencies(newDependencies);
    }

    private final void saveDependencies(ScriptDependencies dependencies2) {
        if (this.shouldShowNotification()) {
            ScriptNewDependenciesNotificationKt.removeScriptDependenciesNotificationPanel(this.file, this.project);
        }
        boolean rootsChanged = this.cache.hasNotCachedRoots(dependencies2);
        if (this.cache.save(this.file, dependencies2)) {
            ScriptDependenciesFileAttributeKt.setScriptDependencies(this.file, dependencies2);
        }
        if (rootsChanged) {
            this.notifyRootsChanged();
        }
    }

    protected final void notifyRootsChanged() {
        if (!this.shouldNotifyRootsChanged) {
            return;
        }
        Runnable doNotifyRootsChanged2 = new Runnable(this){
            final /* synthetic */ ScriptDependenciesLoader this$0;

            public final void run() {
                ApplicationUtilsKt.runWriteAction((Function0)new Function0<Unit>(this){
                    final /* synthetic */ notifyRootsChanged.doNotifyRootsChanged.1 this$0;

                    public final void invoke() {
                        if (this.this$0.this$0.getProject().isDisposed()) {
                            return;
                        }
                        ProjectRootManagerEx projectRootManagerEx = ProjectRootManagerEx.getInstanceEx((Project)this.this$0.this$0.getProject());
                        if (projectRootManagerEx != null) {
                            projectRootManagerEx.makeRootsChange(EmptyRunnable.getInstance(), false, true);
                        }
                        ScriptDependenciesModificationTracker.Companion.getInstance(this.this$0.this$0.getProject()).incModificationCount();
                    }
                    {
                        this.this$0 = var1_1;
                        super(0);
                    }
                });
            }
            {
                this.this$0 = scriptDependenciesLoader;
            }
        };
        Application application = ApplicationManager.getApplication();
        Intrinsics.checkExpressionValueIsNotNull((Object)application, (String)"ApplicationManager.getApplication()");
        if (application.isUnitTestMode()) {
            doNotifyRootsChanged2.run();
        } else {
            TransactionGuard.getInstance().submitTransactionLater((Disposable)this.project, doNotifyRootsChanged2);
        }
    }

    @NotNull
    protected final VirtualFile getFile() {
        return this.file;
    }

    @NotNull
    protected final KotlinScriptDefinition getScriptDef() {
        return this.scriptDef;
    }

    @NotNull
    protected final Project getProject() {
        return this.project;
    }

    public ScriptDependenciesLoader(@NotNull VirtualFile file, @NotNull KotlinScriptDefinition scriptDef, @NotNull Project project, boolean shouldNotifyRootsChanged) {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        Intrinsics.checkParameterIsNotNull((Object)((Object)scriptDef), (String)"scriptDef");
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        this.file = file;
        this.scriptDef = scriptDef;
        this.project = project;
        this.shouldNotifyRootsChanged = shouldNotifyRootsChanged;
        this.contentLoader = new ScriptContentLoader(this.project);
        Object object = ServiceManager.getService((Project)this.project, ScriptDependenciesCache.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"ServiceManager.getServic\u2026denciesCache::class.java)");
        this.cache = (ScriptDependenciesCache)object;
    }

    static {
        Companion = new Companion(null);
        loaders = new ConcurrentHashMap();
    }

    public static final /* synthetic */ void access$saveDependencies(ScriptDependenciesLoader $this, @NotNull ScriptDependencies dependencies2) {
        $this.saveDependencies(dependencies2);
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J&\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fR\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/idea/core/script/dependencies/ScriptDependenciesLoader$Companion;", "", "()V", "loaders", "Ljava/util/concurrent/ConcurrentHashMap;", "Lcom/intellij/openapi/vfs/VirtualFile;", "Lorg/jetbrains/kotlin/idea/core/script/dependencies/ScriptDependenciesLoader;", "updateDependencies", "", "file", "scriptDef", "Lorg/jetbrains/kotlin/script/KotlinScriptDefinition;", "project", "Lcom/intellij/openapi/project/Project;", "shouldNotifyRootsChanged", "", "idea-core"})
    public static final class Companion {
        public final void updateDependencies(@NotNull VirtualFile file, @NotNull KotlinScriptDefinition scriptDef, @NotNull Project project, boolean shouldNotifyRootsChanged) {
            Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
            Intrinsics.checkParameterIsNotNull((Object)((Object)scriptDef), (String)"scriptDef");
            Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
            ScriptDependenciesLoader existingLoader = (ScriptDependenciesLoader)loaders.get(file);
            if (existingLoader != null) {
                existingLoader.updateDependencies();
                return;
            }
            DependenciesResolver dependenciesResolver = scriptDef.getDependencyResolver();
            ScriptDependenciesLoader newLoader = dependenciesResolver instanceof AsyncDependenciesResolver || dependenciesResolver instanceof LegacyResolverWrapper ? (ScriptDependenciesLoader)new AsyncScriptDependenciesLoader(file, scriptDef, project) : (ScriptDependenciesLoader)new SyncScriptDependenciesLoader(file, scriptDef, project, shouldNotifyRootsChanged);
            loaders.put(file, newLoader);
            newLoader.updateDependencies();
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

