/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.editor;

import com.intellij.codeInsight.editorActions.JavaBackspaceHandler;
import com.intellij.codeInsight.editorActions.JavaTypedHandler;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.highlighter.HighlighterIterator;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import org.jetbrains.kotlin.lexer.KtToken;
import org.jetbrains.kotlin.lexer.KtTokens;

final class LtGtTypingUtils {
    private static final TokenSet INVALID_INSIDE_REFERENCE = TokenSet.create((IElementType[])new IElementType[]{KtTokens.SEMICOLON, KtTokens.LBRACE, KtTokens.RBRACE});

    private LtGtTypingUtils() {
    }

    static void handleKotlinAutoCloseLT(Editor editor) {
        JavaTypedHandler.handleAfterJavaLT((Editor)editor, (IElementType)KtTokens.LT, (IElementType)KtTokens.GT, (TokenSet)INVALID_INSIDE_REFERENCE);
    }

    static boolean handleKotlinGTInsert(Editor editor) {
        return JavaTypedHandler.handleJavaGT((Editor)editor, (IElementType)KtTokens.LT, (IElementType)KtTokens.GT, (TokenSet)INVALID_INSIDE_REFERENCE);
    }

    static void handleKotlinLTDeletion(Editor editor, int offset2) {
        JavaBackspaceHandler.handleLTDeletion((Editor)editor, (int)offset2, (IElementType)KtTokens.LT, (IElementType)KtTokens.GT, (TokenSet)INVALID_INSIDE_REFERENCE);
    }

    static boolean shouldAutoCloseAngleBracket(int offset2, Editor editor) {
        return LtGtTypingUtils.isAfterClassIdentifier(offset2, editor) || LtGtTypingUtils.isAfterToken(offset2, editor, KtTokens.FUN_KEYWORD);
    }

    private static boolean isAfterClassIdentifier(int offset2, Editor editor) {
        HighlighterIterator iterator2 = ((EditorEx)editor).getHighlighter().createIterator(offset2);
        if (iterator2.atEnd()) {
            return false;
        }
        if (iterator2.getStart() > 0) {
            iterator2.retreat();
        }
        return JavaTypedHandler.isClassLikeIdentifier((int)offset2, (Editor)editor, (HighlighterIterator)iterator2, (IElementType)KtTokens.IDENTIFIER);
    }

    static boolean isAfterToken(int offset2, Editor editor, KtToken tokenType) {
        HighlighterIterator iterator2 = ((EditorEx)editor).getHighlighter().createIterator(offset2);
        if (iterator2.atEnd()) {
            return false;
        }
        if (iterator2.getStart() > 0) {
            iterator2.retreat();
        }
        if (iterator2.getTokenType() == KtTokens.WHITE_SPACE && iterator2.getStart() > 0) {
            iterator2.retreat();
        }
        return iterator2.getTokenType() == tokenType;
    }
}

