/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.inspections;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.IntentionWrapper;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiRecursiveElementVisitor;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.inspections.AbstractKotlinInspection;
import org.jetbrains.kotlin.idea.inspections.IntentionBasedInspectionKt;
import org.jetbrains.kotlin.idea.inspections.NestedLambdaShadowedImplicitParameterInspection;
import org.jetbrains.kotlin.idea.inspections.NestedLambdaShadowedImplicitParameterInspectionKt;
import org.jetbrains.kotlin.idea.intentions.ReplaceItWithExplicitFunctionLiteralParamIntention;
import org.jetbrains.kotlin.idea.refactoring.rename.KotlinVariableInplaceRenameHandler;
import org.jetbrains.kotlin.psi.KtFunctionLiteral;
import org.jetbrains.kotlin.psi.KtLambdaExpression;
import org.jetbrains.kotlin.psi.KtNameReferenceExpression;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtParameterList;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.VisitorWrappersKt;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.calls.callUtil.CallUtilKt;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.lazy.BodyResolveMode;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\tB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\n"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/NestedLambdaShadowedImplicitParameterInspection;", "Lorg/jetbrains/kotlin/idea/inspections/AbstractKotlinInspection;", "()V", "buildVisitor", "Lcom/intellij/psi/PsiElementVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "", "AddExplicitParameterToOuterLambdaFix", "idea"})
public final class NestedLambdaShadowedImplicitParameterInspection
extends AbstractKotlinInspection {
    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        Intrinsics.checkParameterIsNotNull((Object)holder, (String)"holder");
        return VisitorWrappersKt.lambdaExpressionVisitor((Function1<? super KtLambdaExpression, Unit>)((Function1)new Function1<KtLambdaExpression, Unit>(holder){
            final /* synthetic */ ProblemsHolder $holder;

            /*
             * WARNING - void declaration
             */
            public final void invoke(@NotNull KtLambdaExpression lambda2) {
                void $receiver$iv;
                Intrinsics.checkParameterIsNotNull((Object)lambda2, (String)"lambda");
                List<KtParameter> list2 = lambda2.getValueParameters();
                Intrinsics.checkExpressionValueIsNotNull(list2, (String)"lambda.valueParameters");
                Collection collection = list2;
                if (!collection.isEmpty()) {
                    return;
                }
                BindingContext context = ResolutionUtils.analyze(lambda2, BodyResolveMode.PARTIAL);
                Object object = NestedLambdaShadowedImplicitParameterInspectionKt.access$functionDescriptor(lambda2, context);
                if (object == null || (object = object.getValueParameters()) == null || (object = (ValueParameterDescriptor)CollectionsKt.singleOrNull((List)object)) == null) {
                    return;
                }
                Object implicitParameter = object;
                if (NestedLambdaShadowedImplicitParameterInspectionKt.access$getParentImplicitParameterLambda(lambda2, context) == null) {
                    return;
                }
                PsiFile containingFile = lambda2.getContainingFile();
                PsiElement psiElement2 = (PsiElement)lambda2;
                Function1 action$iv = (Function1)new Function1<KtNameReferenceExpression, Unit>(this, (ValueParameterDescriptor)implicitParameter, context, containingFile){
                    final /* synthetic */ buildVisitor.1 this$0;
                    final /* synthetic */ ValueParameterDescriptor $implicitParameter;
                    final /* synthetic */ BindingContext $context;
                    final /* synthetic */ PsiFile $containingFile;

                    public final void invoke(@NotNull KtNameReferenceExpression it) {
                        Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                        if (Intrinsics.areEqual((Object)it.getText(), (Object)"it")) {
                            ResolvedCall<? extends CallableDescriptor> resolvedCall2 = CallUtilKt.getResolvedCall(it, this.$context);
                            if (Intrinsics.areEqual((Object)(resolvedCall2 != null ? resolvedCall2.getResultingDescriptor() : null), (Object)this.$implicitParameter)) {
                                this.this$0.$holder.registerProblem((PsiElement)it, "Implicit parameter 'it' of enclosing lambda is shadowed", ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new LocalQuickFix[]{new AddExplicitParameterToOuterLambdaFix(), (LocalQuickFix)new IntentionWrapper((IntentionAction)new ReplaceItWithExplicitFunctionLiteralParamIntention(), this.$containingFile)});
                            }
                        }
                    }
                    {
                        this.this$0 = var1_1;
                        this.$implicitParameter = valueParameterDescriptor;
                        this.$context = bindingContext2;
                        this.$containingFile = psiFile;
                        super(1);
                    }
                };
                void $receiver$iv$iv = $receiver$iv;
                $receiver$iv$iv.accept((PsiElementVisitor)new PsiRecursiveElementVisitor(action$iv){
                    final /* synthetic */ Function1 $action;
                    {
                        this.$action = $captured_local_variable$1;
                    }

                    public void visitElement(@NotNull PsiElement element3) {
                        Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
                        PsiElement it = element3;
                        super.visitElement(element3);
                        if (element3 instanceof KtNameReferenceExpression) {
                            this.$action.invoke((Object)element3);
                        }
                    }
                });
            }
            {
                this.$holder = problemsHolder;
                super(1);
            }
        }));
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\b\u0010\t\u001a\u00020\nH\u0016J\b\u0010\u000b\u001a\u00020\nH\u0016\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/NestedLambdaShadowedImplicitParameterInspection$AddExplicitParameterToOuterLambdaFix;", "Lcom/intellij/codeInspection/LocalQuickFix;", "()V", "applyFix", "", "project", "Lcom/intellij/openapi/project/Project;", "descriptor", "Lcom/intellij/codeInspection/ProblemDescriptor;", "getFamilyName", "", "getName", "idea"})
    private static final class AddExplicitParameterToOuterLambdaFix
    implements LocalQuickFix {
        @NotNull
        public String getName() {
            return "Add explicit parameter name to outer lambda";
        }

        @NotNull
        public String getFamilyName() {
            return this.getName();
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) {
            Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
            Intrinsics.checkParameterIsNotNull((Object)descriptor2, (String)"descriptor");
            PsiElement psiElement2 = descriptor2.getPsiElement();
            if (!(psiElement2 instanceof KtNameReferenceExpression)) {
                psiElement2 = null;
            }
            KtNameReferenceExpression ktNameReferenceExpression = (KtNameReferenceExpression)psiElement2;
            if (ktNameReferenceExpression == null) {
                return;
            }
            KtNameReferenceExpression implicitParameterReference = ktNameReferenceExpression;
            PsiElement $receiver$iv = (PsiElement)implicitParameterReference;
            KtLambdaExpression ktLambdaExpression = (KtLambdaExpression)PsiTreeUtil.getParentOfType((PsiElement)$receiver$iv, KtLambdaExpression.class, (boolean)true);
            if (ktLambdaExpression == null) {
                return;
            }
            KtLambdaExpression lambda2 = ktLambdaExpression;
            KtLambdaExpression ktLambdaExpression2 = NestedLambdaShadowedImplicitParameterInspectionKt.getParentImplicitParameterLambda$default(lambda2, null, 1, null);
            if (ktLambdaExpression2 == null) {
                return;
            }
            KtLambdaExpression parentLambda = ktLambdaExpression2;
            KtFunctionLiteral ktFunctionLiteral = parentLambda.getFunctionLiteral();
            Intrinsics.checkExpressionValueIsNotNull((Object)ktFunctionLiteral, (String)"parentLambda.functionLiteral");
            KtParameterList ktParameterList = KtPsiUtilKt.getOrCreateParameterList(ktFunctionLiteral);
            List<KtParameter> list2 = new KtPsiFactory(project, false, 2, null).createLambdaParameterList("it").getParameters();
            Intrinsics.checkExpressionValueIsNotNull(list2, (String)"KtPsiFactory(project).cr\u2026eterList(\"it\").parameters");
            KtParameter ktParameter = ktParameterList.addParameterBefore((KtParameter)CollectionsKt.first(list2), null);
            Intrinsics.checkExpressionValueIsNotNull((Object)ktParameter, (String)"parentLambda.functionLit\u2026rst(), null\n            )");
            KtParameter parameter = ktParameter;
            Editor editor = IntentionBasedInspectionKt.findExistingEditor((PsiElement)parentLambda);
            if (editor == null) {
                return;
            }
            Editor editor2 = editor;
            PsiDocumentManager.getInstance((Project)project).doPostponedOperationsAndUnblockDocument(editor2.getDocument());
            editor2.getCaretModel().moveToOffset(PsiUtilsKt.getStartOffset(parameter));
            new KotlinVariableInplaceRenameHandler().doRename(parameter, editor2, null);
        }
    }
}

