/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.inspections.collections;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiRecursiveElementWalkingVisitor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.DefaultBuiltIns;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.inspections.collections.ConvertCallChainIntoSequenceInspectionKt;
import org.jetbrains.kotlin.idea.intentions.UtilsKt;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtQualifiedExpression;
import org.jetbrains.kotlin.psi.KtReturnExpression;
import org.jetbrains.kotlin.psi.KtValueArgument;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.calls.callUtil.CallUtilKt;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.lazy.BodyResolveMode;
import org.jetbrains.kotlin.types.KotlinType;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=2, d1={"\u0000:\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u001a\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007*\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002\u001a\u001a\u0010\f\u001a\u0010\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\b\u0018\u00010\r*\u00020\tH\u0002\u001a\f\u0010\u000e\u001a\u00020\u000f*\u00020\bH\u0002\u001a\f\u0010\u0010\u001a\u00020\u000f*\u00020\u0011H\u0002\u001a\u0014\u0010\u0012\u001a\u00020\u000f*\u00020\b2\u0006\u0010\n\u001a\u00020\u000bH\u0002\u001a\u0014\u0010\u0013\u001a\u00020\u000f*\u00020\b2\u0006\u0010\n\u001a\u00020\u000bH\u0002\"\u001a\u0010\u0000\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"terminations", "", "", "Lorg/jetbrains/kotlin/name/FqName;", "transformationAndTerminations", "transformations", "collectCallExpression", "", "Lorg/jetbrains/kotlin/psi/KtCallExpression;", "Lorg/jetbrains/kotlin/psi/KtQualifiedExpression;", "context", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "findTarget", "Lkotlin/Pair;", "hasReturn", "", "isCollection", "Lorg/jetbrains/kotlin/types/KotlinType;", "isTermination", "isTransformationOrTermination", "idea"})
public final class ConvertCallChainIntoSequenceInspectionKt {
    private static final Map<String, FqName> transformations;
    private static final Map<String, FqName> terminations;
    private static final Map<String, FqName> transformationAndTerminations;

    private static final Pair<KtQualifiedExpression, KtCallExpression> findTarget(@NotNull KtQualifiedExpression $receiver) {
        KotlinType receiverType2;
        if ($receiver.getParent() instanceof KtQualifiedExpression) {
            return null;
        }
        BindingContext context = ResolutionUtils.analyze($receiver, BodyResolveMode.PARTIAL);
        List<KtCallExpression> calls = ConvertCallChainIntoSequenceInspectionKt.collectCallExpression($receiver, context);
        if (calls.isEmpty()) {
            return null;
        }
        Object object = KtPsiUtilKt.getQualifiedExpressionForSelector((KtElement)CollectionsKt.last(calls));
        KotlinType kotlinType = receiverType2 = object != null && (object = object.getReceiverExpression()) != null && (object = CallUtilKt.getResolvedCall((KtElement)object, context)) != null && (object = object.getResultingDescriptor()) != null ? object.getReturnType() : null;
        if (kotlinType == null || !ConvertCallChainIntoSequenceInspectionKt.isCollection(kotlinType)) {
            return null;
        }
        KtQualifiedExpression ktQualifiedExpression = KtPsiUtilKt.getQualifiedExpressionForSelector((KtElement)CollectionsKt.first(calls));
        if (ktQualifiedExpression == null) {
            return null;
        }
        KtQualifiedExpression qualified = ktQualifiedExpression;
        return TuplesKt.to((Object)qualified, (Object)CollectionsKt.last(calls));
    }

    private static final List<KtCallExpression> collectCallExpression(@NotNull KtQualifiedExpression $receiver, BindingContext context) {
        List calls = new ArrayList();
        Function1<KtQualifiedExpression, Unit> collect$ = new Function1<KtQualifiedExpression, Unit>(calls){
            final /* synthetic */ List $calls;

            public final void invoke(@NotNull KtQualifiedExpression qualified) {
                Intrinsics.checkParameterIsNotNull((Object)qualified, (String)"qualified");
                KtCallExpression ktCallExpression = UtilsKt.getCallExpression(qualified);
                if (ktCallExpression == null) {
                    return;
                }
                KtCallExpression call2 = ktCallExpression;
                this.$calls.add(call2);
                KtExpression receiver = qualified.getReceiverExpression();
                if (receiver instanceof KtQualifiedExpression) {
                    this.invoke((KtQualifiedExpression)receiver);
                }
            }
            {
                this.$calls = list2;
                super(1);
            }
        };
        collect$.invoke($receiver);
        if (calls.size() < 2) {
            return CollectionsKt.emptyList();
        }
        List transformationCalls2 = SequencesKt.toList((Sequence)SequencesKt.takeWhile((Sequence)SequencesKt.dropWhile((Sequence)CollectionsKt.asSequence((Iterable)calls), (Function1)((Function1)new Function1<KtCallExpression, Boolean>(context){
            final /* synthetic */ BindingContext $context;

            public final boolean invoke(@NotNull KtCallExpression it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                return !ConvertCallChainIntoSequenceInspectionKt.access$isTransformationOrTermination(it, this.$context);
            }
            {
                this.$context = bindingContext2;
                super(1);
            }
        })), (Function1)((Function1)new Function1<KtCallExpression, Boolean>(context){
            final /* synthetic */ BindingContext $context;

            public final boolean invoke(@NotNull KtCallExpression it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                return ConvertCallChainIntoSequenceInspectionKt.access$isTransformationOrTermination(it, this.$context) && !ConvertCallChainIntoSequenceInspectionKt.access$hasReturn(it);
            }
            {
                this.$context = bindingContext2;
                super(1);
            }
        })));
        if (transformationCalls2.size() < 2) {
            return CollectionsKt.emptyList();
        }
        return transformationCalls2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean isCollection(@NotNull KotlinType $receiver) {
        ClassifierDescriptor classifierDescriptor = $receiver.getConstructor().getDeclarationDescriptor();
        if (!(classifierDescriptor instanceof ClassDescriptor)) {
            classifierDescriptor = null;
        }
        ClassDescriptor classDescriptor2 = (ClassDescriptor)classifierDescriptor;
        if (classDescriptor2 == null) return false;
        ClassDescriptor classDescriptor3 = classDescriptor2;
        String string = classDescriptor3.getName().asString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"classDescriptor.name.asString()");
        String className2 = string;
        DefaultBuiltIns builtIns = DefaultBuiltIns.Companion.getInstance();
        if (StringsKt.endsWith$default((String)className2, (String)"List", (boolean)false, (int)2, null)) {
            ClassDescriptor classDescriptor4 = builtIns.getList();
            Intrinsics.checkExpressionValueIsNotNull((Object)classDescriptor4, (String)"builtIns.list");
            if (DescriptorUtilsKt.isSubclassOf(classDescriptor3, classDescriptor4)) return true;
        }
        if (!StringsKt.endsWith$default((String)className2, (String)"Set", (boolean)false, (int)2, null)) return false;
        ClassDescriptor classDescriptor5 = builtIns.getSet();
        Intrinsics.checkExpressionValueIsNotNull((Object)classDescriptor5, (String)"builtIns.set");
        if (!DescriptorUtilsKt.isSubclassOf(classDescriptor3, classDescriptor5)) return false;
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private static final boolean hasReturn(@NotNull KtCallExpression $receiver) {
        boolean bl;
        block3: {
            List<KtValueArgument> list2 = $receiver.getValueArguments();
            Intrinsics.checkExpressionValueIsNotNull(list2, (String)"valueArguments");
            Iterable $receiver$iv = list2;
            if ($receiver$iv instanceof Collection && ((Collection)$receiver$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $receiver$iv) {
                    void result$iv$iv$iv;
                    void $receiver$iv2;
                    void $receiver$iv$iv;
                    KtValueArgument arg;
                    KtValueArgument ktValueArgument = arg = (KtValueArgument)element$iv;
                    Intrinsics.checkExpressionValueIsNotNull((Object)ktValueArgument, (String)"arg");
                    PsiElement psiElement2 = (PsiElement)ktValueArgument;
                    Function1 predicate$iv = hasReturn.1.1.INSTANCE;
                    void $receiver$iv$iv$iv = $receiver$iv$iv = $receiver$iv2;
                    Ref.ObjectRef objectRef = new Ref.ObjectRef();
                    objectRef.element = null;
                    $receiver$iv$iv$iv.accept((PsiElementVisitor)new PsiRecursiveElementWalkingVisitor(predicate$iv, (Ref.ObjectRef)result$iv$iv$iv){
                        final /* synthetic */ Function1 $predicate;
                        final /* synthetic */ Ref.ObjectRef $result;
                        {
                            this.$predicate = $captured_local_variable$0;
                            this.$result = $captured_local_variable$1;
                        }

                        public void visitElement(@NotNull PsiElement element3) {
                            Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
                            if (element3 instanceof KtReturnExpression && ((Boolean)this.$predicate.invoke((Object)element3)).booleanValue()) {
                                this.$result.element = element3;
                                this.stopWalking();
                                return;
                            }
                            PsiElement it = element3;
                            super.visitElement(element3);
                        }
                    });
                    boolean bl2 = (PsiElement)result$iv$iv$iv.element != null;
                    if (!bl2) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    private static final boolean isTransformationOrTermination(@NotNull KtCallExpression $receiver, BindingContext context) {
        Map<String, FqName> map2 = transformationAndTerminations;
        KtExpression ktExpression = $receiver.getCalleeExpression();
        String string = ktExpression != null ? ktExpression.getText() : null;
        FqName fqName2 = map2.get(string);
        if (fqName2 == null) {
            return false;
        }
        FqName fqName3 = fqName2;
        ResolvedCall<? extends CallableDescriptor> resolvedCall2 = CallUtilKt.getResolvedCall($receiver, context);
        return Intrinsics.areEqual((Object)fqName3, resolvedCall2 != null && (resolvedCall2 = resolvedCall2.getResultingDescriptor()) != null ? DescriptorUtilsKt.getFqNameSafe((DeclarationDescriptor)((Object)resolvedCall2)) : null);
    }

    private static final boolean isTermination(@NotNull KtCallExpression $receiver, BindingContext context) {
        Map<String, FqName> map2 = terminations;
        KtExpression ktExpression = $receiver.getCalleeExpression();
        String string = ktExpression != null ? ktExpression.getText() : null;
        FqName fqName2 = map2.get(string);
        if (fqName2 == null) {
            return false;
        }
        FqName fqName3 = fqName2;
        ResolvedCall<? extends CallableDescriptor> resolvedCall2 = CallUtilKt.getResolvedCall($receiver, context);
        return Intrinsics.areEqual((Object)fqName3, resolvedCall2 != null && (resolvedCall2 = resolvedCall2.getResultingDescriptor()) != null ? DescriptorUtilsKt.getFqNameSafe((DeclarationDescriptor)((Object)resolvedCall2)) : null);
    }

    /*
     * WARNING - void declaration
     */
    static {
        void var3_3;
        String it;
        Map map2;
        Iterable $receiver$iv$iv;
        Iterable $receiver$iv = CollectionsKt.listOf((Object[])new String[]{"chunked", "distinct", "distinctBy", "drop", "dropWhile", "filter", "filterIndexed", "filterIsInstance", "filterNot", "filterNotNull", "map", "mapIndexed", "mapIndexedNotNull", "mapNotNull", "minus", "minusElement", "onEach", "plus", "plusElement", "requireNoNulls", "sorted", "sortedBy", "sortedByDescending", "sortedDescending", "sortedWith", "take", "takeWhile", "windowed", "withIndex", "zipWithNext"});
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10)), (int)16);
        Iterable iterable = $receiver$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        for (Object element$iv$iv : $receiver$iv$iv) {
            map2 = destination$iv$iv;
            it = (String)element$iv$iv;
            Pair pair2 = TuplesKt.to((Object)it, (Object)new FqName("kotlin.collections." + it));
            map2.put(pair2.getFirst(), pair2.getSecond());
        }
        transformations = destination$iv$iv;
        $receiver$iv = CollectionsKt.listOf((Object[])new String[]{"all", "any", "asIterable", "asSequence", "associate", "associateBy", "associateByTo", "associateTo", "average", "contains", "count", "elementAt", "elementAtOrElse", "elementAtOrNull", "filterIndexedTo", "filterIsInstanceTo", "filterNotNullTo", "filterNotTo", "filterTo", "find", "findLast", "first", "firstOrNull", "fold", "foldIndexed", "groupBy", "groupByTo", "groupingBy", "indexOf", "indexOfFirst", "indexOfLast", "joinTo", "joinToString", "last", "lastIndexOf", "lastOrNull", "mapIndexedNotNullTo", "mapIndexedTo", "mapNotNullTo", "mapTo", "max", "maxBy", "maxWith", "min", "minBy", "minWith", "none", "partition", "reduce", "reduceIndexed", "single", "singleOrNull", "sum", "sumBy", "sumByDouble", "toCollection", "toHashSet", "toList", "toMutableList", "toMutableSet", "toSet", "toSortedSet"});
        capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10)), (int)16);
        $receiver$iv$iv = $receiver$iv;
        destination$iv$iv = new LinkedHashMap(capacity$iv);
        for (Object element$iv$iv : $receiver$iv$iv) {
            map2 = destination$iv$iv;
            it = (String)element$iv$iv;
            String pkg = CollectionsKt.listOf((Object[])new String[]{"contains", "indexOf", "lastIndexOf"}).contains(it) ? "kotlin.collections.List" : "kotlin.collections";
            Pair pair3 = TuplesKt.to((Object)it, (Object)new FqName(pkg + '.' + it));
            map2.put(pair3.getFirst(), pair3.getSecond());
        }
        terminations = var3_3;
        transformationAndTerminations = MapsKt.plus(transformations, terminations);
    }

    @Nullable
    public static final /* synthetic */ Pair access$findTarget(@NotNull KtQualifiedExpression $receiver) {
        return ConvertCallChainIntoSequenceInspectionKt.findTarget($receiver);
    }

    @NotNull
    public static final /* synthetic */ List access$collectCallExpression(@NotNull KtQualifiedExpression $receiver, @NotNull BindingContext context) {
        return ConvertCallChainIntoSequenceInspectionKt.collectCallExpression($receiver, context);
    }

    public static final /* synthetic */ boolean access$isTermination(@NotNull KtCallExpression $receiver, @NotNull BindingContext context) {
        return ConvertCallChainIntoSequenceInspectionKt.isTermination($receiver, context);
    }

    public static final /* synthetic */ boolean access$isTransformationOrTermination(@NotNull KtCallExpression $receiver, @NotNull BindingContext context) {
        return ConvertCallChainIntoSequenceInspectionKt.isTransformationOrTermination($receiver, context);
    }

    public static final /* synthetic */ boolean access$hasReturn(@NotNull KtCallExpression $receiver) {
        return ConvertCallChainIntoSequenceInspectionKt.hasReturn($receiver);
    }
}

