/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.intentions;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptor;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.diagnostics.Severity;
import org.jetbrains.kotlin.idea.analysis.AnalyzerUtilKt;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.core.NotPropertiesService;
import org.jetbrains.kotlin.idea.core.PsiModificationUtilsKt;
import org.jetbrains.kotlin.idea.inspections.IntentionBasedInspection;
import org.jetbrains.kotlin.idea.intentions.ConvertToBlockBodyIntention;
import org.jetbrains.kotlin.idea.intentions.SelfTargetingOffsetIndependentIntention;
import org.jetbrains.kotlin.idea.intentions.UsePropertyAccessSyntaxInspection;
import org.jetbrains.kotlin.idea.resolve.ResolutionFacade;
import org.jetbrains.kotlin.idea.util.NotPropertyListKt;
import org.jetbrains.kotlin.idea.util.ScopeUtils;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.name.FqNameUnsafe;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.Call;
import org.jetbrains.kotlin.psi.CreateByPatternKt;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtDeclarationWithBody;
import org.jetbrains.kotlin.psi.KtDotQualifiedExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtNameReferenceExpression;
import org.jetbrains.kotlin.psi.KtParenthesizedExpression;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtPsiFactoryKt;
import org.jetbrains.kotlin.psi.KtQualifiedExpression;
import org.jetbrains.kotlin.psi.KtSafeQualifiedExpression;
import org.jetbrains.kotlin.psi.KtSuperExpression;
import org.jetbrains.kotlin.psi.KtValueArgument;
import org.jetbrains.kotlin.psi.KtValueArgumentList;
import org.jetbrains.kotlin.psi.LambdaArgument;
import org.jetbrains.kotlin.psi.ValueArgument;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import org.jetbrains.kotlin.renderer.RenderingUtilsKt;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.DelegatingBindingTrace;
import org.jetbrains.kotlin.resolve.bindingContextUtil.BindingContextUtilsKt;
import org.jetbrains.kotlin.resolve.calls.CallResolver;
import org.jetbrains.kotlin.resolve.calls.callUtil.CallUtilKt;
import org.jetbrains.kotlin.resolve.calls.context.BasicCallResolutionContext;
import org.jetbrains.kotlin.resolve.calls.context.CheckArgumentTypesMode;
import org.jetbrains.kotlin.resolve.calls.context.ContextDependency;
import org.jetbrains.kotlin.resolve.calls.model.ArgumentMappingKt;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.results.OverloadResolutionResults;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowInfo;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowValueFactory;
import org.jetbrains.kotlin.resolve.calls.util.DelegatingCall;
import org.jetbrains.kotlin.resolve.diagnostics.Diagnostics;
import org.jetbrains.kotlin.resolve.lazy.BodyResolveMode;
import org.jetbrains.kotlin.resolve.scopes.LexicalScope;
import org.jetbrains.kotlin.resolve.scopes.SyntheticScopes;
import org.jetbrains.kotlin.synthetic.JavaSyntheticPropertiesScopeKt;
import org.jetbrains.kotlin.synthetic.SyntheticJavaPropertyDescriptor;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u001a\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00022\b\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0016J\u001e\u0010\u0004\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rJH\u0010\u000e\u001a\u00020\r2\u000e\u0010\u000f\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00110\u00102\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\u0010\u0010\u001e\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u001f\u001a\u00020\u0002J\u001a\u0010 \u001a\u0004\u0018\u00010\u00132\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$H\u0002J\u0010\u0010%\u001a\u00020\r2\u0006\u0010\u0006\u001a\u00020\u0002H\u0016J\u0018\u0010&\u001a\u00020\t2\u0006\u0010\u001f\u001a\u00020\u00022\u0006\u0010\n\u001a\u00020\u000bH\u0002J \u0010'\u001a\u00020\t2\u0006\u0010\u001f\u001a\u00020\u00022\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002\u00a8\u0006("}, d2={"Lorg/jetbrains/kotlin/idea/intentions/UsePropertyAccessSyntaxIntention;", "Lorg/jetbrains/kotlin/idea/intentions/SelfTargetingOffsetIndependentIntention;", "Lorg/jetbrains/kotlin/psi/KtCallExpression;", "()V", "applyTo", "", "element", "editor", "Lcom/intellij/openapi/editor/Editor;", "Lorg/jetbrains/kotlin/psi/KtExpression;", "propertyName", "Lorg/jetbrains/kotlin/name/Name;", "reformat", "", "checkWillResolveToProperty", "resolvedCall", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "Lorg/jetbrains/kotlin/descriptors/CallableDescriptor;", "property", "Lorg/jetbrains/kotlin/synthetic/SyntheticJavaPropertyDescriptor;", "bindingContext", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "resolutionScope", "Lorg/jetbrains/kotlin/resolve/scopes/LexicalScope;", "dataFlowInfo", "Lorg/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowInfo;", "expectedType", "Lorg/jetbrains/kotlin/types/KotlinType;", "facade", "Lorg/jetbrains/kotlin/idea/resolve/ResolutionFacade;", "detectPropertyNameToUse", "callExpression", "findSyntheticProperty", "function", "Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "syntheticScopes", "Lorg/jetbrains/kotlin/resolve/scopes/SyntheticScopes;", "isApplicableTo", "replaceWithPropertyGet", "replaceWithPropertySet", "idea"})
public final class UsePropertyAccessSyntaxIntention
extends SelfTargetingOffsetIndependentIntention<KtCallExpression> {
    @Override
    public boolean isApplicableTo(@NotNull KtCallExpression element3) {
        Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
        return this.detectPropertyNameToUse(element3) != null;
    }

    @Override
    public void applyTo(@NotNull KtCallExpression element3, @Nullable Editor editor) {
        Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
        Name name2 = this.detectPropertyNameToUse(element3);
        if (name2 == null) {
            Intrinsics.throwNpe();
        }
        this.applyTo(element3, name2, true);
    }

    @NotNull
    public final KtExpression applyTo(@NotNull KtCallExpression element3, @NotNull Name propertyName, boolean reformat) {
        KtExpression ktExpression;
        Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
        Intrinsics.checkParameterIsNotNull((Object)propertyName, (String)"propertyName");
        List<KtValueArgument> list2 = element3.getValueArguments();
        Intrinsics.checkExpressionValueIsNotNull(list2, (String)"element.valueArguments");
        List<KtValueArgument> arguments2 = list2;
        switch (arguments2.size()) {
            case 0: {
                ktExpression = this.replaceWithPropertyGet(element3, propertyName);
                break;
            }
            case 1: {
                ktExpression = this.replaceWithPropertySet(element3, propertyName, reformat);
                break;
            }
            default: {
                String string = "More than one argument in call to accessor";
                throw (Throwable)new IllegalStateException(string.toString());
            }
        }
        return ktExpression;
    }

    @Nullable
    public final Name detectPropertyNameToUse(@NotNull KtCallExpression callExpression2) {
        boolean isSetUsage;
        boolean bl;
        SyntheticJavaPropertyDescriptor property;
        LexicalScope resolutionScope;
        FunctionDescriptor function2;
        ResolvedCall<? extends CallableDescriptor> resolvedCall2;
        BindingContext bindingContext2;
        ResolutionFacade resolutionFacade;
        KtNameReferenceExpression callee;
        block28: {
            IElementType[] $receiver$iv;
            Object notProperties;
            Object object;
            Intrinsics.checkParameterIsNotNull((Object)callExpression2, (String)"callExpression");
            KtQualifiedExpression ktQualifiedExpression = KtPsiUtilKt.getQualifiedExpressionForSelector(callExpression2);
            if ((ktQualifiedExpression != null ? ktQualifiedExpression.getReceiverExpression() : null) instanceof KtSuperExpression) {
                return null;
            }
            KtExpression ktExpression = callExpression2.getCalleeExpression();
            if (!(ktExpression instanceof KtNameReferenceExpression)) {
                ktExpression = null;
            }
            KtNameReferenceExpression ktNameReferenceExpression = (KtNameReferenceExpression)ktExpression;
            if (ktNameReferenceExpression == null) {
                return null;
            }
            callee = ktNameReferenceExpression;
            if (!JavaSyntheticPropertiesScopeKt.canBePropertyAccessor(callee.getReferencedName())) {
                return null;
            }
            resolutionFacade = ResolutionUtils.getResolutionFacade(callExpression2);
            bindingContext2 = resolutionFacade.analyze(callExpression2, BodyResolveMode.PARTIAL_FOR_COMPLETION);
            ResolvedCall<? extends CallableDescriptor> resolvedCall3 = CallUtilKt.getResolvedCall(callExpression2, bindingContext2);
            if (resolvedCall3 == null) {
                return null;
            }
            resolvedCall2 = resolvedCall3;
            if (!ArgumentMappingKt.isReallySuccess(resolvedCall2)) {
                return null;
            }
            CallableDescriptor callableDescriptor = resolvedCall2.getResultingDescriptor();
            if (!(callableDescriptor instanceof FunctionDescriptor)) {
                callableDescriptor = null;
            }
            FunctionDescriptor functionDescriptor2 = (FunctionDescriptor)callableDescriptor;
            if (functionDescriptor2 == null) {
                return null;
            }
            function2 = functionDescriptor2;
            IntentionBasedInspection intentionBasedInspection = this.getInspection();
            if (!(intentionBasedInspection instanceof UsePropertyAccessSyntaxInspection)) {
                intentionBasedInspection = null;
            }
            if ((object = (UsePropertyAccessSyntaxInspection)intentionBasedInspection) == null || (object = object.getFqNameList()) == null || (object = CollectionsKt.toSet((Iterable)((Iterable)object))) == null) {
                object = notProperties = NotPropertiesService.Companion.getNotProperties((PsiElement)callExpression2);
            }
            if (NotPropertyListKt.shouldNotConvertToProperty(function2, (Set<FqNameUnsafe>)notProperties)) {
                return null;
            }
            resolutionScope = ScopeUtils.getResolutionScope((PsiElement)callExpression2, bindingContext2, resolutionFacade);
            SyntheticJavaPropertyDescriptor syntheticJavaPropertyDescriptor = this.findSyntheticProperty(function2, resolutionFacade.getFrontendService(SyntheticScopes.class));
            if (syntheticJavaPropertyDescriptor == null) {
                return null;
            }
            property = syntheticJavaPropertyDescriptor;
            TokenSet tokenSet = KtTokens.KEYWORDS;
            Intrinsics.checkExpressionValueIsNotNull((Object)tokenSet, (String)"KtTokens.KEYWORDS");
            IElementType[] iElementTypeArray = tokenSet.getTypes();
            Intrinsics.checkExpressionValueIsNotNull((Object)iElementTypeArray, (String)"KtTokens.KEYWORDS.types");
            for (IElementType element$iv : $receiver$iv = iElementTypeArray) {
                IElementType it = element$iv;
                if (!Intrinsics.areEqual((Object)it.toString(), (Object)property.getName().asString())) continue;
                bl = true;
                break block28;
            }
            bl = false;
        }
        if (bl) {
            return null;
        }
        DataFlowInfo dataFlowInfo = BindingContextUtilsKt.getDataFlowInfoBefore(bindingContext2, (PsiElement)callee);
        KtExpression qualifiedExpression = KtPsiUtilKt.getQualifiedExpressionForSelectorOrThis(callExpression2);
        KotlinType kotlinType = (KotlinType)bindingContext2.get(BindingContext.EXPECTED_EXPRESSION_TYPE, qualifiedExpression);
        if (kotlinType == null) {
            kotlinType = TypeUtils.NO_EXPECTED_TYPE;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)kotlinType, (String)"bindingContext[BindingCo\u2026ypeUtils.NO_EXPECTED_TYPE");
        KotlinType expectedType = kotlinType;
        if (!this.checkWillResolveToProperty(resolvedCall2, property, bindingContext2, resolutionScope, dataFlowInfo, expectedType, resolutionFacade)) {
            return null;
        }
        boolean bl2 = isSetUsage = callExpression2.getValueArguments().size() == 1;
        if (isSetUsage && BindingContextUtilsKt.isUsedAsExpression(qualifiedExpression, bindingContext2)) {
            PsiElement parent2 = qualifiedExpression.getParent();
            if (!(parent2 instanceof KtDeclarationWithBody) || Intrinsics.areEqual((Object)qualifiedExpression, (Object)((KtDeclarationWithBody)parent2).getBodyExpression()) ^ true) {
                return null;
            }
            KotlinType kotlinType2 = function2.getReturnType();
            if (kotlinType2 == null || !TypeUtilsKt.isUnit(kotlinType2)) {
                return null;
            }
        }
        if (isSetUsage) {
            KotlinType kotlinType3 = property.getType();
            List<ValueParameterDescriptor> list2 = function2.getValueParameters();
            Intrinsics.checkExpressionValueIsNotNull(list2, (String)"function.valueParameters");
            Object object = CollectionsKt.single(list2);
            Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"function.valueParameters.single()");
            if (Intrinsics.areEqual((Object)kotlinType3, (Object)((ValueParameterDescriptor)object).getType()) ^ true) {
                boolean bl3;
                block29: {
                    KtExpression ktExpression;
                    KtExpression qualifiedExpressionCopy = (KtExpression)PsiModificationUtilsKt.copied((PsiElement)qualifiedExpression);
                    KtExpression ktExpression2 = qualifiedExpressionCopy;
                    if (!(ktExpression2 instanceof KtQualifiedExpression)) {
                        ktExpression2 = null;
                    }
                    if ((ktExpression = (KtQualifiedExpression)ktExpression2) == null || (ktExpression = ktExpression.getSelectorExpression()) == null) {
                        ktExpression = qualifiedExpressionCopy;
                    }
                    if (ktExpression == null) {
                        throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtCallExpression");
                    }
                    KtCallExpression callExpressionCopy = (KtCallExpression)ktExpression;
                    Name name2 = property.getName();
                    Intrinsics.checkExpressionValueIsNotNull((Object)name2, (String)"property.name");
                    KtExpression newExpression2 = this.applyTo(callExpressionCopy, name2, false);
                    DelegatingBindingTrace bindingTrace = new DelegatingBindingTrace(bindingContext2, "Temporary trace", false, null, false, 28, null);
                    BindingContext newBindingContext = AnalyzerUtilKt.analyzeInContext$default(newExpression2, resolutionScope, callExpression2, bindingTrace, dataFlowInfo, expectedType, true, null, null, 192, null);
                    Diagnostics diagnostics2 = newBindingContext.getDiagnostics();
                    Intrinsics.checkExpressionValueIsNotNull((Object)diagnostics2, (String)"newBindingContext.diagnostics");
                    Iterable $receiver$iv = diagnostics2;
                    if ($receiver$iv instanceof Collection && ((Collection)$receiver$iv).isEmpty()) {
                        bl3 = false;
                    } else {
                        for (Object element$iv : $receiver$iv) {
                            Diagnostic it = (Diagnostic)element$iv;
                            if (!(it.getSeverity() == Severity.ERROR)) continue;
                            bl3 = true;
                            break block29;
                        }
                        bl3 = false;
                    }
                }
                if (bl3) {
                    return null;
                }
            }
        }
        return property.getName();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean checkWillResolveToProperty(ResolvedCall<? extends CallableDescriptor> resolvedCall2, SyntheticJavaPropertyDescriptor property, BindingContext bindingContext2, LexicalScope resolutionScope, DataFlowInfo dataFlowInfo, KotlinType expectedType, ResolutionFacade facade) {
        ResolutionFacade $receiver$iv;
        Call call2 = resolvedCall2.getCall();
        Intrinsics.checkExpressionValueIsNotNull((Object)call2, (String)"resolvedCall.call");
        KtElement ktElement = call2.getCallElement();
        Intrinsics.checkExpressionValueIsNotNull((Object)ktElement, (String)"resolvedCall.call.callElement");
        Project project = ktElement.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"resolvedCall.call.callElement.project");
        Project project2 = project;
        DelegatingCall newCall2 = new DelegatingCall(project2, property, resolvedCall2, resolvedCall2.getCall()){
            private final KtExpression newCallee;
            final /* synthetic */ Project $project;
            final /* synthetic */ SyntheticJavaPropertyDescriptor $property;
            final /* synthetic */ ResolvedCall $resolvedCall;

            @NotNull
            public KtExpression getCalleeExpression() {
                return this.newCallee;
            }

            @Nullable
            public KtValueArgumentList getValueArgumentList() {
                return null;
            }

            @NotNull
            public List<ValueArgument> getValueArguments() {
                return CollectionsKt.emptyList();
            }

            @NotNull
            public List<LambdaArgument> getFunctionLiteralArguments() {
                return CollectionsKt.emptyList();
            }
            {
                this.$project = $captured_local_variable$0;
                this.$property = $captured_local_variable$1;
                this.$resolvedCall = $captured_local_variable$2;
                super($super_call_param$3);
                KtPsiFactory ktPsiFactory = new KtPsiFactory($captured_local_variable$0, false, 2, null);
                Object[] objectArray = new Object[1];
                Name name2 = $captured_local_variable$1.getName();
                Intrinsics.checkExpressionValueIsNotNull((Object)name2, (String)"property.name");
                objectArray[0] = name2;
                Object[] objectArray2 = objectArray;
                boolean bl = false;
                this.newCallee = CreateByPatternKt.createExpressionByPattern(ktPsiFactory, "$0", objectArray2, bl);
            }
        };
        DelegatingBindingTrace bindingTrace = new DelegatingBindingTrace(bindingContext2, "Temporary trace", false, null, false, 28, null);
        ResolutionFacade resolutionFacade = facade;
        boolean bl = false;
        CheckArgumentTypesMode checkArgumentTypesMode = CheckArgumentTypesMode.CHECK_VALUE_ARGUMENTS;
        ContextDependency contextDependency = ContextDependency.INDEPENDENT;
        DataFlowInfo dataFlowInfo2 = dataFlowInfo;
        KotlinType kotlinType = expectedType;
        Call call3 = newCall2;
        LexicalScope lexicalScope = resolutionScope;
        BindingTrace bindingTrace2 = bindingTrace;
        LanguageVersionSettings languageVersionSettings = $receiver$iv.getFrontendService(LanguageVersionSettings.class);
        $receiver$iv = facade;
        DataFlowValueFactory dataFlowValueFactory = $receiver$iv.getFrontendService(DataFlowValueFactory.class);
        BasicCallResolutionContext basicCallResolutionContext = BasicCallResolutionContext.create(bindingTrace2, lexicalScope, call3, kotlinType, dataFlowInfo2, contextDependency, checkArgumentTypesMode, bl, languageVersionSettings, dataFlowValueFactory);
        Intrinsics.checkExpressionValueIsNotNull((Object)basicCallResolutionContext, (String)"BasicCallResolutionConte\u2026ValueFactory>()\n        )");
        BasicCallResolutionContext context = basicCallResolutionContext;
        ResolutionFacade $receiver$iv2 = facade;
        CallResolver callResolver = $receiver$iv2.getFrontendService(CallResolver.class);
        OverloadResolutionResults<VariableDescriptor> overloadResolutionResults = callResolver.resolveSimpleProperty(context);
        Intrinsics.checkExpressionValueIsNotNull(overloadResolutionResults, (String)"callResolver.resolveSimpleProperty(context)");
        OverloadResolutionResults<VariableDescriptor> result2 = overloadResolutionResults;
        if (!result2.isSuccess()) return false;
        VariableDescriptor variableDescriptor = result2.getResultingDescriptor();
        Intrinsics.checkExpressionValueIsNotNull((Object)variableDescriptor, (String)"result.resultingDescriptor");
        if (!Intrinsics.areEqual((Object)variableDescriptor.getOriginal(), (Object)property)) return false;
        return true;
    }

    private final SyntheticJavaPropertyDescriptor findSyntheticProperty(FunctionDescriptor function2, SyntheticScopes syntheticScopes) {
        SyntheticJavaPropertyDescriptor syntheticJavaPropertyDescriptor = SyntheticJavaPropertyDescriptor.Companion.findByGetterOrSetter(function2, syntheticScopes);
        if (syntheticJavaPropertyDescriptor != null) {
            SyntheticJavaPropertyDescriptor syntheticJavaPropertyDescriptor2;
            SyntheticJavaPropertyDescriptor it = syntheticJavaPropertyDescriptor2 = syntheticJavaPropertyDescriptor;
            return it;
        }
        Iterator<? extends FunctionDescriptor> iterator2 = function2.getOverriddenDescriptors().iterator();
        while (iterator2.hasNext()) {
            SyntheticJavaPropertyDescriptor syntheticJavaPropertyDescriptor3;
            FunctionDescriptor overridden;
            FunctionDescriptor functionDescriptor2 = overridden = iterator2.next();
            Intrinsics.checkExpressionValueIsNotNull((Object)functionDescriptor2, (String)"overridden");
            SyntheticJavaPropertyDescriptor syntheticJavaPropertyDescriptor4 = this.findSyntheticProperty(functionDescriptor2, syntheticScopes);
            if (syntheticJavaPropertyDescriptor4 == null) continue;
            SyntheticJavaPropertyDescriptor it = syntheticJavaPropertyDescriptor3 = syntheticJavaPropertyDescriptor4;
            return it;
        }
        return null;
    }

    private final KtExpression replaceWithPropertyGet(KtCallExpression callExpression2, Name propertyName) {
        KtExpression ktExpression;
        PsiElement $receiver$iv = (PsiElement)callExpression2;
        KtExpression newExpression2 = KtPsiFactoryKt.KtPsiFactory$default((PsiElement)callExpression2, false, 2, null).createExpression(RenderingUtilsKt.render(propertyName));
        PsiElement result$iv = $receiver$iv.replace((PsiElement)newExpression2);
        PsiElement psiElement2 = result$iv;
        if (!(psiElement2 instanceof KtExpression)) {
            psiElement2 = null;
        }
        if ((ktExpression = (KtExpression)psiElement2) == null) {
            PsiElement psiElement3 = result$iv;
            if (psiElement3 == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtParenthesizedExpression");
            }
            ktExpression = ((KtParenthesizedExpression)psiElement3).getExpression();
            if (ktExpression == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtExpression");
            }
        }
        return ktExpression;
    }

    private final KtExpression replaceWithPropertySet(KtCallExpression callExpression2, Name propertyName, boolean reformat) {
        KtExpression ktExpression;
        KtQualifiedExpression ktQualifiedExpression = KtPsiUtilKt.getQualifiedExpressionForSelector(callExpression2);
        KtExpression call2 = ktQualifiedExpression != null ? (KtExpression)ktQualifiedExpression : (KtExpression)callExpression2;
        PsiElement callParent = call2.getParent();
        KtCallExpression callToConvert = callExpression2;
        if (callParent instanceof KtDeclarationWithBody && Intrinsics.areEqual((Object)call2, (Object)((KtDeclarationWithBody)callParent).getBodyExpression())) {
            KtCallExpression ktCallExpression;
            Object object;
            KtExpression firstStatement;
            KtExpression ktExpression2;
            ConvertToBlockBodyIntention.Companion.convert((KtDeclarationWithBody)callParent);
            KtExpression ktExpression3 = ((KtDeclarationWithBody)callParent).getBodyExpression();
            if (!(ktExpression3 instanceof KtBlockExpression)) {
                ktExpression3 = null;
            }
            if (!((ktExpression2 = (firstStatement = (object = (KtBlockExpression)ktExpression3) != null && (object = ((KtBlockExpression)object).getStatements()) != null ? (KtExpression)CollectionsKt.first((List)object) : null)) instanceof KtQualifiedExpression)) {
                ktExpression2 = null;
            }
            KtQualifiedExpression ktQualifiedExpression2 = (KtQualifiedExpression)ktExpression2;
            KtExpression ktExpression4 = ktQualifiedExpression2 != null ? ktQualifiedExpression2.getSelectorExpression() : null;
            if (!(ktExpression4 instanceof KtCallExpression)) {
                ktExpression4 = null;
            }
            if ((ktCallExpression = (KtCallExpression)ktExpression4) == null) {
                KtExpression ktExpression5 = firstStatement;
                if (!(ktExpression5 instanceof KtCallExpression)) {
                    ktExpression5 = null;
                }
                ktCallExpression = (KtCallExpression)ktExpression5;
            }
            if (ktCallExpression == null) {
                throw (Throwable)new IllegalStateException("Unexpected contents of function after conversion: " + ((KtDeclarationWithBody)callParent).getText());
            }
            callToConvert = ktCallExpression;
        }
        KtQualifiedExpression qualifiedExpression = KtPsiUtilKt.getQualifiedExpressionForSelector(callToConvert);
        List<KtValueArgument> list2 = callToConvert.getValueArguments();
        Intrinsics.checkExpressionValueIsNotNull(list2, (String)"callToConvert.valueArguments");
        KtValueArgument argument2 = (KtValueArgument)CollectionsKt.single(list2);
        if (qualifiedExpression != null) {
            KtExpression ktExpression6;
            String string;
            KtQualifiedExpression ktQualifiedExpression3 = qualifiedExpression;
            if (ktQualifiedExpression3 instanceof KtDotQualifiedExpression) {
                string = "$0.$1=$2";
            } else if (ktQualifiedExpression3 instanceof KtSafeQualifiedExpression) {
                string = "$0?.$1=$2";
            } else {
                throw (Throwable)new IllegalStateException(qualifiedExpression.toString());
            }
            String pattern = string;
            KtPsiFactory ktPsiFactory = KtPsiFactoryKt.KtPsiFactory$default((PsiElement)callToConvert, false, 2, null);
            Object[] objectArray = new Object[3];
            objectArray[0] = qualifiedExpression.getReceiverExpression();
            objectArray[1] = propertyName;
            KtExpression ktExpression7 = argument2.getArgumentExpression();
            if (ktExpression7 == null) {
                Intrinsics.throwNpe();
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)ktExpression7, (String)"argument.getArgumentExpression()!!");
            objectArray[2] = ktExpression7;
            Object[] objectArray2 = objectArray;
            boolean bl = reformat;
            KtExpression newExpression2 = CreateByPatternKt.createExpressionByPattern(ktPsiFactory, pattern, objectArray2, bl);
            PsiElement $receiver$iv = (PsiElement)qualifiedExpression;
            PsiElement result$iv = $receiver$iv.replace((PsiElement)newExpression2);
            PsiElement psiElement2 = result$iv;
            if (!(psiElement2 instanceof KtExpression)) {
                psiElement2 = null;
            }
            if ((ktExpression6 = (KtExpression)psiElement2) == null) {
                PsiElement psiElement3 = result$iv;
                if (psiElement3 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtParenthesizedExpression");
                }
                ktExpression6 = ((KtParenthesizedExpression)psiElement3).getExpression();
                if (ktExpression6 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtExpression");
                }
            }
            return ktExpression6;
        }
        KtPsiFactory ktPsiFactory = KtPsiFactoryKt.KtPsiFactory$default((PsiElement)callToConvert, false, 2, null);
        Object[] objectArray = new Object[2];
        objectArray[0] = propertyName;
        KtExpression ktExpression8 = argument2.getArgumentExpression();
        if (ktExpression8 == null) {
            Intrinsics.throwNpe();
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)ktExpression8, (String)"argument.getArgumentExpression()!!");
        objectArray[1] = ktExpression8;
        KtExpression newExpression3 = CreateByPatternKt.createExpressionByPattern$default(ktPsiFactory, "$0=$1", objectArray, false, 4, null);
        PsiElement $receiver$iv = (PsiElement)callToConvert;
        PsiElement result$iv = $receiver$iv.replace((PsiElement)newExpression3);
        PsiElement psiElement4 = result$iv;
        if (!(psiElement4 instanceof KtExpression)) {
            psiElement4 = null;
        }
        if ((ktExpression = (KtExpression)psiElement4) == null) {
            PsiElement psiElement5 = result$iv;
            if (psiElement5 == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtParenthesizedExpression");
            }
            ktExpression = ((KtParenthesizedExpression)psiElement5).getExpression();
            if (ktExpression == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtExpression");
            }
        }
        return ktExpression;
    }

    public UsePropertyAccessSyntaxIntention() {
        super(KtCallExpression.class, "Use property access syntax", null, 4, null);
    }
}

