/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.projectView;

import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.projectView.ViewSettings;
import com.intellij.ide.projectView.impl.nodes.AbstractPsiBasedNode;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.kotlin.idea.core.formatter.KotlinCodeStyleSettings;
import org.jetbrains.kotlin.psi.KtAnonymousInitializer;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtModifierListOwner;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPsiUtil;
import org.jetbrains.kotlin.psi.KtTypeReference;

public class KtDeclarationTreeNode
extends AbstractPsiBasedNode<KtDeclaration> {
    public static final String CLASS_INITIALIZER = "<class initializer>";

    protected KtDeclarationTreeNode(Project project, KtDeclaration ktDeclaration, ViewSettings viewSettings) {
        super(project, (Object)ktDeclaration, viewSettings);
    }

    protected PsiElement extractPsiFromValue() {
        return (PsiElement)this.getValue();
    }

    protected Collection<AbstractTreeNode> getChildrenImpl() {
        return Collections.emptyList();
    }

    protected void updateImpl(PresentationData data) {
        KtDeclaration declaration2 = (KtDeclaration)this.getValue();
        if (declaration2 != null) {
            String text2;
            String string = text2 = declaration2 instanceof KtAnonymousInitializer ? CLASS_INITIALIZER : declaration2.getName();
            if (text2 == null) {
                return;
            }
            KotlinCodeStyleSettings settings2 = (KotlinCodeStyleSettings)CodeStyleSettingsManager.getInstance((Project)this.getProject()).getCurrentSettings().getCustomSettings(KotlinCodeStyleSettings.class);
            if (declaration2 instanceof KtProperty) {
                KtProperty property = (KtProperty)declaration2;
                KtTypeReference ref = property.getTypeReference();
                if (ref != null) {
                    if (settings2.SPACE_BEFORE_TYPE_COLON) {
                        text2 = text2 + " ";
                    }
                    text2 = text2 + ":";
                    if (settings2.SPACE_AFTER_TYPE_COLON) {
                        text2 = text2 + " ";
                    }
                    text2 = text2 + ref.getText();
                }
            } else if (declaration2 instanceof KtFunction) {
                KtFunction function2 = (KtFunction)declaration2;
                KtTypeReference receiverTypeRef = function2.getReceiverTypeReference();
                if (receiverTypeRef != null) {
                    text2 = receiverTypeRef.getText() + "." + text2;
                }
                text2 = text2 + "(";
                List<KtParameter> parameters2 = function2.getValueParameters();
                for (KtParameter parameter : parameters2) {
                    KtTypeReference typeReference;
                    if (parameter.getName() != null) {
                        text2 = text2 + parameter.getName();
                        if (settings2.SPACE_BEFORE_TYPE_COLON) {
                            text2 = text2 + " ";
                        }
                        text2 = text2 + ":";
                        if (settings2.SPACE_AFTER_TYPE_COLON) {
                            text2 = text2 + " ";
                        }
                    }
                    if ((typeReference = parameter.getTypeReference()) != null) {
                        text2 = text2 + typeReference.getText();
                    }
                    text2 = text2 + ", ";
                }
                if (parameters2.size() > 0) {
                    text2 = text2.substring(0, text2.length() - 2);
                }
                text2 = text2 + ")";
                KtTypeReference typeReference = function2.getTypeReference();
                if (typeReference != null) {
                    if (settings2.SPACE_BEFORE_TYPE_COLON) {
                        text2 = text2 + " ";
                    }
                    text2 = text2 + ":";
                    if (settings2.SPACE_AFTER_TYPE_COLON) {
                        text2 = text2 + " ";
                    }
                    text2 = text2 + typeReference.getText();
                }
            }
            data.setPresentableText(text2);
        }
    }

    protected boolean isDeprecated() {
        return KtPsiUtil.isDeprecated((KtModifierListOwner)this.getValue());
    }
}

