/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.refactoring.cutPaste;

import com.intellij.codeHighlighting.TextEditorHighlightingPass;
import com.intellij.codeHighlighting.TextEditorHighlightingPassFactory;
import com.intellij.codeHighlighting.TextEditorHighlightingPassRegistrar;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.HighlightInfoType;
import com.intellij.codeInsight.daemon.impl.UpdateHighlightersUtil;
import com.intellij.codeInsight.daemon.impl.quickfix.QuickFixAction;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.components.AbstractProjectComponent;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiModificationTracker;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.conversion.copy.RangeUtilsKt;
import org.jetbrains.kotlin.idea.refactoring.cutPaste.MoveDeclarationsEditorCookie;
import org.jetbrains.kotlin.idea.refactoring.cutPaste.MoveDeclarationsIntentionAction;
import org.jetbrains.kotlin.idea.refactoring.cutPaste.MoveDeclarationsProcessor;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002:\u0001\u000eB\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u001a\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/idea/refactoring/cutPaste/MoveDeclarationsPassFactory;", "Lcom/intellij/openapi/components/AbstractProjectComponent;", "Lcom/intellij/codeHighlighting/TextEditorHighlightingPassFactory;", "project", "Lcom/intellij/openapi/project/Project;", "highlightingPassRegistrar", "Lcom/intellij/codeHighlighting/TextEditorHighlightingPassRegistrar;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/codeHighlighting/TextEditorHighlightingPassRegistrar;)V", "createHighlightingPass", "Lcom/intellij/codeHighlighting/TextEditorHighlightingPass;", "file", "Lcom/intellij/psi/PsiFile;", "editor", "Lcom/intellij/openapi/editor/Editor;", "MyPass", "idea"})
public final class MoveDeclarationsPassFactory
extends AbstractProjectComponent
implements TextEditorHighlightingPassFactory {
    @Nullable
    public TextEditorHighlightingPass createHighlightingPass(@NotNull PsiFile file, @NotNull Editor editor) {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        Intrinsics.checkParameterIsNotNull((Object)editor, (String)"editor");
        Project project = file.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"file.project");
        return new MyPass(project, file, editor);
    }

    public MoveDeclarationsPassFactory(@NotNull Project project, @NotNull TextEditorHighlightingPassRegistrar highlightingPassRegistrar) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)highlightingPassRegistrar, (String)"highlightingPassRegistrar");
        super(project);
        highlightingPassRegistrar.registerTextEditorHighlightingPass((TextEditorHighlightingPassFactory)this, TextEditorHighlightingPassRegistrar.Anchor.BEFORE, 3, true, true);
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\n\u0010\t\u001a\u0004\u0018\u00010\nH\u0002J\b\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/idea/refactoring/cutPaste/MoveDeclarationsPassFactory$MyPass;", "Lcom/intellij/codeHighlighting/TextEditorHighlightingPass;", "project", "Lcom/intellij/openapi/project/Project;", "file", "Lcom/intellij/psi/PsiFile;", "editor", "Lcom/intellij/openapi/editor/Editor;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/psi/PsiFile;Lcom/intellij/openapi/editor/Editor;)V", "buildHighlightingInfo", "Lcom/intellij/codeInsight/daemon/impl/HighlightInfo;", "doApplyInformationToEditor", "", "doCollectInformation", "progress", "Lcom/intellij/openapi/progress/ProgressIndicator;", "idea"})
    private static final class MyPass
    extends TextEditorHighlightingPass {
        private final Project project;
        private final PsiFile file;
        private final Editor editor;

        public void doCollectInformation(@NotNull ProgressIndicator progress2) {
            Intrinsics.checkParameterIsNotNull((Object)progress2, (String)"progress");
        }

        public void doApplyInformationToEditor() {
            HighlightInfo info = this.buildHighlightingInfo();
            Document document = this.myDocument;
            if (document == null) {
                Intrinsics.throwNpe();
            }
            UpdateHighlightersUtil.setHighlightersToEditor((Project)this.project, (Document)document, (int)0, (int)this.file.getTextLength(), (Collection)CollectionsKt.listOfNotNull((Object)info), (EditorColorsScheme)this.getColorsScheme(), (int)this.getId());
        }

        private final HighlightInfo buildHighlightingInfo() {
            MoveDeclarationsEditorCookie moveDeclarationsEditorCookie = (MoveDeclarationsEditorCookie)this.editor.getUserData(MoveDeclarationsEditorCookie.Companion.getKEY());
            if (moveDeclarationsEditorCookie == null) {
                return null;
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)moveDeclarationsEditorCookie, (String)"editor.getUserData(MoveD\u2026ookie.KEY) ?: return null");
            MoveDeclarationsEditorCookie cookie = moveDeclarationsEditorCookie;
            long l = cookie.getModificationCount();
            PsiModificationTracker psiModificationTracker = PsiModificationTracker.SERVICE.getInstance((Project)this.project);
            Intrinsics.checkExpressionValueIsNotNull((Object)psiModificationTracker, (String)"PsiModificationTracker.S\u2026VICE.getInstance(project)");
            if (l != psiModificationTracker.getModificationCount()) {
                return null;
            }
            MoveDeclarationsProcessor processor2 = MoveDeclarationsProcessor.Companion.build(this.editor, cookie);
            if (processor2 == null) {
                this.editor.putUserData(MoveDeclarationsEditorCookie.Companion.getKEY(), null);
                return null;
            }
            HighlightInfo.Builder builder = HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.INFORMATION);
            TextRange textRange = RangeUtilsKt.getRange(cookie.getBounds());
            if (textRange == null) {
                Intrinsics.throwNpe();
            }
            HighlightInfo highlightInfo = builder.range(textRange).createUnconditionally();
            Intrinsics.checkExpressionValueIsNotNull((Object)highlightInfo, (String)"HighlightInfo.newHighlig\u2026 .createUnconditionally()");
            HighlightInfo info = highlightInfo;
            QuickFixAction.registerQuickFixAction((HighlightInfo)info, (IntentionAction)((IntentionAction)new MoveDeclarationsIntentionAction(processor2, cookie.getBounds(), cookie.getModificationCount())));
            return info;
        }

        public MyPass(@NotNull Project project, @NotNull PsiFile file, @NotNull Editor editor) {
            Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
            Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
            Intrinsics.checkParameterIsNotNull((Object)editor, (String)"editor");
            super(project, editor.getDocument(), true);
            this.project = project;
            this.file = file;
            this.editor = editor;
        }
    }
}

