/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.refactoring.rename;

import com.intellij.psi.PsiElement;
import com.intellij.refactoring.JavaRefactoringSettings;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.rename.naming.AutomaticRenamer;
import com.intellij.refactoring.rename.naming.AutomaticRenamerFactory;
import com.intellij.usageView.UsageInfo;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.refactoring.rename.AutomaticParameterRenamer;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtParameter;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J&\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0016J\b\u0010\f\u001a\u00020\bH\u0016J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\b\u0010\u000f\u001a\u00020\u000eH\u0016J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u000eH\u0016\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/idea/refactoring/rename/AutomaticParameterRenamerFactory;", "Lcom/intellij/refactoring/rename/naming/AutomaticRenamerFactory;", "()V", "createRenamer", "Lcom/intellij/refactoring/rename/naming/AutomaticRenamer;", "element", "Lcom/intellij/psi/PsiElement;", "newName", "", "usages", "", "Lcom/intellij/usageView/UsageInfo;", "getOptionName", "isApplicable", "", "isEnabled", "setEnabled", "", "enabled", "idea"})
public final class AutomaticParameterRenamerFactory
implements AutomaticRenamerFactory {
    public boolean isApplicable(@NotNull PsiElement element3) {
        Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
        return element3 instanceof KtParameter && ((KtParameter)element3).getOwnerFunction() instanceof KtNamedFunction;
    }

    @NotNull
    public String getOptionName() {
        String string = RefactoringBundle.message((String)"rename.parameters.hierarchy");
        if (string == null) {
            Intrinsics.throwNpe();
        }
        return string;
    }

    public boolean isEnabled() {
        JavaRefactoringSettings javaRefactoringSettings = JavaRefactoringSettings.getInstance();
        Intrinsics.checkExpressionValueIsNotNull((Object)javaRefactoringSettings, (String)"JavaRefactoringSettings.getInstance()");
        return javaRefactoringSettings.isRenameParameterInHierarchy();
    }

    public void setEnabled(boolean enabled2) {
        JavaRefactoringSettings javaRefactoringSettings = JavaRefactoringSettings.getInstance();
        Intrinsics.checkExpressionValueIsNotNull((Object)javaRefactoringSettings, (String)"JavaRefactoringSettings.getInstance()");
        javaRefactoringSettings.setRenameParameterInHierarchy(enabled2);
    }

    @NotNull
    public AutomaticRenamer createRenamer(@NotNull PsiElement element3, @NotNull String newName2, @NotNull Collection<? extends UsageInfo> usages2) {
        Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
        Intrinsics.checkParameterIsNotNull((Object)newName2, (String)"newName");
        Intrinsics.checkParameterIsNotNull(usages2, (String)"usages");
        return new AutomaticParameterRenamer((KtParameter)element3, newName2);
    }
}

