/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.refactoring.rename;

import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.psi.PsiElement;
import com.intellij.refactoring.rename.RenameHandler;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.codeInsight.DescriptorToSourceUtilsIde;
import org.jetbrains.kotlin.idea.refactoring.DataContextUtilsKt;
import org.jetbrains.kotlin.idea.refactoring.rename.AbstractReferenceSubstitutionRenameHandler;
import org.jetbrains.kotlin.idea.refactoring.rename.KotlinVariableInplaceRenameHandler;
import org.jetbrains.kotlin.idea.references.ReferenceUtilKt;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtLabelReferenceExpression;
import org.jetbrains.kotlin.psi.KtLabeledExpression;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.lazy.BodyResolveMode;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0014\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/idea/refactoring/rename/RenameByLabeledReferenceInLambdaArgumentHandler;", "Lorg/jetbrains/kotlin/idea/refactoring/rename/AbstractReferenceSubstitutionRenameHandler;", "()V", "getElementToRename", "Lcom/intellij/psi/PsiElement;", "dataContext", "Lcom/intellij/openapi/actionSystem/DataContext;", "idea"})
public final class RenameByLabeledReferenceInLambdaArgumentHandler
extends AbstractReferenceSubstitutionRenameHandler {
    @Override
    @Nullable
    protected PsiElement getElementToRename(@NotNull DataContext dataContext) {
        PsiElement psiElement2;
        Intrinsics.checkParameterIsNotNull((Object)dataContext, (String)"dataContext");
        KtSimpleNameExpression ktSimpleNameExpression = AbstractReferenceSubstitutionRenameHandler.Companion.getReferenceExpression(dataContext);
        if (!(ktSimpleNameExpression instanceof KtLabelReferenceExpression)) {
            ktSimpleNameExpression = null;
        }
        KtLabelReferenceExpression ktLabelReferenceExpression = (KtLabelReferenceExpression)ktSimpleNameExpression;
        if (ktLabelReferenceExpression == null) {
            return null;
        }
        KtLabelReferenceExpression refExpr = ktLabelReferenceExpression;
        BindingContext context = ResolutionUtils.analyze(refExpr, BodyResolveMode.PARTIAL);
        Object v = context.get(BindingContext.LABEL_TARGET, refExpr);
        if (!(v instanceof KtFunction)) {
            v = null;
        }
        KtFunction ktFunction = (KtFunction)v;
        if (ktFunction == null) {
            return null;
        }
        KtFunction lambda2 = ktFunction;
        KtLabeledExpression labeledParent = KtPsiUtilKt.getLabeledParent(lambda2, refExpr.getReferencedName());
        if (labeledParent != null) {
            psiElement2 = (PsiElement)labeledParent;
        } else {
            KtSimpleNameExpression ktSimpleNameExpression2 = ReferenceUtilKt.getCalleeByLambdaArgument(lambda2);
            if (ktSimpleNameExpression2 == null) {
                return null;
            }
            KtSimpleNameExpression calleeExpression2 = ktSimpleNameExpression2;
            Object v2 = context.get(BindingContext.REFERENCE_TARGET, calleeExpression2);
            if (!(v2 instanceof FunctionDescriptor)) {
                v2 = null;
            }
            FunctionDescriptor functionDescriptor2 = (FunctionDescriptor)v2;
            if (functionDescriptor2 == null) {
                return null;
            }
            FunctionDescriptor descriptor2 = functionDescriptor2;
            psiElement2 = DescriptorToSourceUtilsIde.INSTANCE.getAnyDeclaration(DataContextUtilsKt.getProject(dataContext), descriptor2);
        }
        return psiElement2;
    }

    public RenameByLabeledReferenceInLambdaArgumentHandler() {
        super((RenameHandler)new KotlinVariableInplaceRenameHandler());
    }
}

