/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.refactoring.rename;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.util.MoveRenameUsageInfo;
import com.intellij.usageView.UsageInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.asJava.LightClassUtilsKt;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.SourceElement;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.refactoring.rename.LostDefaultValuesInOverridingFunctionUsageInfo;
import org.jetbrains.kotlin.idea.refactoring.rename.UnresolvableConventionViolationUsageInfo;
import org.jetbrains.kotlin.idea.references.AbstractKtReference;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.resolve.source.KotlinSourceElementKt;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=2, d1={"\u00008\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001a4\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0016\u0010\u0004\u001a\u0012\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u0003\u0012\u0004\u0012\u00020\u00060\u00052\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u001a(\u0010\n\u001a\u0004\u0018\u0001H\u000b\"\n\b\u0000\u0010\u000b\u0018\u0001*\u00020\u0003*\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0086\b\u00a2\u0006\u0002\u0010\u000f\u001a&\u0010\u0010\u001a\u0004\u0018\u00010\u0011*\u00020\u00032\u0016\u0010\u0004\u001a\u0012\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u0003\u0012\u0004\u0012\u00020\u00060\u0005H\u0002\u00a8\u0006\u0012"}, d2={"checkConflictsAndReplaceUsageInfos", "", "element", "Lcom/intellij/psi/PsiElement;", "allRenames", "", "", "result", "", "Lcom/intellij/usageView/UsageInfo;", "findElementForRename", "T", "Lcom/intellij/psi/PsiFile;", "offset", "", "(Lcom/intellij/psi/PsiFile;I)Lcom/intellij/psi/PsiElement;", "getOverriddenFunctionWithDefaultValues", "Lorg/jetbrains/kotlin/psi/KtNamedFunction;", "idea"})
public final class RenameUtilKt {
    public static final void checkConflictsAndReplaceUsageInfos(@NotNull PsiElement element3, @NotNull Map<? extends PsiElement, String> allRenames, @NotNull List<UsageInfo> result2) {
        Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
        Intrinsics.checkParameterIsNotNull(allRenames, (String)"allRenames");
        Intrinsics.checkParameterIsNotNull(result2, (String)"result");
        KtNamedFunction ktNamedFunction = RenameUtilKt.getOverriddenFunctionWithDefaultValues(element3, allRenames);
        if (ktNamedFunction != null) {
            KtNamedFunction ktNamedFunction2;
            KtNamedFunction baseFunction = ktNamedFunction2 = ktNamedFunction;
            Collection collection = result2;
            PsiElement psiElement2 = LightClassUtilsKt.getUnwrapped(element3);
            if (psiElement2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtNamedFunction");
            }
            LostDefaultValuesInOverridingFunctionUsageInfo lostDefaultValuesInOverridingFunctionUsageInfo = new LostDefaultValuesInOverridingFunctionUsageInfo((KtNamedFunction)psiElement2, baseFunction);
            collection.add(lostDefaultValuesInOverridingFunctionUsageInfo);
        }
        ListIterator<UsageInfo> usageIterator = result2.listIterator();
        while (usageIterator.hasNext()) {
            PsiElement referencedElement;
            PsiElement refElement;
            AbstractKtReference ref;
            MoveRenameUsageInfo usageInfo;
            UsageInfo usageInfo2 = usageIterator.next();
            if (!(usageInfo2 instanceof MoveRenameUsageInfo)) {
                usageInfo2 = null;
            }
            if ((MoveRenameUsageInfo)usageInfo2 == null) {
                continue;
            }
            PsiReference psiReference = usageInfo.getReference();
            if (!(psiReference instanceof AbstractKtReference)) {
                psiReference = null;
            }
            if ((AbstractKtReference)psiReference == null) {
                continue;
            }
            if (ref.canRename()) continue;
            if (usageInfo.getElement() == null) {
                continue;
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)refElement, (String)"usageInfo.element ?: continue");
            if (usageInfo.getReferencedElement() == null) {
                continue;
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)referencedElement, (String)"usageInfo.referencedElement ?: continue");
            usageIterator.set((UsageInfo)new UnresolvableConventionViolationUsageInfo(refElement, referencedElement));
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    private static final KtNamedFunction getOverriddenFunctionWithDefaultValues(@NotNull PsiElement $receiver, Map<? extends PsiElement, String> allRenames) {
        Object element$iv;
        Object v9;
        boolean bl;
        Object it;
        void $receiver$iv$iv;
        Object element$iv$iv;
        void $receiver$iv$iv2;
        Iterable $receiver$iv;
        Iterable iterable = $receiver$iv = (Iterable)allRenames.keySet();
        Collection collection = new ArrayList();
        Iterable $receiver$iv$iv$iv = $receiver$iv$iv2;
        for (Object element$iv$iv$iv : $receiver$iv$iv$iv) {
            PsiElement psiElement2;
            PsiElement it2;
            element$iv$iv = element$iv$iv$iv;
            PsiElement psiElement3 = it2 = (PsiElement)element$iv$iv;
            Object object = psiElement3 != null ? LightClassUtilsKt.getUnwrapped(psiElement3) : null;
            if (object == null) continue;
            PsiElement it$iv$iv = psiElement2 = object;
            collection.add(it$iv$iv);
        }
        List elementsToRename = (List)collection;
        PsiElement psiElement4 = LightClassUtilsKt.getUnwrapped($receiver);
        if (!(psiElement4 instanceof KtNamedFunction)) {
            psiElement4 = null;
        }
        KtNamedFunction ktNamedFunction = (KtNamedFunction)psiElement4;
        if (ktNamedFunction == null) return null;
        KtNamedFunction function2 = ktNamedFunction;
        DeclarationDescriptor declarationDescriptor = ResolutionUtils.unsafeResolveToDescriptor$default(function2, null, 1, null);
        if (declarationDescriptor == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.descriptors.FunctionDescriptor");
        }
        FunctionDescriptor descriptor2 = (FunctionDescriptor)declarationDescriptor;
        Collection<? extends FunctionDescriptor> collection2 = descriptor2.getOverriddenDescriptors();
        Intrinsics.checkExpressionValueIsNotNull(collection2, (String)"descriptor.overriddenDescriptors");
        Iterable iterable2 = collection2;
        $receiver$iv$iv$iv = iterable2;
        Collection destination$iv$iv = new ArrayList();
        void $receiver$iv$iv$iv2 = $receiver$iv$iv;
        element$iv$iv = $receiver$iv$iv$iv2.iterator();
        while (element$iv$iv.hasNext()) {
            KtNamedFunction $i$a$1$let;
            Object element$iv$iv$iv;
            Object element$iv$iv2 = element$iv$iv$iv = element$iv$iv.next();
            it = (FunctionDescriptor)element$iv$iv2;
            FunctionDescriptor functionDescriptor2 = it;
            Intrinsics.checkExpressionValueIsNotNull((Object)functionDescriptor2, (String)"it");
            SourceElement sourceElement = functionDescriptor2.getSource();
            Intrinsics.checkExpressionValueIsNotNull((Object)sourceElement, (String)"it.source");
            PsiElement psiElement5 = KotlinSourceElementKt.getPsi(sourceElement);
            if (!(psiElement5 instanceof KtNamedFunction)) {
                psiElement5 = null;
            }
            if ((KtNamedFunction)psiElement5 == null) continue;
            KtNamedFunction it$iv$iv = $i$a$1$let;
            destination$iv$iv.add(it$iv$iv);
        }
        Iterable iterable3 = (List)destination$iv$iv;
        Iterator iterator2 = iterable3.iterator();
        do {
            if (!iterator2.hasNext()) {
                v9 = null;
                return v9;
            }
            element$iv = iterator2.next();
            KtNamedFunction it3 = (KtNamedFunction)element$iv;
            if (!elementsToRename.contains(it3)) {
                boolean bl2;
                block12: {
                    List<KtParameter> list2 = it3.getValueParameters();
                    Intrinsics.checkExpressionValueIsNotNull(list2, (String)"it.valueParameters");
                    Iterable $receiver$iv2 = list2;
                    if ($receiver$iv2 instanceof Collection && ((Collection)$receiver$iv2).isEmpty()) {
                        bl2 = false;
                    } else {
                        for (Object element$iv2 : $receiver$iv2) {
                            it = (KtParameter)element$iv2;
                            if (!((KtParameter)it).hasDefaultValue()) continue;
                            bl2 = true;
                            break block12;
                        }
                        bl2 = false;
                    }
                }
                if (bl2) {
                    bl = true;
                    continue;
                }
            }
            bl = false;
        } while (!bl);
        v9 = element$iv;
        return v9;
    }

    private static final <T extends PsiElement> T findElementForRename(@NotNull PsiFile $receiver, int offset2) {
        Intrinsics.reifiedOperationMarker((int)4, (String)"T");
        PsiElement psiElement2 = PsiTreeUtil.findElementOfClassAtOffset((PsiFile)$receiver, (int)offset2, PsiElement.class, (boolean)false);
        if (psiElement2 == null) {
            int n = RangesKt.coerceAtLeast((int)(offset2 - 1), (int)0);
            Intrinsics.reifiedOperationMarker((int)4, (String)"T");
            psiElement2 = PsiTreeUtil.findElementOfClassAtOffset((PsiFile)$receiver, (int)n, PsiElement.class, (boolean)false);
        }
        return (T)psiElement2;
    }
}

