/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.search.usagesSearch.operators;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.SearchRequestCollector;
import com.intellij.psi.search.SearchScope;
import com.intellij.util.Processor;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.references.KtArrayAccessReference;
import org.jetbrains.kotlin.idea.references.ReferenceAccess;
import org.jetbrains.kotlin.idea.references.ReferenceUtilKt;
import org.jetbrains.kotlin.idea.search.ideaExtensions.KotlinReferencesSearchOptions;
import org.jetbrains.kotlin.idea.search.usagesSearch.operators.OperatorReferenceSearcher;
import org.jetbrains.kotlin.psi.KtArrayAccessExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001BG\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0018\u0010\u0007\u001a\u0014\u0012\u0006\b\u0000\u0012\u00020\t0\bj\b\u0012\u0004\u0012\u00020\t`\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\u0006\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\u0002\u0010\u0011J\u0010\u0010\u0012\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u0002H\u0002J\u0012\u0010\u0014\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0015\u001a\u00020\u0016H\u0014J\u0010\u0010\u0017\u001a\u00020\u00102\u0006\u0010\u0018\u001a\u00020\tH\u0014J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0014R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lorg/jetbrains/kotlin/idea/search/usagesSearch/operators/IndexingOperatorReferenceSearcher;", "Lorg/jetbrains/kotlin/idea/search/usagesSearch/operators/OperatorReferenceSearcher;", "Lorg/jetbrains/kotlin/psi/KtArrayAccessExpression;", "targetFunction", "Lcom/intellij/psi/PsiElement;", "searchScope", "Lcom/intellij/psi/search/SearchScope;", "consumer", "Lcom/intellij/util/Processor;", "Lcom/intellij/psi/PsiReference;", "Lorg/jetbrains/kotlin/compatibility/ExecutorProcessor;", "optimizer", "Lcom/intellij/psi/search/SearchRequestCollector;", "options", "Lorg/jetbrains/kotlin/idea/search/ideaExtensions/KotlinReferencesSearchOptions;", "isSet", "", "(Lcom/intellij/psi/PsiElement;Lcom/intellij/psi/search/SearchScope;Lcom/intellij/util/Processor;Lcom/intellij/psi/search/SearchRequestCollector;Lorg/jetbrains/kotlin/idea/search/ideaExtensions/KotlinReferencesSearchOptions;Z)V", "checkAccessExpression", "accessExpression", "extractReference", "element", "Lorg/jetbrains/kotlin/psi/KtElement;", "isReferenceToCheck", "ref", "processPossibleReceiverExpression", "", "expression", "Lorg/jetbrains/kotlin/psi/KtExpression;", "idea-core"})
public final class IndexingOperatorReferenceSearcher
extends OperatorReferenceSearcher<KtArrayAccessExpression> {
    private final boolean isSet;

    @Override
    protected void processPossibleReceiverExpression(@NotNull KtExpression expression2) {
        Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
        PsiElement psiElement2 = expression2.getParent();
        if (!(psiElement2 instanceof KtArrayAccessExpression)) {
            psiElement2 = null;
        }
        KtArrayAccessExpression ktArrayAccessExpression = (KtArrayAccessExpression)psiElement2;
        if (ktArrayAccessExpression == null) {
            return;
        }
        KtArrayAccessExpression accessExpression = ktArrayAccessExpression;
        if (Intrinsics.areEqual((Object)expression2, (Object)accessExpression.getArrayExpression()) ^ true) {
            return;
        }
        if (!this.checkAccessExpression(accessExpression)) {
            return;
        }
        this.processReferenceElement((KtElement)accessExpression);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected boolean isReferenceToCheck(@NotNull PsiReference ref) {
        Intrinsics.checkParameterIsNotNull((Object)ref, (String)"ref");
        if (!(ref instanceof KtArrayAccessReference)) return false;
        KtArrayAccessExpression ktArrayAccessExpression = (KtArrayAccessExpression)((KtArrayAccessReference)ref).getElement();
        if (ktArrayAccessExpression == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtArrayAccessExpression");
        }
        if (!this.checkAccessExpression(ktArrayAccessExpression)) return false;
        return true;
    }

    @Override
    @Nullable
    protected PsiReference extractReference(@NotNull KtElement element3) {
        PsiReference element$iv2;
        block5: {
            PsiReference[] $receiver$iv;
            Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
            KtElement ktElement = element3;
            if (!(ktElement instanceof KtArrayAccessExpression)) {
                ktElement = null;
            }
            KtArrayAccessExpression ktArrayAccessExpression = (KtArrayAccessExpression)ktElement;
            if (ktArrayAccessExpression == null) {
                return null;
            }
            KtArrayAccessExpression accessExpression = ktArrayAccessExpression;
            if (!this.checkAccessExpression(accessExpression)) {
                return null;
            }
            PsiReference[] psiReferenceArray = accessExpression.getReferences();
            Intrinsics.checkExpressionValueIsNotNull((Object)psiReferenceArray, (String)"accessExpression.references");
            for (PsiReference element$iv2 : $receiver$iv = psiReferenceArray) {
                if (!(element$iv2 instanceof KtArrayAccessReference)) {
                    continue;
                }
                break block5;
            }
            throw (Throwable)new NoSuchElementException("No element of given type found");
        }
        return element$iv2;
    }

    private final boolean checkAccessExpression(KtArrayAccessExpression accessExpression) {
        ReferenceAccess readWriteAccess = ReferenceUtilKt.readWriteAccess(accessExpression, false);
        return this.isSet ? readWriteAccess.isWrite() : readWriteAccess.isRead();
    }

    public IndexingOperatorReferenceSearcher(@NotNull PsiElement targetFunction, @NotNull SearchScope searchScope2, @NotNull Processor<? super PsiReference> consumer2, @NotNull SearchRequestCollector optimizer, @NotNull KotlinReferencesSearchOptions options2, boolean isSet) {
        Intrinsics.checkParameterIsNotNull((Object)targetFunction, (String)"targetFunction");
        Intrinsics.checkParameterIsNotNull((Object)searchScope2, (String)"searchScope");
        Intrinsics.checkParameterIsNotNull(consumer2, (String)"consumer");
        Intrinsics.checkParameterIsNotNull((Object)optimizer, (String)"optimizer");
        Intrinsics.checkParameterIsNotNull((Object)options2, (String)"options");
        super(targetFunction, searchScope2, consumer2, optimizer, options2, CollectionsKt.listOf((Object)"["));
        this.isSet = isSet;
    }
}

