/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.backend.ast;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.js.backend.ast.JsName;
import org.jetbrains.kotlin.js.backend.ast.JsObjectScope;
import org.jetbrains.kotlin.js.backend.ast.JsProgram;
import org.jetbrains.kotlin.js.util.Maps;

public abstract class JsScope {
    @NotNull
    private final String description;
    private Map<String, JsName> names = Collections.emptyMap();
    private final JsScope parent;
    private static final Pattern FRESH_NAME_SUFFIX = Pattern.compile("[\\$_]\\d+$");

    public JsScope(JsScope parent2, @NotNull String description2) {
        this.description = description2;
        this.parent = parent2;
    }

    protected JsScope(@NotNull String description2) {
        this.description = description2;
        this.parent = null;
    }

    @NotNull
    public JsScope innerObjectScope(@NotNull String scopeName) {
        return new JsObjectScope(this, scopeName);
    }

    @NotNull
    public JsName declareName(@NotNull String identifier2) {
        JsName name2 = this.findOwnName(identifier2);
        return name2 != null ? name2 : this.doCreateName(identifier2);
    }

    @NotNull
    public JsName declareFreshName(@NotNull String suggestedName) {
        assert (!suggestedName.isEmpty());
        String ident = this.getFreshIdent(suggestedName);
        return this.doCreateName(ident);
    }

    @NotNull
    public static JsName declareTemporaryName(@NotNull String suggestedName) {
        assert (!suggestedName.isEmpty());
        return new JsName(suggestedName, true);
    }

    @NotNull
    public static JsName declareTemporary() {
        return JsScope.declareTemporaryName("tmp$");
    }

    @Nullable
    public final JsName findName(@NotNull String ident) {
        JsName name2 = this.findOwnName(ident);
        if (name2 == null && this.parent != null) {
            return this.parent.findName(ident);
        }
        return name2;
    }

    public boolean hasOwnName(@NotNull String name2) {
        return this.names.containsKey(name2);
    }

    private boolean hasName(@NotNull String name2) {
        return this.hasOwnName(name2) || this.parent != null && this.parent.hasName(name2);
    }

    public final JsScope getParent() {
        return this.parent;
    }

    public JsProgram getProgram() {
        assert (this.parent != null) : "Subclasses must override getProgram() if they do not set a parent";
        return this.parent.getProgram();
    }

    public final String toString() {
        if (this.parent != null) {
            return this.description + "->" + this.parent;
        }
        return this.description;
    }

    public void copyOwnNames(JsScope other) {
        this.names = new HashMap<String, JsName>(this.names);
        this.names.putAll(other.names);
    }

    @NotNull
    public String getDescription() {
        return this.description;
    }

    @NotNull
    protected JsName doCreateName(@NotNull String ident) {
        JsName name2 = new JsName(ident, false);
        this.names = Maps.put(this.names, ident, name2);
        return name2;
    }

    protected JsName findOwnName(@NotNull String ident) {
        return this.names.get(ident);
    }

    @NotNull
    protected String getFreshIdent(@NotNull String suggestedIdent) {
        char sep = '_';
        String baseName = suggestedIdent;
        int counter = 0;
        Matcher matcher2 = FRESH_NAME_SUFFIX.matcher(suggestedIdent);
        if (matcher2.find()) {
            String group = matcher2.group();
            baseName = matcher2.replaceAll("");
            sep = group.charAt(0);
            counter = Integer.valueOf(group.substring(1));
        }
        String freshName = suggestedIdent;
        while (this.hasName(freshName)) {
            freshName = baseName + sep + counter++;
        }
        return freshName;
    }
}

