/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.translate.intrinsic.functions.factories;

import java.util.List;
import java.util.function.Predicate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.js.backend.ast.JsBinaryOperation;
import org.jetbrains.kotlin.js.backend.ast.JsBinaryOperator;
import org.jetbrains.kotlin.js.backend.ast.JsExpression;
import org.jetbrains.kotlin.js.backend.ast.JsIntLiteral;
import org.jetbrains.kotlin.js.backend.ast.JsPrefixOperation;
import org.jetbrains.kotlin.js.backend.ast.JsUnaryOperator;
import org.jetbrains.kotlin.js.patterns.DescriptorPredicate;
import org.jetbrains.kotlin.js.patterns.NamePredicate;
import org.jetbrains.kotlin.js.patterns.PatternBuilder;
import org.jetbrains.kotlin.js.translate.context.TranslationContext;
import org.jetbrains.kotlin.js.translate.intrinsic.functions.basic.FunctionIntrinsic;
import org.jetbrains.kotlin.js.translate.intrinsic.functions.basic.FunctionIntrinsicWithReceiverComputed;
import org.jetbrains.kotlin.js.translate.intrinsic.functions.factories.FunctionIntrinsicFactory;
import org.jetbrains.kotlin.js.translate.operation.OperatorTable;
import org.jetbrains.kotlin.js.translate.utils.JsAstUtils;
import org.jetbrains.kotlin.js.translate.utils.JsDescriptorUtils;
import org.jetbrains.kotlin.js.translate.utils.jsAstUtils.AstUtilsKt;
import org.jetbrains.kotlin.lexer.KtToken;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.types.expressions.OperatorConventions;
import org.jetbrains.kotlin.util.OperatorNameConventions;

public enum PrimitiveUnaryOperationFIF implements FunctionIntrinsicFactory
{
    INSTANCE;

    private static final NamePredicate UNARY_OPERATIONS;
    @NotNull
    private static final DescriptorPredicate UNARY_OPERATION_FOR_PRIMITIVE_NUMBER;
    @NotNull
    private static final Predicate<FunctionDescriptor> PRIMITIVE_UNARY_OPERATION_NAMES;
    @NotNull
    private static final DescriptorPredicate NO_PARAMETERS;
    @NotNull
    private static final Predicate<FunctionDescriptor> PATTERN;
    private static final DescriptorPredicate INC_OPERATION_FOR_INT;
    private static final DescriptorPredicate DEC_OPERATION_FOR_INT;
    private static final DescriptorPredicate INC_OPERATION_FOR_BYTE;
    private static final DescriptorPredicate DEC_OPERATION_FOR_BYTE;
    private static final DescriptorPredicate INC_OPERATION_FOR_SHORT;
    private static final DescriptorPredicate DEC_OPERATION_FOR_SHORT;
    private static final DescriptorPredicate NEG_OPERATION_FOR_INT;
    @NotNull
    private static final DescriptorPredicate INC_OPERATION_FOR_PRIMITIVE_NUMBER;
    @NotNull
    private static final DescriptorPredicate DEC_OPERATION_FOR_PRIMITIVE_NUMBER;
    @NotNull
    private static final FunctionIntrinsicWithReceiverComputed NUMBER_INC_INTRINSIC;
    @NotNull
    private static final FunctionIntrinsicWithReceiverComputed NUMBER_DEC_INTRINSIC;
    private static final FunctionIntrinsicWithReceiverComputed NUMBER_NEG_INTRINSIC;
    @NotNull
    private static final FunctionIntrinsic CHAR_PLUS;
    @NotNull
    private static final FunctionIntrinsic CHAR_MINUS;
    @NotNull
    private static final FunctionIntrinsic CHAR_INC;
    @NotNull
    private static final FunctionIntrinsic CHAR_DEC;

    @Override
    @Nullable
    public FunctionIntrinsic getIntrinsic(@NotNull FunctionDescriptor descriptor2, @NotNull TranslationContext context) {
        JsUnaryOperator jsOperator;
        if (!PATTERN.test(descriptor2)) {
            return null;
        }
        if (PatternBuilder.pattern("Char.unaryPlus()").test(descriptor2)) {
            return CHAR_PLUS;
        }
        if (PatternBuilder.pattern("Char.unaryMinus()").test(descriptor2)) {
            return CHAR_MINUS;
        }
        if (PatternBuilder.pattern("Char.plus()").test(descriptor2)) {
            return CHAR_PLUS;
        }
        if (PatternBuilder.pattern("Char.minus()").test(descriptor2)) {
            return CHAR_MINUS;
        }
        if (PatternBuilder.pattern("Char.inc()").test(descriptor2)) {
            return CHAR_INC;
        }
        if (PatternBuilder.pattern("Char.dec()").test(descriptor2)) {
            return CHAR_DEC;
        }
        if (INC_OPERATION_FOR_INT.test(descriptor2)) {
            return new IntOverflowIntrinsic(NUMBER_INC_INTRINSIC);
        }
        if (DEC_OPERATION_FOR_INT.test(descriptor2)) {
            return new IntOverflowIntrinsic(NUMBER_DEC_INTRINSIC);
        }
        if (INC_OPERATION_FOR_SHORT.test(descriptor2)) {
            return new ShortOverflowIntrinsic(NUMBER_INC_INTRINSIC);
        }
        if (DEC_OPERATION_FOR_SHORT.test(descriptor2)) {
            return new ShortOverflowIntrinsic(NUMBER_DEC_INTRINSIC);
        }
        if (INC_OPERATION_FOR_BYTE.test(descriptor2)) {
            return new ByteOverflowIntrinsic(NUMBER_INC_INTRINSIC);
        }
        if (DEC_OPERATION_FOR_BYTE.test(descriptor2)) {
            return new ByteOverflowIntrinsic(NUMBER_DEC_INTRINSIC);
        }
        if (INC_OPERATION_FOR_PRIMITIVE_NUMBER.test(descriptor2)) {
            return NUMBER_INC_INTRINSIC;
        }
        if (DEC_OPERATION_FOR_PRIMITIVE_NUMBER.test(descriptor2)) {
            return NUMBER_DEC_INTRINSIC;
        }
        if (NEG_OPERATION_FOR_INT.test(descriptor2)) {
            return new IntOverflowIntrinsic(NUMBER_NEG_INTRINSIC);
        }
        Name name2 = descriptor2.getName();
        if ("inv".equals(name2.asString())) {
            jsOperator = JsUnaryOperator.BIT_NOT;
        } else {
            KtToken jetToken = (KtToken)((Object)OperatorConventions.UNARY_OPERATION_NAMES.inverse().get((Object)name2));
            jsOperator = OperatorTable.getUnaryOperator(jetToken);
        }
        final JsUnaryOperator finalJsOperator = jsOperator;
        return new FunctionIntrinsicWithReceiverComputed(){

            @Override
            @NotNull
            public JsExpression apply(@Nullable JsExpression receiver, @NotNull List<? extends JsExpression> arguments2, @NotNull TranslationContext context) {
                assert (receiver != null);
                assert (arguments2.size() == 0) : "Unary operator should not have arguments.";
                return new JsPrefixOperation(finalJsOperator, receiver);
            }
        };
    }

    static {
        UNARY_OPERATIONS = new NamePredicate(OperatorNameConventions.UNARY_OPERATION_NAMES);
        UNARY_OPERATION_FOR_PRIMITIVE_NUMBER = PatternBuilder.pattern(NamePredicate.PRIMITIVE_NUMBERS_MAPPED_TO_PRIMITIVE_JS, UNARY_OPERATIONS);
        PRIMITIVE_UNARY_OPERATION_NAMES = UNARY_OPERATION_FOR_PRIMITIVE_NUMBER.or(PatternBuilder.pattern("Boolean.not")).or(PatternBuilder.pattern("Int|Short|Byte.inv"));
        NO_PARAMETERS = descriptor2 -> !JsDescriptorUtils.hasParameters(descriptor2);
        PATTERN = PRIMITIVE_UNARY_OPERATION_NAMES.and(NO_PARAMETERS);
        INC_OPERATION_FOR_INT = PatternBuilder.pattern("Int.inc");
        DEC_OPERATION_FOR_INT = PatternBuilder.pattern("Int.dec");
        INC_OPERATION_FOR_BYTE = PatternBuilder.pattern("Byte.inc");
        DEC_OPERATION_FOR_BYTE = PatternBuilder.pattern("Byte.dec");
        INC_OPERATION_FOR_SHORT = PatternBuilder.pattern("Short.inc");
        DEC_OPERATION_FOR_SHORT = PatternBuilder.pattern("Short.dec");
        NEG_OPERATION_FOR_INT = PatternBuilder.pattern("Int.unaryMinus");
        INC_OPERATION_FOR_PRIMITIVE_NUMBER = PatternBuilder.pattern("Float|Double.inc()");
        DEC_OPERATION_FOR_PRIMITIVE_NUMBER = PatternBuilder.pattern("Float|Double.dec()");
        NUMBER_INC_INTRINSIC = new FunctionIntrinsicWithReceiverComputed(){

            @Override
            @NotNull
            public JsExpression apply(@Nullable JsExpression receiver, @NotNull List<? extends JsExpression> arguments2, @NotNull TranslationContext context) {
                assert (receiver != null);
                assert (arguments2.size() == 0);
                return new JsBinaryOperation(JsBinaryOperator.ADD, receiver, new JsIntLiteral(1));
            }
        };
        NUMBER_DEC_INTRINSIC = new FunctionIntrinsicWithReceiverComputed(){

            @Override
            @NotNull
            public JsExpression apply(@Nullable JsExpression receiver, @NotNull List<? extends JsExpression> arguments2, @NotNull TranslationContext context) {
                assert (receiver != null);
                assert (arguments2.size() == 0);
                return new JsBinaryOperation(JsBinaryOperator.SUB, receiver, new JsIntLiteral(1));
            }
        };
        NUMBER_NEG_INTRINSIC = new FunctionIntrinsicWithReceiverComputed(){

            @Override
            @NotNull
            public JsExpression apply(@Nullable JsExpression receiver, @NotNull List<? extends JsExpression> arguments2, @NotNull TranslationContext context) {
                assert (receiver != null);
                assert (arguments2.size() == 0);
                return new JsPrefixOperation(JsUnaryOperator.NEG, receiver);
            }
        };
        CHAR_PLUS = new UnaryOperationInstrinsicBase(){

            @Override
            @NotNull
            public JsExpression doApply(@NotNull JsExpression receiver, @NotNull TranslationContext context) {
                return JsAstUtils.charToInt(receiver);
            }
        };
        CHAR_MINUS = new UnaryOperationInstrinsicBase(){

            @Override
            @NotNull
            public JsExpression doApply(@NotNull JsExpression receiver, @NotNull TranslationContext context) {
                return new JsPrefixOperation(JsUnaryOperator.NEG, JsAstUtils.charToInt(receiver));
            }
        };
        CHAR_INC = new UnaryOperationInstrinsicBase(){

            @Override
            @NotNull
            public JsExpression doApply(@NotNull JsExpression receiver, @NotNull TranslationContext context) {
                return JsAstUtils.invokeKotlinFunction("charInc", receiver);
            }
        };
        CHAR_DEC = new UnaryOperationInstrinsicBase(){

            @Override
            @NotNull
            public JsExpression doApply(@NotNull JsExpression receiver, @NotNull TranslationContext context) {
                return JsAstUtils.invokeKotlinFunction("charDec", receiver);
            }
        };
    }

    private static abstract class UnaryOperationInstrinsicBase
    extends FunctionIntrinsicWithReceiverComputed {
        private UnaryOperationInstrinsicBase() {
        }

        @NotNull
        public abstract JsExpression doApply(@NotNull JsExpression var1, @NotNull TranslationContext var2);

        @Override
        @NotNull
        public JsExpression apply(@Nullable JsExpression receiver, @NotNull List<? extends JsExpression> arguments2, @NotNull TranslationContext context) {
            assert (receiver != null);
            assert (arguments2.size() == 0);
            return this.doApply(receiver, context);
        }
    }

    private static class ByteOverflowIntrinsic
    extends FunctionIntrinsicWithReceiverComputed {
        private final FunctionIntrinsicWithReceiverComputed underlyingIntrinsic;

        public ByteOverflowIntrinsic(FunctionIntrinsicWithReceiverComputed underlyingIntrinsic) {
            this.underlyingIntrinsic = underlyingIntrinsic;
        }

        @Override
        @NotNull
        public JsExpression apply(@Nullable JsExpression receiver, @NotNull List<? extends JsExpression> arguments2, @NotNull TranslationContext context) {
            return AstUtilsKt.toByte(context, this.underlyingIntrinsic.apply(receiver, arguments2, context));
        }
    }

    private static class ShortOverflowIntrinsic
    extends FunctionIntrinsicWithReceiverComputed {
        private final FunctionIntrinsicWithReceiverComputed underlyingIntrinsic;

        public ShortOverflowIntrinsic(FunctionIntrinsicWithReceiverComputed underlyingIntrinsic) {
            this.underlyingIntrinsic = underlyingIntrinsic;
        }

        @Override
        @NotNull
        public JsExpression apply(@Nullable JsExpression receiver, @NotNull List<? extends JsExpression> arguments2, @NotNull TranslationContext context) {
            return AstUtilsKt.toShort(context, this.underlyingIntrinsic.apply(receiver, arguments2, context));
        }
    }

    private static class IntOverflowIntrinsic
    extends FunctionIntrinsicWithReceiverComputed {
        private final FunctionIntrinsicWithReceiverComputed underlyingIntrinsic;

        public IntOverflowIntrinsic(FunctionIntrinsicWithReceiverComputed underlyingIntrinsic) {
            this.underlyingIntrinsic = underlyingIntrinsic;
        }

        @Override
        @NotNull
        public JsExpression apply(@Nullable JsExpression receiver, @NotNull List<? extends JsExpression> arguments2, @NotNull TranslationContext context) {
            return JsAstUtils.toInt32(this.underlyingIntrinsic.apply(receiver, arguments2, context));
        }
    }
}

