/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.kdoc.parser;

import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import java.lang.reflect.Constructor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.KotlinLanguage;

public class KDocElementType
extends IElementType {
    private final Constructor<? extends PsiElement> psiFactory;

    public KDocElementType(String debugName, @NotNull Class<? extends PsiElement> psiClass2) {
        super(debugName, (Language)KotlinLanguage.INSTANCE);
        try {
            this.psiFactory = psiClass2.getConstructor(ASTNode.class);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException("Must have a constructor with ASTNode");
        }
    }

    public PsiElement createPsi(ASTNode node) {
        assert (node.getElementType() == this);
        try {
            return this.psiFactory.newInstance(node);
        }
        catch (Exception e) {
            throw new RuntimeException("Error creating psi element for node", e);
        }
    }
}

