/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.psi;

import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.name.SpecialNames;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtModifierListOwnerStub;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtQualifiedExpression;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.KtStubbedPsiUtil;
import org.jetbrains.kotlin.psi.KtVisitor;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import org.jetbrains.kotlin.psi.stubs.KotlinPlaceHolderStub;
import org.jetbrains.kotlin.psi.stubs.elements.KtStubElementTypes;

public class KtPackageDirective
extends KtModifierListOwnerStub<KotlinPlaceHolderStub<KtPackageDirective>> {
    private String qualifiedNameCache = null;

    public KtPackageDirective(@NotNull ASTNode node) {
        super(node);
    }

    public KtPackageDirective(@NotNull KotlinPlaceHolderStub<KtPackageDirective> stub) {
        super(stub, KtStubElementTypes.PACKAGE_DIRECTIVE);
    }

    @Nullable
    public KtExpression getPackageNameExpression() {
        return KtStubbedPsiUtil.getStubOrPsiChild(this, KtStubElementTypes.INSIDE_DIRECTIVE_EXPRESSIONS, KtExpression.ARRAY_FACTORY);
    }

    @NotNull
    public List<KtSimpleNameExpression> getPackageNames() {
        KtExpression nameExpression2 = this.getPackageNameExpression();
        if (nameExpression2 == null) {
            return Collections.emptyList();
        }
        ArrayList packageNames = ContainerUtil.newArrayList();
        while (nameExpression2 instanceof KtQualifiedExpression) {
            KtQualifiedExpression qualifiedExpression = (KtQualifiedExpression)nameExpression2;
            KtExpression selector = qualifiedExpression.getSelectorExpression();
            if (selector instanceof KtSimpleNameExpression) {
                packageNames.add((KtSimpleNameExpression)selector);
            }
            nameExpression2 = qualifiedExpression.getReceiverExpression();
        }
        if (nameExpression2 instanceof KtSimpleNameExpression) {
            packageNames.add((KtSimpleNameExpression)nameExpression2);
        }
        Collections.reverse(packageNames);
        return packageNames;
    }

    @Nullable
    public KtSimpleNameExpression getLastReferenceExpression() {
        KtExpression nameExpression2 = this.getPackageNameExpression();
        if (nameExpression2 == null) {
            return null;
        }
        return (KtSimpleNameExpression)KtPsiUtilKt.getQualifiedElementSelector(nameExpression2);
    }

    @Nullable
    public PsiElement getNameIdentifier() {
        KtSimpleNameExpression lastPart = this.getLastReferenceExpression();
        return lastPart != null ? lastPart.getIdentifier() : null;
    }

    @NotNull
    public String getName() {
        PsiElement nameIdentifier = this.getNameIdentifier();
        return nameIdentifier == null ? "" : nameIdentifier.getText();
    }

    @NotNull
    public Name getNameAsName() {
        PsiElement nameIdentifier = this.getNameIdentifier();
        return nameIdentifier == null ? SpecialNames.ROOT_PACKAGE : Name.identifier(nameIdentifier.getText());
    }

    public boolean isRoot() {
        return this.getName().length() == 0;
    }

    @NotNull
    public FqName getFqName() {
        String qualifiedName2 = this.getQualifiedName();
        return qualifiedName2.isEmpty() ? FqName.ROOT : new FqName(qualifiedName2);
    }

    @NotNull
    public FqName getFqName(KtSimpleNameExpression nameExpression2) {
        return new FqName(this.getQualifiedNameOf(nameExpression2));
    }

    public void setFqName(@NotNull FqName fqName2) {
        if (fqName2.isRoot()) {
            if (!this.getFqName().isRoot()) {
                this.replace(new KtPsiFactory(this.getProject()).createFile("").getPackageDirective());
            }
            return;
        }
        KtPsiFactory psiFactory = new KtPsiFactory(this.getProject());
        KtExpression newExpression2 = psiFactory.createExpression(fqName2.asString());
        KtExpression currentExpression = this.getPackageNameExpression();
        if (currentExpression != null) {
            currentExpression.replace((PsiElement)newExpression2);
            return;
        }
        PsiElement keyword = this.getPackageKeyword();
        if (keyword != null) {
            this.addAfter((PsiElement)newExpression2, keyword);
            return;
        }
        this.replace(psiFactory.createPackageDirective(fqName2));
    }

    @NotNull
    public String getQualifiedName() {
        if (this.qualifiedNameCache == null) {
            this.qualifiedNameCache = this.getQualifiedNameOf(null);
        }
        return this.qualifiedNameCache;
    }

    @NotNull
    private String getQualifiedNameOf(@Nullable KtSimpleNameExpression nameExpression2) {
        StringBuilder builder = new StringBuilder();
        for (KtSimpleNameExpression e : this.getPackageNames()) {
            if (builder.length() > 0) {
                builder.append(".");
            }
            builder.append(e.getReferencedName());
            if (e != nameExpression2) continue;
            break;
        }
        return builder.toString();
    }

    @Nullable
    public PsiElement getPackageKeyword() {
        return this.findChildByType(KtTokens.PACKAGE_KEYWORD);
    }

    public void subtreeChanged() {
        this.qualifiedNameCache = null;
    }

    @Override
    public <R, D> R accept(@NotNull KtVisitor<R, D> visitor2, D data) {
        return visitor2.visitPackageDirective(this, data);
    }
}

