/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve;

import com.google.common.collect.Maps;
import java.io.PrintStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import kotlin.collections.CollectionsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptorWithResolutionScopes;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.kotlin.descriptors.TypeAliasDescriptor;
import org.jetbrains.kotlin.psi.KtAnonymousInitializer;
import org.jetbrains.kotlin.psi.KtCallableDeclaration;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtDestructuringDeclarationEntry;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtScript;
import org.jetbrains.kotlin.psi.KtSecondaryConstructor;
import org.jetbrains.kotlin.psi.KtTypeAlias;
import org.jetbrains.kotlin.resolve.BodiesResolveContext;
import org.jetbrains.kotlin.resolve.TopDownAnalysisMode;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowInfo;
import org.jetbrains.kotlin.resolve.lazy.DeclarationScopeProvider;
import org.jetbrains.kotlin.resolve.lazy.descriptors.LazyScriptDescriptor;
import org.jetbrains.kotlin.resolve.scopes.LexicalScope;

public class TopDownAnalysisContext
implements BodiesResolveContext {
    private final DataFlowInfo outerDataFlowInfo;
    private final Map<KtClassOrObject, ClassDescriptorWithResolutionScopes> classes = Maps.newLinkedHashMap();
    private final Map<KtAnonymousInitializer, ClassDescriptorWithResolutionScopes> anonymousInitializers = Maps.newLinkedHashMap();
    private final Set<KtFile> files = new LinkedHashSet<KtFile>();
    private final Map<KtSecondaryConstructor, ClassConstructorDescriptor> secondaryConstructors = Maps.newLinkedHashMap();
    private final Map<KtNamedFunction, SimpleFunctionDescriptor> functions = Maps.newLinkedHashMap();
    private final Map<KtProperty, PropertyDescriptor> properties = Maps.newLinkedHashMap();
    private final Map<KtParameter, PropertyDescriptor> primaryConstructorParameterProperties = new HashMap<KtParameter, PropertyDescriptor>();
    private final Map<KtTypeAlias, TypeAliasDescriptor> typeAliases = Maps.newLinkedHashMap();
    private final Map<KtDestructuringDeclarationEntry, PropertyDescriptor> destructuringDeclarationEntries = Maps.newLinkedHashMap();
    private Map<KtCallableDeclaration, CallableMemberDescriptor> members = null;
    private final Map<KtScript, LazyScriptDescriptor> scripts = Maps.newLinkedHashMap();
    private final TopDownAnalysisMode topDownAnalysisMode;
    private final DeclarationScopeProvider declarationScopeProvider;
    private StringBuilder debugOutput;

    public TopDownAnalysisContext(@NotNull TopDownAnalysisMode topDownAnalysisMode, @NotNull DataFlowInfo outerDataFlowInfo, @NotNull DeclarationScopeProvider declarationScopeProvider) {
        this.topDownAnalysisMode = topDownAnalysisMode;
        this.outerDataFlowInfo = outerDataFlowInfo;
        this.declarationScopeProvider = declarationScopeProvider;
    }

    @Override
    @NotNull
    public TopDownAnalysisMode getTopDownAnalysisMode() {
        return this.topDownAnalysisMode;
    }

    public void debug(Object message2) {
        if (this.debugOutput != null) {
            this.debugOutput.append(message2).append("\n");
        }
    }

    void enableDebugOutput() {
        if (this.debugOutput == null) {
            this.debugOutput = new StringBuilder();
        }
    }

    void printDebugOutput(PrintStream out) {
        if (this.debugOutput != null) {
            out.print(this.debugOutput);
        }
    }

    @Override
    public Map<KtClassOrObject, ClassDescriptorWithResolutionScopes> getDeclaredClasses() {
        return this.classes;
    }

    @Override
    public Map<KtAnonymousInitializer, ClassDescriptorWithResolutionScopes> getAnonymousInitializers() {
        return this.anonymousInitializers;
    }

    @Override
    public Map<KtSecondaryConstructor, ClassConstructorDescriptor> getSecondaryConstructors() {
        return this.secondaryConstructors;
    }

    @Override
    public Collection<KtFile> getFiles() {
        return this.files;
    }

    public void addFile(@NotNull KtFile file) {
        this.files.add(file);
    }

    @Override
    @NotNull
    public Map<KtScript, LazyScriptDescriptor> getScripts() {
        return this.scripts;
    }

    public Map<KtParameter, PropertyDescriptor> getPrimaryConstructorParameterProperties() {
        return this.primaryConstructorParameterProperties;
    }

    @Override
    public Map<KtProperty, PropertyDescriptor> getProperties() {
        return this.properties;
    }

    @Override
    @Nullable
    public LexicalScope getDeclaringScope(@NotNull KtDeclaration declaration2) {
        return this.declarationScopeProvider.getResolutionScopeForDeclaration(declaration2);
    }

    @Override
    public Map<KtNamedFunction, SimpleFunctionDescriptor> getFunctions() {
        return this.functions;
    }

    @Override
    public Map<KtTypeAlias, TypeAliasDescriptor> getTypeAliases() {
        return this.typeAliases;
    }

    @Override
    public Map<KtDestructuringDeclarationEntry, PropertyDescriptor> getDestructuringDeclarationEntries() {
        return this.destructuringDeclarationEntries;
    }

    @NotNull
    public Map<KtCallableDeclaration, CallableMemberDescriptor> getMembers() {
        if (this.members == null) {
            this.members = Maps.newLinkedHashMap();
            this.members.putAll(this.functions);
            this.members.putAll(this.properties);
            this.members.putAll(this.primaryConstructorParameterProperties);
        }
        return this.members;
    }

    @Override
    @NotNull
    public DataFlowInfo getOuterDataFlowInfo() {
        return this.outerDataFlowInfo;
    }

    @NotNull
    public Collection<ClassDescriptorWithResolutionScopes> getAllClasses() {
        return CollectionsKt.plus(this.getDeclaredClasses().values(), this.getScripts().values());
    }
}

