/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.calls.checkers;

import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.diagnostics.DiagnosticUtilsKt;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.diagnostics.ParametrizedDiagnostic;
import org.jetbrains.kotlin.diagnostics.SimpleDiagnostic;
import org.jetbrains.kotlin.psi.Call;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtPsiUtil;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.calls.checkers.CallChecker;
import org.jetbrains.kotlin.resolve.calls.checkers.CallCheckerContext;
import org.jetbrains.kotlin.resolve.calls.checkers.UselessElvisCallChecker;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowValue;
import org.jetbrains.kotlin.resolve.calls.smartcasts.Nullability;
import org.jetbrains.kotlin.types.FlexibleTypesKt;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.KotlinTypeKt;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.kotlin.types.UnwrappedType;
import org.jetbrains.kotlin.types.expressions.ControlStructureTypingUtils;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J$\u0010\u0003\u001a\u00020\u00042\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/resolve/calls/checkers/UselessElvisCallChecker;", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallChecker;", "()V", "check", "", "resolvedCall", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "reportOn", "Lcom/intellij/psi/PsiElement;", "context", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallCheckerContext;", "frontend"})
public final class UselessElvisCallChecker
implements CallChecker {
    @Override
    public void check(@NotNull ResolvedCall<?> resolvedCall2, @NotNull PsiElement reportOn, @NotNull CallCheckerContext context) {
        Intrinsics.checkParameterIsNotNull(resolvedCall2, (String)"resolvedCall");
        Intrinsics.checkParameterIsNotNull((Object)reportOn, (String)"reportOn");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Object obj = resolvedCall2.getResultingDescriptor();
        Intrinsics.checkExpressionValueIsNotNull(obj, (String)"resolvedCall.resultingDescriptor");
        if (Intrinsics.areEqual((Object)obj.getName(), (Object)ControlStructureTypingUtils.ResolveConstruct.ELVIS.getSpecialFunctionName()) ^ true) {
            return;
        }
        Call call2 = resolvedCall2.getCall();
        Intrinsics.checkExpressionValueIsNotNull((Object)call2, (String)"resolvedCall.call");
        KtElement ktElement = call2.getCallElement();
        if (!(ktElement instanceof KtBinaryExpression)) {
            ktElement = null;
        }
        KtBinaryExpression ktBinaryExpression = (KtBinaryExpression)ktElement;
        if (ktBinaryExpression == null) {
            return;
        }
        KtBinaryExpression elvisBinaryExpression = ktBinaryExpression;
        KtExpression ktExpression = elvisBinaryExpression.getLeft();
        if (ktExpression == null) {
            return;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)ktExpression, (String)"elvisBinaryExpression.left ?: return");
        KtExpression left = ktExpression;
        KtExpression ktExpression2 = elvisBinaryExpression.getRight();
        if (ktExpression2 == null) {
            return;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)ktExpression2, (String)"elvisBinaryExpression.right ?: return");
        KtExpression right = ktExpression2;
        KotlinType kotlinType = context.getTrace().getType(left);
        if (kotlinType == null) {
            return;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)kotlinType, (String)"context.trace.getType(left) ?: return");
        KotlinType leftType = kotlinType;
        if (KotlinTypeKt.isError(leftType) || TypeUtilsKt.contains(leftType, (Function1<? super UnwrappedType, Boolean>)((Function1)check.1.INSTANCE))) {
            return;
        }
        if (!TypeUtils.isNullableType(leftType)) {
            BindingTrace bindingTrace = context.getTrace();
            ParametrizedDiagnostic<KtBinaryExpression> parametrizedDiagnostic = Errors.USELESS_ELVIS.on((KtBinaryExpression)((PsiElement)elvisBinaryExpression), leftType);
            Intrinsics.checkExpressionValueIsNotNull(parametrizedDiagnostic, (String)"Errors.USELESS_ELVIS.on(\u2026naryExpression, leftType)");
            DiagnosticUtilsKt.reportDiagnosticOnce(bindingTrace, parametrizedDiagnostic);
            return;
        }
        DataFlowValue dataFlowValue2 = context.getDataFlowValueFactory().createDataFlowValue(left, leftType, context.getResolutionContext());
        if (context.getDataFlowInfo().getStableNullability(dataFlowValue2) == Nullability.NOT_NULL) {
            BindingTrace bindingTrace = context.getTrace();
            ParametrizedDiagnostic<KtBinaryExpression> parametrizedDiagnostic = Errors.USELESS_ELVIS.on((KtBinaryExpression)((PsiElement)elvisBinaryExpression), leftType);
            Intrinsics.checkExpressionValueIsNotNull(parametrizedDiagnostic, (String)"Errors.USELESS_ELVIS.on(\u2026naryExpression, leftType)");
            DiagnosticUtilsKt.reportDiagnosticOnce(bindingTrace, parametrizedDiagnostic);
            return;
        }
        if (KtPsiUtil.isNullConstant(right) && !FlexibleTypesKt.isNullabilityFlexible(leftType)) {
            BindingTrace bindingTrace = context.getTrace();
            SimpleDiagnostic<KtBinaryExpression> simpleDiagnostic = Errors.USELESS_ELVIS_RIGHT_IS_NULL.on((KtBinaryExpression)((PsiElement)elvisBinaryExpression));
            Intrinsics.checkExpressionValueIsNotNull(simpleDiagnostic, (String)"Errors.USELESS_ELVIS_RIG\u2026on(elvisBinaryExpression)");
            DiagnosticUtilsKt.reportDiagnosticOnce(bindingTrace, simpleDiagnostic);
        }
    }
}

