/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.model;

import com.intellij.openapi.util.text.StringUtilRt;
import java.io.Serializable;
import org.jetbrains.idea.maven.model.MavenId;

public class MavenArtifactInfo
implements Serializable {
    private final String myGroupId;
    private final String myArtifactId;
    private final String myVersion;
    private final String myPackaging;
    private final String myClassifier;
    private final String myClassNames;
    private final String myRepositoryId;

    public MavenArtifactInfo(MavenId id, String packaging, String classifier) {
        this(id.getGroupId(), id.getArtifactId(), id.getVersion(), packaging, classifier);
    }

    public MavenArtifactInfo(String groupId, String artifactId, String version, String packaging, String classifier) {
        this(groupId, artifactId, version, packaging, classifier, null, null);
    }

    public MavenArtifactInfo(String groupId, String artifactId, String version, String packaging, String classifier, String classNames, String repositoryId) {
        this.myGroupId = groupId;
        this.myArtifactId = artifactId;
        this.myVersion = version;
        this.myPackaging = packaging;
        this.myClassifier = classifier;
        this.myClassNames = classNames;
        this.myRepositoryId = repositoryId;
    }

    public String getGroupId() {
        return this.myGroupId;
    }

    public String getArtifactId() {
        return this.myArtifactId;
    }

    public String getVersion() {
        return this.myVersion;
    }

    public String getPackaging() {
        return this.myPackaging;
    }

    public String getClassifier() {
        return this.myClassifier;
    }

    public String getClassNames() {
        return this.myClassNames;
    }

    public String getRepositoryId() {
        return this.myRepositoryId;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        MavenId.append(builder, this.myGroupId);
        MavenId.append(builder, this.myArtifactId);
        MavenId.append(builder, this.myPackaging);
        if (!StringUtilRt.isEmptyOrSpaces((CharSequence)this.myClassifier)) {
            MavenId.append(builder, this.myClassifier);
        }
        MavenId.append(builder, this.myVersion);
        MavenId.append(builder, this.myRepositoryId);
        return builder.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MavenArtifactInfo that = (MavenArtifactInfo)o;
        if (this.myArtifactId != null ? !this.myArtifactId.equals(that.myArtifactId) : that.myArtifactId != null) {
            return false;
        }
        if (this.myClassNames != null ? !this.myClassNames.equals(that.myClassNames) : that.myClassNames != null) {
            return false;
        }
        if (this.myClassifier != null ? !this.myClassifier.equals(that.myClassifier) : that.myClassifier != null) {
            return false;
        }
        if (this.myGroupId != null ? !this.myGroupId.equals(that.myGroupId) : that.myGroupId != null) {
            return false;
        }
        if (this.myPackaging != null ? !this.myPackaging.equals(that.myPackaging) : that.myPackaging != null) {
            return false;
        }
        if (this.myRepositoryId != null ? !this.myRepositoryId.equals(that.myRepositoryId) : that.myRepositoryId != null) {
            return false;
        }
        return !(this.myVersion != null ? !this.myVersion.equals(that.myVersion) : that.myVersion != null);
    }

    public int hashCode() {
        int result = this.myGroupId != null ? this.myGroupId.hashCode() : 0;
        result = 31 * result + (this.myArtifactId != null ? this.myArtifactId.hashCode() : 0);
        result = 31 * result + (this.myVersion != null ? this.myVersion.hashCode() : 0);
        result = 31 * result + (this.myPackaging != null ? this.myPackaging.hashCode() : 0);
        result = 31 * result + (this.myClassifier != null ? this.myClassifier.hashCode() : 0);
        result = 31 * result + (this.myClassNames != null ? this.myClassNames.hashCode() : 0);
        result = 31 * result + (this.myRepositoryId != null ? this.myRepositoryId.hashCode() : 0);
        return result;
    }
}

