/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.maven.actions;

import com.intellij.codeInsight.intention.PsiElementBaseIntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomManager;
import com.intellij.util.xml.GenericDomValue;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.maven.dom.MavenDomUtil;
import org.jetbrains.idea.maven.dom.model.MavenDomBuild;
import org.jetbrains.idea.maven.dom.model.MavenDomPluginExecution;
import org.jetbrains.kotlin.idea.maven.PomFile;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0016J\b\u0010\u0005\u001a\u00020\u0004H\u0016J!\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0096\u0002J \u0010\u000e\u001a\u00020\u000f2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\b\u0010\u0010\u001a\u00020\u000fH\u0016\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/idea/maven/actions/MavenPluginSourcesMoveToExecutionIntention;", "Lcom/intellij/codeInsight/intention/PsiElementBaseIntentionAction;", "()V", "getFamilyName", "", "getText", "invoke", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "element", "Lcom/intellij/psi/PsiElement;", "isAvailable", "", "startInWriteAction", "idea-maven"})
public final class MavenPluginSourcesMoveToExecutionIntention
extends PsiElementBaseIntentionAction {
    @NotNull
    public String getFamilyName() {
        return "Move to compile execution";
    }

    @NotNull
    public String getText() {
        return this.getFamilyName();
    }

    /*
     * WARNING - void declaration
     */
    public boolean isAvailable(@NotNull Project project, @NotNull Editor editor, @NotNull PsiElement element) {
        void $receiver$iv;
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)editor, (String)"editor");
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
        PsiFile file = element.getContainingFile();
        if (file == null || !MavenDomUtil.isMavenFile((PsiFile)file) || !(element instanceof XmlElement)) {
            return false;
        }
        PsiElement psiElement = element;
        boolean strict$iv = false;
        XmlTag xmlTag = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)$receiver$iv, XmlTag.class, (boolean)strict$iv);
        if (xmlTag == null) {
            return false;
        }
        XmlTag tag = xmlTag;
        DomElement domElement = DomManager.getDomManager((Project)project).getDomElement(tag);
        if (domElement == null) {
            return false;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)domElement, (String)"DomManager.getDomManager\u2026ment(tag) ?: return false");
        DomElement domElement2 = domElement;
        if (!(domElement2 instanceof GenericDomValue)) {
            return false;
        }
        if (MavenDomUtil.getMavenDomProjectModel((Project)project, (VirtualFile)file.getVirtualFile()) == null) {
            return false;
        }
        PomFile pomFile = PomFile.Companion.forFileOrNull((XmlFile)file);
        if (pomFile == null) {
            return false;
        }
        PomFile pom = pomFile;
        MavenDomBuild mavenDomBuild = (MavenDomBuild)domElement2.getParentOfType(MavenDomBuild.class, false);
        if ((mavenDomBuild != null ? mavenDomBuild.getSourceDirectory() : null) == domElement2) {
            Collection collection = pom.findKotlinExecutions("compile", "js");
            return !collection.isEmpty();
        }
        MavenDomBuild mavenDomBuild2 = (MavenDomBuild)domElement2.getParentOfType(MavenDomBuild.class, false);
        if ((mavenDomBuild2 != null ? mavenDomBuild2.getTestSourceDirectory() : null) == domElement2) {
            Collection collection = pom.findKotlinExecutions("test-compile", "test-js");
            return !collection.isEmpty();
        }
        return false;
    }

    public boolean startInWriteAction() {
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public void invoke(@NotNull Project project, @NotNull Editor editor, @NotNull PsiElement element) {
        List<MavenDomPluginExecution> list;
        void $receiver$iv;
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)editor, (String)"editor");
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
        PsiFile psiFile = element.getContainingFile();
        if (!(psiFile instanceof XmlFile)) {
            psiFile = null;
        }
        XmlFile xmlFile = (XmlFile)psiFile;
        if (xmlFile == null) {
            return;
        }
        XmlFile xmlFile2 = xmlFile;
        PomFile pomFile = PomFile.Companion.forFileOrNull(xmlFile2);
        if (pomFile == null) {
            return;
        }
        PomFile pomFile2 = pomFile;
        PsiElement psiElement = element;
        boolean strict$iv = false;
        XmlTag xmlTag = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)$receiver$iv, XmlTag.class, (boolean)strict$iv);
        if (xmlTag == null) {
            return;
        }
        XmlTag tag = xmlTag;
        DomElement domElement = DomManager.getDomManager((Project)project).getDomElement(tag);
        if (!(domElement instanceof GenericDomValue)) {
            domElement = null;
        }
        GenericDomValue genericDomValue = (GenericDomValue)domElement;
        if (genericDomValue == null) {
            return;
        }
        GenericDomValue domElement2 = genericDomValue;
        String string = domElement2.getRawText();
        if (string == null) {
            return;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"domElement.rawText ?: return");
        String dir = string;
        MavenDomBuild mavenDomBuild = (MavenDomBuild)domElement2.getParentOfType(MavenDomBuild.class, false);
        if ((mavenDomBuild != null ? mavenDomBuild.getSourceDirectory() : null) == domElement2) {
            list = pomFile2.findKotlinExecutions("compile", "js");
        } else {
            MavenDomBuild mavenDomBuild2 = (MavenDomBuild)domElement2.getParentOfType(MavenDomBuild.class, false);
            list = (mavenDomBuild2 != null ? mavenDomBuild2.getTestSourceDirectory() : null) == domElement2 ? pomFile2.findKotlinExecutions("test-compile", "test-js") : CollectionsKt.emptyList();
        }
        List<MavenDomPluginExecution> relevantExecutions = list;
        Collection collection = relevantExecutions;
        if (!collection.isEmpty()) {
            Iterable $receiver$iv2 = relevantExecutions;
            for (Object element$iv : $receiver$iv2) {
                MavenDomPluginExecution execution;
                MavenDomPluginExecution mavenDomPluginExecution = execution = (MavenDomPluginExecution)element$iv;
                Intrinsics.checkExpressionValueIsNotNull((Object)mavenDomPluginExecution, (String)"execution");
                List<String> existingSourceDirs = pomFile2.executionSourceDirs(mavenDomPluginExecution);
                pomFile2.executionSourceDirs(execution, CollectionsKt.distinct((Iterable)CollectionsKt.plus((Collection)existingSourceDirs, (Object)dir)), true);
            }
            domElement2.undefine();
        }
    }
}

