/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight;

import com.intellij.codeInsight.ExceptionUtil;
import com.intellij.codeInspection.java15api.Java15APIUsageInspection;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiFunctionalExpression;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiMethodReferenceUtil;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiResolveHelper;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeParameterListOwner;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.AnnotatedMembersSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.NullableFunction;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FunctionalInterfaceSuggester {
    public static final String[] FUNCTIONAL_INTERFACES = new String[]{"java.lang.Runnable", "java.util.concurrent.Callable", "java.util.Comparator", "com.intellij.util.Function", "com.intellij.util.Consumer", "com.intellij.openapi.util.Computable", "com.intellij.openapi.util.Condition", "com.intellij.util.Processor", "com.intellij.util.Producer", "com.google.common.base.Function", "com.google.common.base.Predicate", "com.google.common.base.Supplier", "org.apache.commons.collections.Closure", "org.apache.commons.collections.Factory", "org.apache.commons.collections.Predicate", "org.apache.commons.collections.Transformer", "gnu.trove.TObjectFunction", "gnu.trove.TObjectProcedure", "gnu.trove.TObjectObjectProcedure"};

    public static Collection<? extends PsiType> suggestFunctionalInterfaces(@NotNull PsiFunctionalExpression expression2) {
        if (expression2 == null) {
            FunctionalInterfaceSuggester.$$$reportNull$$$0(0);
        }
        PsiType qualifierType = expression2 instanceof PsiMethodReferenceExpression ? PsiMethodReferenceUtil.getQualifierType((PsiMethodReferenceExpression)((PsiMethodReferenceExpression)expression2)) : null;
        return FunctionalInterfaceSuggester.suggestFunctionalInterfaces(expression2, (NullableFunction<? super PsiClass, ? extends PsiType>)((NullableFunction)aClass -> {
            if (expression2 == null) {
                FunctionalInterfaceSuggester.$$$reportNull$$$0(8);
            }
            return FunctionalInterfaceSuggester.composeAcceptableType(aClass, expression2, qualifierType);
        }));
    }

    public static Collection<? extends PsiType> suggestFunctionalInterfaces(@NotNull PsiMethod method) {
        if (method == null) {
            FunctionalInterfaceSuggester.$$$reportNull$$$0(1);
        }
        return FunctionalInterfaceSuggester.suggestFunctionalInterfaces(method, false);
    }

    public static Collection<? extends PsiType> suggestFunctionalInterfaces(@NotNull PsiMethod method, boolean suggestUnhandledThrowables) {
        if (method == null) {
            FunctionalInterfaceSuggester.$$$reportNull$$$0(2);
        }
        if (method.isConstructor()) {
            return Collections.emptyList();
        }
        return FunctionalInterfaceSuggester.suggestFunctionalInterfaces(method, (NullableFunction<? super PsiClass, ? extends PsiType>)((NullableFunction)aClass -> {
            PsiMethod interfaceMethod;
            if (method == null) {
                FunctionalInterfaceSuggester.$$$reportNull$$$0(7);
            }
            if ((interfaceMethod = LambdaUtil.getFunctionalInterfaceMethod((PsiClass)aClass)) != null) {
                PsiClassType[] thrownTypes;
                PsiParameter[] interfaceMethodParameters;
                PsiParameter[] parameters2 = method.getParameterList().getParameters();
                if (parameters2.length != (interfaceMethodParameters = interfaceMethod.getParameterList().getParameters()).length) {
                    return null;
                }
                PsiType[] left = new PsiType[parameters2.length + 1];
                PsiType[] right = new PsiType[parameters2.length + 1];
                for (int i = 0; i < parameters2.length; ++i) {
                    left[i] = interfaceMethodParameters[i].getType();
                    right[i] = parameters2[i].getType();
                }
                left[parameters2.length] = method.getReturnType();
                right[parameters2.length] = interfaceMethod.getReturnType();
                PsiTypeParameter[] typeParameters = aClass.getTypeParameters();
                PsiSubstitutor substitutor = PsiResolveHelper.SERVICE.getInstance((Project)aClass.getProject()).inferTypeArguments(typeParameters, left, right, PsiUtil.getLanguageLevel((PsiElement)method));
                if (PsiUtil.isRawSubstitutor((PsiTypeParameterListOwner)aClass, (PsiSubstitutor)substitutor)) {
                    return null;
                }
                for (int i = 0; i < interfaceMethodParameters.length; ++i) {
                    PsiType paramType = parameters2[i].getType();
                    PsiType interfaceParamType = substitutor.substitute(interfaceMethodParameters[i].getType());
                    if (!(interfaceParamType instanceof PsiPrimitiveType) ? TypeConversionUtil.isAssignable((PsiType)paramType, (PsiType)interfaceParamType) : paramType.equals(interfaceParamType)) continue;
                    return null;
                }
                PsiType returnType = method.getReturnType();
                PsiType interfaceMethodReturnType = substitutor.substitute(interfaceMethod.getReturnType());
                if (returnType != null && !TypeConversionUtil.isAssignable((PsiType)returnType, (PsiType)interfaceMethodReturnType)) {
                    return null;
                }
                if (interfaceMethodReturnType instanceof PsiPrimitiveType && !interfaceMethodReturnType.equals(returnType)) {
                    return null;
                }
                PsiClassType[] interfaceThrownTypes = interfaceMethod.getThrowsList().getReferencedTypes();
                for (PsiClassType thrownType : thrownTypes = method.getThrowsList().getReferencedTypes()) {
                    if (ExceptionUtil.isHandledBy(thrownType, interfaceThrownTypes, substitutor)) continue;
                    return null;
                }
                if (!suggestUnhandledThrowables) {
                    for (PsiClassType thrownType : interfaceThrownTypes) {
                        PsiCodeBlock codeBlock = (PsiCodeBlock)PsiTreeUtil.getContextOfType((PsiElement)method, (Class[])new Class[]{PsiCodeBlock.class});
                        PsiType substitutedThrowable = substitutor.substitute((PsiType)thrownType);
                        if (codeBlock != null && substitutedThrowable instanceof PsiClassType && ExceptionUtil.isHandled((PsiClassType)substitutedThrowable, (PsiElement)codeBlock)) continue;
                        return null;
                    }
                }
                PsiElementFactory elementFactory = JavaPsiFacade.getElementFactory((Project)aClass.getProject());
                return elementFactory.createType(aClass, substitutor);
            }
            return null;
        }));
    }

    private static <T extends PsiElement> Collection<? extends PsiType> suggestFunctionalInterfaces(@NotNull T element, NullableFunction<? super PsiClass, ? extends PsiType> acceptanceChecker) {
        GlobalSearchScope allScope;
        if (element == null) {
            FunctionalInterfaceSuggester.$$$reportNull$$$0(3);
        }
        Project project = element.getProject();
        HashSet types = new HashSet();
        Processor consumer = member -> {
            if (element == null) {
                FunctionalInterfaceSuggester.$$$reportNull$$$0(6);
            }
            if (member instanceof PsiClass && Java15APIUsageInspection.getLastIncompatibleLanguageLevel(member, PsiUtil.getLanguageLevel((PsiElement)element)) == null) {
                if (!JavaPsiFacade.getInstance((Project)project).getResolveHelper().isAccessible(member, element, null)) {
                    return true;
                }
                ContainerUtil.addIfNotNull((Collection)types, (Object)acceptanceChecker.fun((Object)((PsiClass)member)));
            }
            return true;
        };
        JavaPsiFacade psiFacade = JavaPsiFacade.getInstance((Project)project);
        PsiClass functionalInterfaceClass = psiFacade.findClass("java.lang.FunctionalInterface", allScope = GlobalSearchScope.allScope((Project)project));
        if (functionalInterfaceClass != null) {
            AnnotatedMembersSearch.search((PsiClass)functionalInterfaceClass, (SearchScope)element.getResolveScope()).forEach(consumer);
        }
        for (String functionalInterface : FUNCTIONAL_INTERFACES) {
            PsiClass aClass = psiFacade.findClass(functionalInterface, element.getResolveScope());
            if (aClass == null) continue;
            consumer.process((Object)aClass);
        }
        ArrayList typesToSuggest = new ArrayList(types);
        Collections.sort(typesToSuggest, Comparator.comparing(PsiType::getCanonicalText));
        return typesToSuggest;
    }

    private static PsiType composeAcceptableType(@NotNull PsiClass interface2Consider, @NotNull PsiFunctionalExpression expression2, PsiType qualifierType) {
        PsiElementFactory elementFactory;
        PsiClassType type2;
        if (interface2Consider == null) {
            FunctionalInterfaceSuggester.$$$reportNull$$$0(4);
        }
        if (expression2 == null) {
            FunctionalInterfaceSuggester.$$$reportNull$$$0(5);
        }
        if (expression2.isAcceptable((PsiType)(type2 = (elementFactory = JavaPsiFacade.getElementFactory((Project)interface2Consider.getProject())).createType(interface2Consider, PsiSubstitutor.EMPTY)))) {
            return type2;
        }
        return FunctionalInterfaceSuggester.composeAcceptableType(interface2Consider, expression2, qualifierType, elementFactory);
    }

    private static PsiType composeAcceptableType(PsiClass interface2Consider, PsiFunctionalExpression expression2, PsiType qualifierType, PsiElementFactory elementFactory) {
        PsiMethod interfaceMethod;
        if (interface2Consider.hasTypeParameters() && (interfaceMethod = LambdaUtil.getFunctionalInterfaceMethod((PsiClass)interface2Consider)) != null) {
            PsiParameter[] functionalExprParameters;
            PsiType[] right;
            PsiType[] left;
            PsiParameter[] parameters2 = interfaceMethod.getParameterList().getParameters();
            int offset = 0;
            if (expression2 instanceof PsiLambdaExpression && ((PsiLambdaExpression)expression2).hasFormalParameterTypes()) {
                left = new PsiType[parameters2.length];
                right = new PsiType[parameters2.length];
                functionalExprParameters = ((PsiLambdaExpression)expression2).getParameterList().getParameters();
                if (parameters2.length != functionalExprParameters.length) {
                    return null;
                }
            } else if (expression2 instanceof PsiMethodReferenceExpression) {
                left = new PsiType[parameters2.length + 1];
                right = new PsiType[parameters2.length + 1];
                PsiMethod method = FunctionalInterfaceSuggester.getTargetMethod((PsiMethodReferenceExpression)expression2, qualifierType, parameters2, left, right);
                if (method == null) {
                    return null;
                }
                functionalExprParameters = method.getParameterList().getParameters();
                if (PsiMethodReferenceUtil.isStaticallyReferenced((PsiMethodReferenceExpression)((PsiMethodReferenceExpression)expression2)) && !method.hasModifierProperty("static")) {
                    offset = 1;
                }
                left[parameters2.length] = method.getReturnType();
                right[parameters2.length] = interfaceMethod.getReturnType();
            } else {
                return null;
            }
            for (int i = 0; i < functionalExprParameters.length; ++i) {
                left[i + offset] = parameters2[i + offset].getType();
                right[i + offset] = functionalExprParameters[i].getType();
            }
            PsiSubstitutor substitutor = PsiResolveHelper.SERVICE.getInstance((Project)interface2Consider.getProject()).inferTypeArguments(interface2Consider.getTypeParameters(), left, right, PsiUtil.getLanguageLevel((PsiElement)expression2));
            PsiClassType type2 = elementFactory.createType(interface2Consider, substitutor);
            if (expression2.isAcceptable((PsiType)type2)) {
                return type2;
            }
        }
        return null;
    }

    @Nullable
    private static PsiMethod getTargetMethod(PsiMethodReferenceExpression expression2, PsiType qualifierType, PsiParameter[] parameters2, PsiType[] left, PsiType[] right) {
        JavaResolveResult[] results;
        boolean staticallyReferenced = PsiMethodReferenceUtil.isStaticallyReferenced((PsiMethodReferenceExpression)expression2);
        for (JavaResolveResult result : results = expression2.multiResolve(true)) {
            PsiElement element = result.getElement();
            if (!(element instanceof PsiMethod)) continue;
            int offset = staticallyReferenced && !((PsiMethod)element).hasModifierProperty("static") ? 1 : 0;
            PsiParameter[] functionalExprParameters = ((PsiMethod)element).getParameterList().getParameters();
            if (functionalExprParameters.length + offset != parameters2.length) continue;
            if (offset > 0) {
                if (qualifierType == null) continue;
                left[0] = parameters2[0].getType();
                right[0] = qualifierType;
            }
            return (PsiMethod)element;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 1: 
            case 2: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "interface2Consider";
                break;
            }
        }
        objectArray2[1] = "com/intellij/codeInsight/FunctionalInterfaceSuggester";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "suggestFunctionalInterfaces";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "composeAcceptableType";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$suggestFunctionalInterfaces$2";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$suggestFunctionalInterfaces$1";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$suggestFunctionalInterfaces$0";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

