/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight;

import com.intellij.codeInsight.CodeInsightSettings;
import com.intellij.codeInsight.ExternalAnnotationsLineMarkerProvider;
import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.codeInsight.intention.LowPriorityAction;
import com.intellij.codeInsight.intention.impl.BaseIntentionAction;
import com.intellij.codeInsight.javadoc.AnnotationDocGenerator;
import com.intellij.openapi.command.undo.BasicUndoableAction;
import com.intellij.openapi.command.undo.UndoManager;
import com.intellij.openapi.command.undo.UndoableAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class ToggleSourceInferredAnnotations
extends BaseIntentionAction
implements LowPriorityAction {
    @Nls
    @NotNull
    public String getFamilyName() {
        if ("Show/Hide Gutter Icon for Annotations Inferred from Source Code" == null) {
            ToggleSourceInferredAnnotations.$$$reportNull$$$0(0);
        }
        return "Show/Hide Gutter Icon for Annotations Inferred from Source Code";
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        PsiElement leaf;
        PsiModifierListOwner owner;
        if (project == null) {
            ToggleSourceInferredAnnotations.$$$reportNull$$$0(1);
        }
        if ((owner = ExternalAnnotationsLineMarkerProvider.getAnnotationOwner(leaf = file.findElementAt(editor.getCaretModel().getOffset()))) != null) {
            boolean hasSrcInferredAnnotation = ContainerUtil.exists(AnnotationDocGenerator.getAnnotationsToShow(owner), AnnotationDocGenerator::isInferredFromSource);
            if (!hasSrcInferredAnnotation && owner instanceof PsiMethod) {
                hasSrcInferredAnnotation = StreamEx.of((Object[])((PsiMethod)owner).getParameterList().getParameters()).flatCollection(AnnotationDocGenerator::getAnnotationsToShow).anyMatch(AnnotationDocGenerator::isInferredFromSource);
            }
            if (hasSrcInferredAnnotation) {
                this.setText((CodeInsightSettings.getInstance().SHOW_SOURCE_INFERRED_ANNOTATIONS ? "Hide" : "Show") + " gutter icon for annotations inferred from source code");
                return true;
            }
        }
        return false;
    }

    public void invoke(final @NotNull Project project, Editor editor, final PsiFile file) throws IncorrectOperationException {
        if (project == null) {
            ToggleSourceInferredAnnotations.$$$reportNull$$$0(2);
        }
        final boolean showAnnotations = !CodeInsightSettings.getInstance().SHOW_SOURCE_INFERRED_ANNOTATIONS;
        ToggleSourceInferredAnnotations.showAnnotations(project, file, showAnnotations);
        UndoManager.getInstance((Project)project).undoableActionPerformed((UndoableAction)new BasicUndoableAction(new VirtualFile[]{file.getVirtualFile()}){

            public void undo() {
                ToggleSourceInferredAnnotations.showAnnotations(project, file, !showAnnotations);
            }

            public void redo() {
                ToggleSourceInferredAnnotations.showAnnotations(project, file, showAnnotations);
            }
        });
    }

    private static void showAnnotations(@NotNull Project project, PsiFile file, boolean showAnnotations) {
        if (project == null) {
            ToggleSourceInferredAnnotations.$$$reportNull$$$0(3);
        }
        CodeInsightSettings.getInstance().SHOW_SOURCE_INFERRED_ANNOTATIONS = showAnnotations;
        DaemonCodeAnalyzer.getInstance((Project)project).restart(file);
    }

    public boolean startInWriteAction() {
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/ToggleSourceInferredAnnotations";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/ToggleSourceInferredAnnotations";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "showAnnotations";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

