/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.completion;

import com.intellij.codeInsight.completion.AutoCompletionContext;
import com.intellij.codeInsight.completion.AutoCompletionDecision;
import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.codeInsight.completion.JavaCompletionUtil;
import com.intellij.codeInsight.completion.JavaMethodCallElement;
import com.intellij.codeInsight.hint.ParameterInfoController;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.openapi.util.Key;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiType;
import com.intellij.util.ObjectUtils;
import java.util.ArrayList;
import java.util.Collection;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaMethodMergingContributor
extends CompletionContributor {
    static final Key<Boolean> MERGED_ELEMENT = Key.create((String)"merged.element");

    public AutoCompletionDecision handleAutoCompletionPossibility(@NotNull AutoCompletionContext context) {
        CompletionParameters parameters2;
        if (context == null) {
            JavaMethodMergingContributor.$$$reportNull$$$0(0);
        }
        if ((parameters2 = context.getParameters()).getCompletionType() != CompletionType.SMART && parameters2.getCompletionType() != CompletionType.BASIC) {
            return null;
        }
        if (ParameterInfoController.areParameterTemplatesEnabledOnCompletion()) {
            return null;
        }
        LookupElement[] items = context.getItems();
        if (items.length > 1) {
            String commonName = null;
            ArrayList<PsiMethod> allMethods = new ArrayList<PsiMethod>();
            for (LookupElement item : items) {
                PsiElement o = item.getPsiElement();
                if (item.getUserData(JavaCompletionUtil.FORCE_SHOW_SIGNATURE_ATTR) != null || !(o instanceof PsiMethod)) {
                    return AutoCompletionDecision.SHOW_LOOKUP;
                }
                String name = JavaMethodMergingContributor.joinLookupStrings(item);
                if (commonName != null && !commonName.equals(name)) {
                    return AutoCompletionDecision.SHOW_LOOKUP;
                }
                commonName = name;
                allMethods.add((PsiMethod)o);
            }
            for (LookupElement item : items) {
                JavaCompletionUtil.putAllMethods(item, allMethods);
            }
            LookupElement best = JavaMethodMergingContributor.findBestOverload(items);
            JavaMethodMergingContributor.markAsMerged(best);
            return AutoCompletionDecision.insertItem((LookupElement)best);
        }
        return super.handleAutoCompletionPossibility(context);
    }

    private static void markAsMerged(LookupElement element) {
        JavaMethodCallElement methodCallElement = (JavaMethodCallElement)element.as(JavaMethodCallElement.CLASS_CONDITION_KEY);
        if (methodCallElement != null) {
            methodCallElement.putUserData(MERGED_ELEMENT, Boolean.TRUE);
        }
    }

    public static String joinLookupStrings(LookupElement item) {
        return ((StreamEx)StreamEx.of((Collection)item.getAllLookupStrings()).sorted()).joining((CharSequence)"#");
    }

    public static LookupElement findBestOverload(LookupElement[] items) {
        LookupElement best = items[0];
        for (int i = 1; i < items.length; ++i) {
            LookupElement item = items[i];
            if (JavaMethodMergingContributor.getPriority(best) >= JavaMethodMergingContributor.getPriority(item)) continue;
            best = item;
        }
        return best;
    }

    private static int getPriority(LookupElement element) {
        PsiMethod method = (PsiMethod)ObjectUtils.assertNotNull((Object)JavaMethodMergingContributor.getItemMethod(element));
        return (PsiType.VOID.equals((Object)method.getReturnType()) ? 0 : 1) + (method.getParameterList().isEmpty() ? 0 : 2);
    }

    @Nullable
    private static PsiMethod getItemMethod(LookupElement item) {
        PsiElement o = item.getPsiElement();
        return o instanceof PsiMethod ? (PsiMethod)o : null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/codeInsight/completion/JavaMethodMergingContributor", "handleAutoCompletionPossibility"));
    }
}

