/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.codeHighlighting.TextEditorHighlightingPass;
import com.intellij.codeHighlighting.TextEditorHighlightingPassFactory;
import com.intellij.codeHighlighting.TextEditorHighlightingPassRegistrar;
import com.intellij.codeInsight.daemon.impl.JavaSoftKeywordHighlightingPass;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaFile;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001a\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u000b"}, d2={"Lcom/intellij/codeInsight/daemon/impl/JavaSoftKeywordHighlightingPassFactory;", "Lcom/intellij/codeHighlighting/TextEditorHighlightingPassFactory;", "registrar", "Lcom/intellij/codeHighlighting/TextEditorHighlightingPassRegistrar;", "(Lcom/intellij/codeHighlighting/TextEditorHighlightingPassRegistrar;)V", "createHighlightingPass", "Lcom/intellij/codeHighlighting/TextEditorHighlightingPass;", "file", "Lcom/intellij/psi/PsiFile;", "editor", "Lcom/intellij/openapi/editor/Editor;", "intellij.java.analysis.impl"})
public final class JavaSoftKeywordHighlightingPassFactory
implements TextEditorHighlightingPassFactory {
    @Nullable
    public TextEditorHighlightingPass createHighlightingPass(@NotNull PsiFile file, @NotNull Editor editor) {
        TextEditorHighlightingPass textEditorHighlightingPass;
        boolean visit;
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        Intrinsics.checkParameterIsNotNull((Object)editor, (String)"editor");
        boolean bl = visit = file instanceof PsiJavaFile && (Intrinsics.areEqual((Object)((PsiJavaFile)file).getName(), (Object)"module-info.java") && ((PsiJavaFile)file).getLanguageLevel().isAtLeast(LanguageLevel.JDK_1_9) || ((PsiJavaFile)file).getLanguageLevel().isAtLeast(LanguageLevel.JDK_10));
        if (visit) {
            PsiJavaFile psiJavaFile = (PsiJavaFile)file;
            Document document = editor.getDocument();
            Intrinsics.checkExpressionValueIsNotNull((Object)document, (String)"editor.document");
            textEditorHighlightingPass = new JavaSoftKeywordHighlightingPass(psiJavaFile, document);
        } else {
            textEditorHighlightingPass = null;
        }
        return textEditorHighlightingPass;
    }

    public JavaSoftKeywordHighlightingPassFactory(@NotNull TextEditorHighlightingPassRegistrar registrar) {
        Intrinsics.checkParameterIsNotNull((Object)registrar, (String)"registrar");
        registrar.registerTextEditorHighlightingPass((TextEditorHighlightingPassFactory)this, null, null, false, -1);
    }
}

