/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.ExceptionUtil;
import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInsight.intention.PsiElementBaseIntentionAction;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pass;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiCatchSection;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiDisjunctionType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiTryStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.util.PsiUtil;
import com.intellij.refactoring.IntroduceTargetChooser;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AddExceptionToExistingCatchFix
extends PsiElementBaseIntentionAction {
    private final PsiElement myErrorElement;

    public AddExceptionToExistingCatchFix(PsiElement errorElement) {
        this.myErrorElement = errorElement;
    }

    public void invoke(@NotNull Project project, Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
        if (project == null) {
            AddExceptionToExistingCatchFix.$$$reportNull$$$0(0);
        }
        if (element == null) {
            AddExceptionToExistingCatchFix.$$$reportNull$$$0(1);
        }
        if (!FileModificationService.getInstance().preparePsiElementsForWrite(new PsiElement[]{this.myErrorElement})) {
            return;
        }
        Context context = Context.from(this.myErrorElement);
        if (context == null) {
            return;
        }
        List catchSections = context.myCatches;
        final List unhandledExceptions = context.myExceptions;
        List catches = ContainerUtil.filter((Collection)catchSections, s -> s.getCatchType() != null && s.getParameter() != null);
        this.setText(context.getMessage());
        Application application = ApplicationManager.getApplication();
        if (catchSections.size() == 1 || application.isUnitTestMode()) {
            PsiCatchSection selectedSection = (PsiCatchSection)catchSections.get(0);
            AddExceptionToExistingCatchFix.addTypeToCatch(unhandledExceptions, selectedSection);
        } else {
            IntroduceTargetChooser.showChooser((Editor)editor, (List)catches, (Pass)new Pass<PsiCatchSection>(){

                public void pass(PsiCatchSection section) {
                    AddExceptionToExistingCatchFix.addTypeToCatch(unhandledExceptions, section);
                }
            }, section -> Objects.requireNonNull(section.getCatchType()).getPresentableText(), (String)QuickFixBundle.message("add.exception.to.existing.catch.chooser.title", new Object[0]), catchSection -> Objects.requireNonNull(((PsiCatchSection)catchSection).getParameter()).getTextRange());
        }
    }

    private static void addTypeToCatch(@NotNull List<PsiClassType> exceptionsToAdd, @NotNull PsiCatchSection catchSection) {
        if (exceptionsToAdd == null) {
            AddExceptionToExistingCatchFix.$$$reportNull$$$0(2);
        }
        if (catchSection == null) {
            AddExceptionToExistingCatchFix.$$$reportNull$$$0(3);
        }
        Project project = catchSection.getProject();
        WriteCommandAction.runWriteCommandAction((Project)project, () -> {
            if (catchSection == null) {
                AddExceptionToExistingCatchFix.$$$reportNull$$$0(11);
            }
            if (exceptionsToAdd == null) {
                AddExceptionToExistingCatchFix.$$$reportNull$$$0(12);
            }
            if (!catchSection.isValid() || !exceptionsToAdd.stream().allMatch(type2 -> type2.isValid())) {
                return;
            }
            PsiParameter parameter2 = catchSection.getParameter();
            if (parameter2 == null) {
                return;
            }
            PsiTypeElement typeElement = parameter2.getTypeElement();
            if (typeElement == null) {
                return;
            }
            PsiType parameterType = parameter2.getType();
            PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)project);
            String flattenText = AddExceptionToExistingCatchFix.getTypeText(exceptionsToAdd, parameter2, parameterType, factory);
            PsiElement newTypeElement = typeElement.replace((PsiElement)factory.createTypeElementFromText(flattenText, (PsiElement)parameter2));
            CodeStyleManager.getInstance((Project)project).reformat(JavaCodeStyleManager.getInstance((Project)project).shortenClassReferences(newTypeElement));
        });
    }

    private static String getTypeText(@NotNull List<PsiClassType> exceptionsToAdd, PsiParameter parameter2, PsiType parameterType, PsiElementFactory factory) {
        if (exceptionsToAdd == null) {
            AddExceptionToExistingCatchFix.$$$reportNull$$$0(4);
        }
        String typeText = parameterType.getCanonicalText() + " | " + exceptionsToAdd.stream().map(type2 -> type2.getCanonicalText()).collect(Collectors.joining(" | "));
        PsiTypeElement element = factory.createTypeElementFromText(typeText, (PsiElement)parameter2);
        List flatten = PsiDisjunctionType.flattenAndRemoveDuplicates((List)((PsiDisjunctionType)element.getType()).getDisjunctions());
        return flatten.stream().map(type2 -> type2.getCanonicalText()).collect(Collectors.joining(" | "));
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, @NotNull PsiElement element) {
        if (project == null) {
            AddExceptionToExistingCatchFix.$$$reportNull$$$0(5);
        }
        if (element == null) {
            AddExceptionToExistingCatchFix.$$$reportNull$$$0(6);
        }
        return Context.from(this.myErrorElement) != null;
    }

    @Nls
    @NotNull
    public String getFamilyName() {
        String string = QuickFixBundle.message("add.exception.to.existing.catch.family", new Object[0]);
        if (string == null) {
            AddExceptionToExistingCatchFix.$$$reportNull$$$0(7);
        }
        return string;
    }

    @NotNull
    public String getText() {
        String string = this.getFamilyName();
        if (string == null) {
            AddExceptionToExistingCatchFix.$$$reportNull$$$0(8);
        }
        return string;
    }

    private static boolean replacementNeeded(@NotNull PsiClassType newException, @NotNull PsiType catchType) {
        if (newException == null) {
            AddExceptionToExistingCatchFix.$$$reportNull$$$0(9);
        }
        if (catchType == null) {
            AddExceptionToExistingCatchFix.$$$reportNull$$$0(10);
        }
        if (catchType instanceof PsiDisjunctionType) {
            PsiDisjunctionType disjunction = (PsiDisjunctionType)catchType;
            for (PsiType type2 : disjunction.getDisjunctions()) {
                if (!type2.isAssignableFrom((PsiType)newException)) continue;
                return true;
            }
            return false;
        }
        return catchType.isAssignableFrom((PsiType)newException);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: 
            case 4: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "exceptionsToAdd";
                break;
            }
            case 3: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "catchSection";
                break;
            }
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/daemon/impl/quickfix/AddExceptionToExistingCatchFix";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newException";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "catchType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/daemon/impl/quickfix/AddExceptionToExistingCatchFix";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "addTypeToCatch";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getTypeText";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 7: 
            case 8: {
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "replacementNeeded";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "lambda$addTypeToCatch$4";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class Context {
        private final List<PsiCatchSection> myCatches;
        private final List<PsiClassType> myExceptions;

        private Context(List<PsiCatchSection> catches, List<PsiClassType> exceptions) {
            this.myCatches = catches;
            this.myExceptions = exceptions;
        }

        @Nullable
        static Context from(@NotNull PsiElement element) {
            if (element == null) {
                Context.$$$reportNull$$$0(0);
            }
            if (!element.isValid() || !PsiUtil.isLanguageLevel7OrHigher((PsiElement)element)) {
                return null;
            }
            ArrayList<PsiClassType> unhandledExceptions = new ArrayList<PsiClassType>(ExceptionUtil.getOwnUnhandledExceptions(element));
            if (unhandledExceptions.isEmpty()) {
                return null;
            }
            List<PsiTryStatement> tryStatements = Context.getTryStatements(element);
            List<PsiCatchSection> sections = tryStatements.stream().flatMap(stmt -> Arrays.stream(stmt.getCatchSections())).filter(catchSection -> {
                PsiParameter parameter2 = catchSection.getParameter();
                if (parameter2 == null) {
                    return false;
                }
                return parameter2.getTypeElement() != null;
            }).collect(Collectors.toList());
            if (sections.isEmpty()) {
                return null;
            }
            return new Context(sections, unhandledExceptions);
        }

        @NotNull
        private static List<PsiTryStatement> getTryStatements(@NotNull PsiElement element) {
            if (element == null) {
                Context.$$$reportNull$$$0(1);
            }
            PsiElement current = element;
            SmartList parents2 = new SmartList();
            for (PsiElement parent = element.getParent(); !(parent == null || parent instanceof PsiLambdaExpression || parent instanceof PsiMember || parent instanceof PsiFile); parent = parent.getParent()) {
                PsiTryStatement tryStatement;
                if (parent instanceof PsiTryStatement && (tryStatement = (PsiTryStatement)parent).getFinallyBlock() != current && !(current instanceof PsiCatchSection)) {
                    parents2.add((PsiTryStatement)parent);
                }
                current = parent;
            }
            SmartList smartList = parents2;
            if (smartList == null) {
                Context.$$$reportNull$$$0(2);
            }
            return smartList;
        }

        private String getMessage() {
            if (this.myCatches.size() == 1 && this.myExceptions.size() == 1) {
                PsiClassType exceptionType = this.myExceptions.get(0);
                PsiCatchSection catchSection = this.myCatches.get(0);
                PsiParameter parameter2 = catchSection.getParameter();
                assert (parameter2 != null);
                PsiType catchType = parameter2.getType();
                if (AddExceptionToExistingCatchFix.replacementNeeded(exceptionType, catchType)) {
                    return QuickFixBundle.message("add.exception.to.existing.catch.replacement", catchType.getPresentableText(), exceptionType.getPresentableText());
                }
                return QuickFixBundle.message("add.exception.to.existing.catch.no.replacement", catchType.getPresentableText(), exceptionType.getPresentableText());
            }
            return QuickFixBundle.message("add.exception.to.existing.catch.generic", new Object[0]);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInsight/daemon/impl/quickfix/AddExceptionToExistingCatchFix$Context";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInsight/daemon/impl/quickfix/AddExceptionToExistingCatchFix$Context";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getTryStatements";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "from";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "getTryStatements";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

