/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class DeclarationSearcher {
    private final PsiMethod myMethod;
    private final PsiType myTargetType;
    private final Map<PsiElement, PsiVariable> cache;

    DeclarationSearcher(@NotNull PsiMethod method, @NotNull PsiType targetType) {
        if (method == null) {
            DeclarationSearcher.$$$reportNull$$$0(0);
        }
        if (targetType == null) {
            DeclarationSearcher.$$$reportNull$$$0(1);
        }
        this.cache = new HashMap<PsiElement, PsiVariable>();
        this.myMethod = method;
        this.myTargetType = targetType;
    }

    @Nullable
    public PsiVariable getDeclaration(@NotNull PsiElement endPositionElement) {
        PsiVariable localVariable;
        if (endPositionElement == null) {
            DeclarationSearcher.$$$reportNull$$$0(2);
        }
        if ((localVariable = this.getLocalDeclaration(endPositionElement)) != null) {
            return localVariable;
        }
        return this.getParameterDeclaration();
    }

    @Nullable
    private PsiVariable getParameterDeclaration() {
        for (PsiParameter parameter2 : this.myMethod.getParameterList().getParameters()) {
            if (!this.myTargetType.equals(parameter2.getType())) continue;
            return this.goThroughCache((PsiElement)this.myMethod, (PsiVariable)parameter2);
        }
        return null;
    }

    @Nullable
    private PsiVariable getLocalDeclaration(@NotNull PsiElement endPositionElement) {
        PsiVariable parentResult;
        PsiElement parent;
        if (endPositionElement == null) {
            DeclarationSearcher.$$$reportNull$$$0(3);
        }
        if ((parent = endPositionElement.getParent()) == null) {
            return null;
        }
        PsiVariable cachedCandidate = this.cache.get(parent);
        if (cachedCandidate != null) {
            return cachedCandidate;
        }
        if (parent != this.myMethod && (parentResult = this.getLocalDeclaration(parent)) != null) {
            return parentResult;
        }
        for (PsiElement element : parent.getChildren()) {
            if (element == endPositionElement) break;
            if (element instanceof PsiDeclarationStatement) {
                PsiElement[] declared;
                for (PsiElement declaredElement : declared = ((PsiDeclarationStatement)element).getDeclaredElements()) {
                    if (!(declaredElement instanceof PsiLocalVariable) || !this.myTargetType.equals(((PsiLocalVariable)declaredElement).getType())) continue;
                    return this.goThroughCache(parent, (PsiVariable)declaredElement);
                }
                continue;
            }
            if (!(element instanceof PsiParameter) || !this.myTargetType.equals(((PsiParameter)element).getType())) continue;
            return this.goThroughCache(parent, (PsiVariable)element);
        }
        return null;
    }

    private PsiVariable goThroughCache(PsiElement parent, PsiVariable variable) {
        this.cache.put(parent, variable);
        return variable;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetType";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "endPositionElement";
                break;
            }
        }
        objectArray2[1] = "com/intellij/codeInsight/daemon/impl/quickfix/DeclarationSearcher";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getDeclaration";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "getLocalDeclaration";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

