/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.ExceptionUtil;
import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInsight.javadoc.JavaDocUtil;
import com.intellij.codeInspection.LocalQuickFixOnPsiElement;
import com.intellij.find.findUsages.JavaFindUsagesHelper;
import com.intellij.find.findUsages.JavaMethodFindUsagesOptions;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.ReadonlyStatusHandler;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.javadoc.PsiDocComment;
import com.intellij.psi.util.PsiFormatUtil;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.Processor;
import com.intellij.util.SmartList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;

public abstract class MethodThrowsFix
extends LocalQuickFixOnPsiElement {
    protected final String myThrowsCanonicalText;
    private final String myMethodName;

    protected MethodThrowsFix(@NotNull PsiMethod method, @NotNull PsiClassType exceptionType, boolean showClassName) {
        if (method == null) {
            MethodThrowsFix.$$$reportNull$$$0(0);
        }
        if (exceptionType == null) {
            MethodThrowsFix.$$$reportNull$$$0(1);
        }
        super((PsiElement)method);
        this.myThrowsCanonicalText = exceptionType.getCanonicalText();
        this.myMethodName = PsiFormatUtil.formatMethod((PsiMethod)method, (PsiSubstitutor)PsiSubstitutor.EMPTY, (int)(1 | (showClassName ? 4096 : 0)), (int)0);
    }

    @NotNull
    protected abstract String getTextMessageKey();

    @NotNull
    public final String getText() {
        String string = QuickFixBundle.message(this.getTextMessageKey(), StringUtil.getShortName((String)this.myThrowsCanonicalText), this.myMethodName);
        if (string == null) {
            MethodThrowsFix.$$$reportNull$$$0(2);
        }
        return string;
    }

    @NotNull
    public final String getFamilyName() {
        String string = QuickFixBundle.message("fix.throws.list.family", new Object[0]);
        if (string == null) {
            MethodThrowsFix.$$$reportNull$$$0(3);
        }
        return string;
    }

    public final boolean isAvailable(@NotNull Project project, @NotNull PsiFile file, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
        if (project == null) {
            MethodThrowsFix.$$$reportNull$$$0(4);
        }
        if (file == null) {
            MethodThrowsFix.$$$reportNull$$$0(5);
        }
        if (startElement == null) {
            MethodThrowsFix.$$$reportNull$$$0(6);
        }
        if (endElement == null) {
            MethodThrowsFix.$$$reportNull$$$0(7);
        }
        return !(((PsiMethod)startElement).getThrowsList() instanceof PsiCompiledElement);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "exceptionType";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/daemon/impl/quickfix/MethodThrowsFix";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "startElement";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "endElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/daemon/impl/quickfix/MethodThrowsFix";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class Remove
    extends MethodThrowsFix {
        public Remove(@NotNull PsiMethod method, @NotNull PsiClassType exceptionType, boolean showClassName) {
            if (method == null) {
                Remove.$$$reportNull$$$0(0);
            }
            if (exceptionType == null) {
                Remove.$$$reportNull$$$0(1);
            }
            super(method, exceptionType, showClassName);
        }

        public boolean startInWriteAction() {
            return false;
        }

        @Override
        @NotNull
        protected String getTextMessageKey() {
            if ("fix.throws.list.remove.exception" == null) {
                Remove.$$$reportNull$$$0(2);
            }
            return "fix.throws.list.remove.exception";
        }

        public void invoke(@NotNull Project project, @NotNull PsiFile file, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
            if (project == null) {
                Remove.$$$reportNull$$$0(3);
            }
            if (file == null) {
                Remove.$$$reportNull$$$0(4);
            }
            if (startElement == null) {
                Remove.$$$reportNull$$$0(5);
            }
            if (endElement == null) {
                Remove.$$$reportNull$$$0(6);
            }
            if (!ReadonlyStatusHandler.ensureFilesWritable((Project)project, (VirtualFile[])new VirtualFile[]{file.getVirtualFile()})) {
                return;
            }
            PsiMethod method = (PsiMethod)startElement;
            PsiClassType exception = JavaPsiFacade.getElementFactory((Project)project).createTypeByFQClassName(this.myThrowsCanonicalText, method.getResolveScope());
            if (!ExceptionUtil.isUncheckedException(exception)) {
                boolean breakSourceCode;
                JavaMethodFindUsagesOptions ops = new JavaMethodFindUsagesOptions(project);
                ops.isSearchForTextOccurrences = false;
                ops.isImplicitToString = false;
                ops.isSkipImportStatements = true;
                boolean bl = breakSourceCode = (Boolean)ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> JavaFindUsagesHelper.processElementUsages((PsiElement)method, ops, (Processor<? super UsageInfo>)((Processor)usage -> {
                    ExceptionUtil.HandlePlace place;
                    PsiElement element = usage.getElement();
                    if (!(element instanceof PsiReferenceExpression)) {
                        return true;
                    }
                    PsiElement parent = element.getParent();
                    if (parent instanceof PsiCallExpression && (place = ExceptionUtil.getHandlePlace(parent, exception, null)) instanceof ExceptionUtil.HandlePlace.TryCatch) {
                        PsiParameter parameter2 = ((ExceptionUtil.HandlePlace.TryCatch)place).getParameter();
                        PsiCodeBlock block = ((ExceptionUtil.HandlePlace.TryCatch)place).getTryStatement().getTryBlock();
                        if (block != null) {
                            PsiCallExpression call = (PsiCallExpression)parent;
                            Collection<PsiClassType> types = ExceptionUtil.collectUnhandledExceptions((PsiElement)block, null, call);
                            if (types.contains(exception)) {
                                return true;
                            }
                            ArrayList<PsiClassType> thrownCheckedExceptions = new ArrayList<PsiClassType>(ExceptionUtil.getThrownCheckedExceptions(new PsiElement[]{call}));
                            thrownCheckedExceptions.remove(exception);
                            PsiType caughtExceptionType = parameter2.getType();
                            if (Stream.concat(types.stream(), thrownCheckedExceptions.stream()).noneMatch(ex -> caughtExceptionType.isAssignableFrom((PsiType)ex))) {
                                return false;
                            }
                        }
                    }
                    return true;
                })), "Processing Method Usages...", true, project) == false;
                if (breakSourceCode && Messages.showYesNoDialog((Project)project, (String)"Exception removal will break source code. Proceed anyway?", (String)RefactoringBundle.getCannotRefactorMessage(null), null) == 1) {
                    return;
                }
            }
            PsiType exceptionType = JavaPsiFacade.getElementFactory((Project)project).createTypeFromText(this.myThrowsCanonicalText, null);
            WriteAction.run(() -> {
                for (PsiElement element : Remove.extractRefsToRemove(method, exceptionType)) {
                    element.delete();
                }
            });
        }

        public static PsiElement[] extractRefsToRemove(PsiMethod method, PsiType exceptionType) {
            SmartList refs = new SmartList();
            PsiJavaCodeReferenceElement[] referenceElements = method.getThrowsList().getReferenceElements();
            PsiElementFactory elementFactory = JavaPsiFacade.getElementFactory((Project)method.getProject());
            Arrays.stream(referenceElements).filter(ref -> {
                PsiClassType refType = elementFactory.createType(ref);
                return exceptionType.isAssignableFrom((PsiType)refType);
            }).forEach(((List)refs)::add);
            PsiDocComment comment = method.getDocComment();
            if (comment != null) {
                Arrays.stream(comment.getTags()).filter(tag -> "throws".equals(tag.getName())).filter(tag -> {
                    PsiClass tagValueClass = JavaDocUtil.resolveClassInTagValue(tag.getValueElement());
                    if (tagValueClass == null) {
                        return false;
                    }
                    PsiClassType tagValueType = elementFactory.createType(tagValueClass);
                    return exceptionType.isAssignableFrom((PsiType)tagValueType);
                }).forEach(((List)refs)::add);
            }
            return refs.toArray(PsiElement.EMPTY_ARRAY);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "method";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "exceptionType";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInsight/daemon/impl/quickfix/MethodThrowsFix$Remove";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "startElement";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "endElement";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInsight/daemon/impl/quickfix/MethodThrowsFix$Remove";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getTextMessageKey";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "invoke";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static class RemoveFirst
    extends MethodThrowsFix {
        public RemoveFirst(@NotNull PsiMethod method, @NotNull PsiClassType exceptionType, boolean showClassName) {
            if (method == null) {
                RemoveFirst.$$$reportNull$$$0(0);
            }
            if (exceptionType == null) {
                RemoveFirst.$$$reportNull$$$0(1);
            }
            super(method, exceptionType, showClassName);
        }

        @Override
        @NotNull
        protected String getTextMessageKey() {
            if ("fix.throws.list.remove.exception" == null) {
                RemoveFirst.$$$reportNull$$$0(2);
            }
            return "fix.throws.list.remove.exception";
        }

        public void invoke(@NotNull Project project, @NotNull PsiFile file, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
            if (project == null) {
                RemoveFirst.$$$reportNull$$$0(3);
            }
            if (file == null) {
                RemoveFirst.$$$reportNull$$$0(4);
            }
            if (startElement == null) {
                RemoveFirst.$$$reportNull$$$0(5);
            }
            if (endElement == null) {
                RemoveFirst.$$$reportNull$$$0(6);
            }
            PsiJavaCodeReferenceElement[] referenceElements = ((PsiMethod)startElement).getThrowsList().getReferenceElements();
            Arrays.stream(referenceElements).filter(referenceElement -> referenceElement.getCanonicalText().equals(this.myThrowsCanonicalText)).findFirst().ifPresent(PsiElement::delete);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "method";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "exceptionType";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInsight/daemon/impl/quickfix/MethodThrowsFix$RemoveFirst";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "startElement";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "endElement";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInsight/daemon/impl/quickfix/MethodThrowsFix$RemoveFirst";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getTextMessageKey";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "invoke";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static class Add
    extends MethodThrowsFix {
        public Add(@NotNull PsiMethod method, @NotNull PsiClassType exceptionType, boolean showClassName) {
            if (method == null) {
                Add.$$$reportNull$$$0(0);
            }
            if (exceptionType == null) {
                Add.$$$reportNull$$$0(1);
            }
            super(method, exceptionType, showClassName);
        }

        @Override
        @NotNull
        protected String getTextMessageKey() {
            if ("fix.throws.list.add.exception" == null) {
                Add.$$$reportNull$$$0(2);
            }
            return "fix.throws.list.add.exception";
        }

        public void invoke(@NotNull Project project, @NotNull PsiFile file, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
            PsiMethod myMethod;
            PsiJavaCodeReferenceElement[] referenceElements;
            boolean alreadyThrows;
            if (project == null) {
                Add.$$$reportNull$$$0(3);
            }
            if (file == null) {
                Add.$$$reportNull$$$0(4);
            }
            if (startElement == null) {
                Add.$$$reportNull$$$0(5);
            }
            if (endElement == null) {
                Add.$$$reportNull$$$0(6);
            }
            if (!(alreadyThrows = Arrays.stream(referenceElements = (myMethod = (PsiMethod)startElement).getThrowsList().getReferenceElements()).anyMatch(referenceElement -> referenceElement.getCanonicalText().equals(this.myThrowsCanonicalText)))) {
                PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)myMethod.getProject());
                PsiClassType type2 = (PsiClassType)factory.createTypeFromText(this.myThrowsCanonicalText, (PsiElement)myMethod);
                PsiJavaCodeReferenceElement ref = factory.createReferenceElementByType(type2);
                ref = (PsiJavaCodeReferenceElement)JavaCodeStyleManager.getInstance((Project)project).shortenClassReferences((PsiElement)ref);
                myMethod.getThrowsList().add((PsiElement)ref);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "method";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "exceptionType";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInsight/daemon/impl/quickfix/MethodThrowsFix$Add";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "startElement";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "endElement";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInsight/daemon/impl/quickfix/MethodThrowsFix$Add";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getTextMessageKey";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "invoke";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

