/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.daemon.QuickFixActionRegistrar;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNameValuePair;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;

public class SurroundWithQuotesAnnotationParameterValueFix
implements IntentionAction {
    private final PsiAnnotationMemberValue myValue;
    private final PsiType myExpectedType;

    public SurroundWithQuotesAnnotationParameterValueFix(PsiAnnotationMemberValue value2, PsiType expectedType) {
        this.myValue = value2;
        this.myExpectedType = expectedType;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        if (project == null) {
            SurroundWithQuotesAnnotationParameterValueFix.$$$reportNull$$$0(0);
        }
        if (!this.myValue.isValid() || !this.myExpectedType.isValid()) {
            return false;
        }
        PsiClass resolvedType = PsiUtil.resolveClassInType((PsiType)this.myExpectedType);
        if (resolvedType != null && "java.lang.String".equals(resolvedType.getQualifiedName())) {
            return this.myValue instanceof PsiLiteralExpression || this.myValue instanceof PsiReferenceExpression && ((PsiReferenceExpression)this.myValue).resolve() == null;
        }
        return false;
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
        if (project == null) {
            SurroundWithQuotesAnnotationParameterValueFix.$$$reportNull$$$0(1);
        }
        String newText = this.myValue.getText();
        newText = StringUtil.unquoteString((String)newText);
        newText = "\"" + newText + "\"";
        PsiExpression newToken = JavaPsiFacade.getElementFactory((Project)project).createExpressionFromText(newText, null);
        PsiElement newElement = this.myValue.replace((PsiElement)newToken);
        editor.getCaretModel().moveToOffset(newElement.getTextOffset() + newElement.getTextLength());
    }

    @NotNull
    public String getFamilyName() {
        if ("Surround annotation parameter value with quotes" == null) {
            SurroundWithQuotesAnnotationParameterValueFix.$$$reportNull$$$0(2);
        }
        return "Surround annotation parameter value with quotes";
    }

    @NotNull
    public String getText() {
        String string = this.getFamilyName();
        if (string == null) {
            SurroundWithQuotesAnnotationParameterValueFix.$$$reportNull$$$0(3);
        }
        return string;
    }

    public boolean startInWriteAction() {
        return true;
    }

    public static void register(@NotNull QuickFixActionRegistrar registrar, @NotNull PsiJavaCodeReferenceElement ref) {
        PsiType returnType;
        PsiElement annotationMethod;
        PsiReference reference;
        PsiElement parent;
        if (registrar == null) {
            SurroundWithQuotesAnnotationParameterValueFix.$$$reportNull$$$0(4);
        }
        if (ref == null) {
            SurroundWithQuotesAnnotationParameterValueFix.$$$reportNull$$$0(5);
        }
        if (ref instanceof PsiReferenceExpression && (parent = ref.getParent()) instanceof PsiNameValuePair && ((PsiNameValuePair)parent).getValue() == ref && (reference = parent.getReference()) != null && (annotationMethod = reference.resolve()) instanceof PsiMethod && (returnType = ((PsiMethod)annotationMethod).getReturnType()) != null) {
            registrar.register((IntentionAction)new SurroundWithQuotesAnnotationParameterValueFix((PsiAnnotationMemberValue)((PsiReferenceExpression)ref), returnType));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/daemon/impl/quickfix/SurroundWithQuotesAnnotationParameterValueFix";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "registrar";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ref";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/daemon/impl/quickfix/SurroundWithQuotesAnnotationParameterValueFix";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "register";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

