/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInsight.intention.impl.BaseIntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaRecursiveElementVisitor;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.refactoring.rename.inplace.MemberInplaceRenamer;
import com.intellij.refactoring.util.RefactoringUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SmartList;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.TypeUtils;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VariableAccessFromInnerClassJava10Fix
extends BaseIntentionAction {
    private static final String[] NAMES = new String[]{"ref", "lambdaContext", "context", "rContext"};
    private final PsiElement myContext;

    public VariableAccessFromInnerClassJava10Fix(PsiElement context) {
        this.myContext = context;
    }

    @Nls(capitalization=Nls.Capitalization.Sentence)
    @NotNull
    public String getFamilyName() {
        if ("Variable accessFromInnerClass" == null) {
            VariableAccessFromInnerClassJava10Fix.$$$reportNull$$$0(0);
        }
        return "Variable accessFromInnerClass";
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        if (project == null) {
            VariableAccessFromInnerClassJava10Fix.$$$reportNull$$$0(1);
        }
        if (!PsiUtil.isLanguageLevel10OrHigher((PsiElement)file)) {
            return false;
        }
        if (!this.myContext.isValid()) {
            return false;
        }
        PsiReferenceExpression reference = (PsiReferenceExpression)ObjectUtils.tryCast((Object)this.myContext, PsiReferenceExpression.class);
        if (reference == null) {
            return false;
        }
        PsiLocalVariable variable = (PsiLocalVariable)ObjectUtils.tryCast((Object)reference.resolve(), PsiLocalVariable.class);
        if (variable == null) {
            return false;
        }
        PsiDeclarationStatement declarationStatement = (PsiDeclarationStatement)ObjectUtils.tryCast((Object)variable.getParent(), PsiDeclarationStatement.class);
        if (declarationStatement == null) {
            return false;
        }
        if (declarationStatement.getDeclaredElements().length != 1) {
            return false;
        }
        String name = variable.getName();
        if (name == null) {
            return false;
        }
        PsiType type2 = variable.getType();
        if (!PsiTypesUtil.isDenotableType((PsiType)type2, (PsiElement)variable)) {
            return false;
        }
        this.setText(QuickFixBundle.message("convert.variable.to.field.in.anonymous.class.fix.name", name));
        return true;
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
        if (project == null) {
            VariableAccessFromInnerClassJava10Fix.$$$reportNull$$$0(2);
        }
        if (!FileModificationService.getInstance().preparePsiElementsForWrite(new PsiElement[]{this.myContext})) {
            return;
        }
        if (this.myContext instanceof PsiReferenceExpression && this.myContext.isValid()) {
            PsiReferenceExpression referenceExpression = (PsiReferenceExpression)this.myContext;
            PsiLocalVariable variable = (PsiLocalVariable)ObjectUtils.tryCast((Object)referenceExpression.resolve(), PsiLocalVariable.class);
            if (variable == null) {
                return;
            }
            PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)project);
            PsiExpression initializer = variable.getInitializer();
            String variableText = VariableAccessFromInnerClassJava10Fix.getFieldText(variable, factory, initializer);
            PsiLambdaExpression lambdaExpression = (PsiLambdaExpression)PsiTreeUtil.getParentOfType((PsiElement)this.myContext, PsiLambdaExpression.class);
            if (lambdaExpression == null) {
                return;
            }
            DeclarationInfo declarationInfo = DeclarationInfo.findExistingAnonymousClass((PsiVariable)variable);
            if (declarationInfo != null) {
                VariableAccessFromInnerClassJava10Fix.replaceReferences(variable, factory, declarationInfo.name);
                declarationInfo.replace(variableText);
                variable.delete();
                return;
            }
            JavaCodeStyleManager codeStyleManager = JavaCodeStyleManager.getInstance((Project)project);
            String boxName = codeStyleManager.suggestUniqueVariableName(NAMES[0], (PsiElement)variable, true);
            String boxDeclarationText = "var " + boxName + " = new Object(){" + variableText + "};";
            PsiStatement boxDeclaration = factory.createStatementFromText(boxDeclarationText, (PsiElement)variable);
            VariableAccessFromInnerClassJava10Fix.replaceReferences(variable, factory, boxName);
            if (editor == null) {
                variable.replace((PsiElement)boxDeclaration);
                return;
            }
            PsiStatement statement = (PsiStatement)PsiTreeUtil.getParentOfType((PsiElement)variable, PsiStatement.class);
            if (statement == null) {
                return;
            }
            PsiDeclarationStatement declarationStatement = (PsiDeclarationStatement)statement.replace((PsiElement)boxDeclaration);
            PsiLocalVariable localVariable = (PsiLocalVariable)declarationStatement.getDeclaredElements()[0];
            SmartPointerManager smartPointerManager = SmartPointerManager.getInstance((Project)project);
            SmartPsiElementPointer pointer = smartPointerManager.createSmartPsiElementPointer((PsiElement)localVariable);
            PsiDocumentManager.getInstance((Project)project).doPostponedOperationsAndUnblockDocument(editor.getDocument());
            PsiLocalVariable varToChange = (PsiLocalVariable)pointer.getElement();
            if (varToChange == null) {
                return;
            }
            editor.getCaretModel().moveToOffset(varToChange.getTextOffset());
            editor.getSelectionModel().removeSelection();
            LinkedHashSet suggestions = Arrays.stream(NAMES).map(suggestion -> codeStyleManager.suggestUniqueVariableName(suggestion, (PsiElement)varToChange, var -> var == varToChange)).collect(Collectors.toCollection(() -> new LinkedHashSet()));
            new MemberInplaceRenamer((PsiNamedElement)varToChange, (PsiElement)varToChange, editor).performInplaceRefactoring(suggestions);
        }
    }

    private static void replaceReferences(PsiLocalVariable variable, PsiElementFactory factory, String boxName) {
        List<PsiReferenceExpression> references = VariableAccessFromInnerClassJava10Fix.findReferences(variable);
        PsiExpression expr = factory.createExpressionFromText(boxName + "." + variable.getName(), null);
        for (PsiReferenceExpression reference : references) {
            reference.replace((PsiElement)expr);
        }
    }

    private static String getFieldText(PsiLocalVariable variable, PsiElementFactory factory, PsiExpression initializer) {
        if (initializer != null && variable.getTypeElement().isInferredType() && initializer.getType() != null) {
            PsiLocalVariable copy = (PsiLocalVariable)variable.copy();
            copy.getTypeElement().replace((PsiElement)factory.createTypeElement(initializer.getType()));
            return copy.getText();
        }
        return variable.getText();
    }

    private static List<PsiReferenceExpression> findReferences(final @NotNull PsiLocalVariable variable) {
        PsiElement outerCodeBlock;
        if (variable == null) {
            VariableAccessFromInnerClassJava10Fix.$$$reportNull$$$0(3);
        }
        if ((outerCodeBlock = PsiUtil.getVariableCodeBlock((PsiVariable)variable, null)) == null) {
            return Collections.emptyList();
        }
        SmartList references = new SmartList();
        outerCodeBlock.accept((PsiElementVisitor)new JavaRecursiveElementVisitor((List)references){
            final /* synthetic */ List val$references;
            {
                this.val$references = list;
            }

            public void visitReferenceExpression(PsiReferenceExpression expression2) {
                if (ExpressionUtils.isReferenceTo((PsiExpression)expression2, (PsiVariable)variable)) {
                    this.val$references.add(expression2);
                }
            }
        });
        return references;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/daemon/impl/quickfix/VariableAccessFromInnerClassJava10Fix";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/daemon/impl/quickfix/VariableAccessFromInnerClassJava10Fix";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "findReferences";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class DeclarationInfo {
        final boolean isBefore;
        @NotNull
        final PsiStatement myStatementToReplace;
        @NotNull
        final PsiAnonymousClass myAnonymousClass;
        @NotNull
        final PsiNewExpression myNewExpression;
        @NotNull
        final PsiLocalVariable myVariable;
        @NotNull
        final String name;

        DeclarationInfo(boolean isBefore, @NotNull PsiStatement statementToReplace, @NotNull PsiAnonymousClass anonymousClass, @NotNull PsiNewExpression expression2, @NotNull PsiLocalVariable variable, @NotNull String name) {
            if (statementToReplace == null) {
                DeclarationInfo.$$$reportNull$$$0(0);
            }
            if (anonymousClass == null) {
                DeclarationInfo.$$$reportNull$$$0(1);
            }
            if (expression2 == null) {
                DeclarationInfo.$$$reportNull$$$0(2);
            }
            if (variable == null) {
                DeclarationInfo.$$$reportNull$$$0(3);
            }
            if (name == null) {
                DeclarationInfo.$$$reportNull$$$0(4);
            }
            this.isBefore = isBefore;
            this.myStatementToReplace = statementToReplace;
            this.myAnonymousClass = anonymousClass;
            this.myNewExpression = expression2;
            this.myVariable = variable;
            this.name = name;
        }

        @Nullable
        static DeclarationInfo findExistingAnonymousClass(@NotNull PsiVariable variable) {
            PsiElement varDeclarationStatement;
            if (variable == null) {
                DeclarationInfo.$$$reportNull$$$0(5);
            }
            if ((varDeclarationStatement = RefactoringUtil.getParentStatement((PsiElement)variable, false)) == null) {
                return null;
            }
            PsiStatement nextStatement = (PsiStatement)PsiTreeUtil.getNextSiblingOfType((PsiElement)varDeclarationStatement, PsiStatement.class);
            PsiDeclarationStatement nextDeclarationStatement = (PsiDeclarationStatement)ObjectUtils.tryCast((Object)nextStatement, PsiDeclarationStatement.class);
            DeclarationInfo nextDeclaration = DeclarationInfo.findExistingAnonymousClass(variable, nextDeclarationStatement, true);
            if (nextDeclaration != null) {
                return nextDeclaration;
            }
            PsiDeclarationStatement previousDeclarationStatement = (PsiDeclarationStatement)PsiTreeUtil.getPrevSiblingOfType((PsiElement)varDeclarationStatement, PsiDeclarationStatement.class);
            return DeclarationInfo.findExistingAnonymousClass(variable, previousDeclarationStatement, false);
        }

        void replace(@NotNull String variableText) {
            if (variableText == null) {
                DeclarationInfo.$$$reportNull$$$0(6);
            }
            PsiLocalVariable localVariable = (PsiLocalVariable)this.myVariable.copy();
            PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)localVariable.getProject());
            PsiElement lBrace = this.myAnonymousClass.getLBrace();
            PsiElement rBrace = this.myAnonymousClass.getRBrace();
            if (lBrace == null || rBrace == null) {
                return;
            }
            PsiElement rBracePrev = rBrace.getPrevSibling();
            if (rBracePrev == null) {
                return;
            }
            StringBuilder sb = new StringBuilder();
            for (PsiElement element : this.myAnonymousClass.getChildren()) {
                sb.append(element.getText());
                if ((!this.isBefore || element != lBrace) && (this.isBefore || element != rBracePrev)) continue;
                sb.append(variableText);
            }
            localVariable.setInitializer(factory.createExpressionFromText("new " + sb.toString(), (PsiElement)this.myVariable));
            this.myStatementToReplace.replace((PsiElement)factory.createStatementFromText(localVariable.getText() + ";", (PsiElement)localVariable));
        }

        @Nullable
        private static DeclarationInfo findExistingAnonymousClass(@NotNull PsiVariable variable, @Nullable PsiDeclarationStatement declarationStatement, boolean isBefore) {
            if (variable == null) {
                DeclarationInfo.$$$reportNull$$$0(7);
            }
            if (declarationStatement == null) {
                return null;
            }
            PsiElement[] declaredElements = declarationStatement.getDeclaredElements();
            if (declaredElements.length != 1) {
                return null;
            }
            PsiLocalVariable localVariable = (PsiLocalVariable)ObjectUtils.tryCast((Object)declaredElements[0], PsiLocalVariable.class);
            if (localVariable == null) {
                return null;
            }
            String boxName = localVariable.getName();
            if (boxName == null) {
                return null;
            }
            PsiNewExpression newExpression = (PsiNewExpression)ObjectUtils.tryCast((Object)localVariable.getInitializer(), PsiNewExpression.class);
            if (newExpression == null) {
                return null;
            }
            PsiAnonymousClass anonymousClass = newExpression.getAnonymousClass();
            if (anonymousClass == null) {
                return null;
            }
            String variableName = variable.getName();
            if (variableName == null) {
                return null;
            }
            if (!TypeUtils.isJavaLangObject((PsiType)anonymousClass.getBaseClassType())) {
                return null;
            }
            if (Arrays.stream(anonymousClass.getFields()).map(field -> field.getName()).filter(Objects::nonNull).anyMatch(name -> name.equals(variableName))) {
                return null;
            }
            return new DeclarationInfo(isBefore, (PsiStatement)declarationStatement, anonymousClass, newExpression, localVariable, boxName);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "statementToReplace";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "anonymousClass";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "expression";
                    break;
                }
                case 3: 
                case 5: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "variable";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "variableText";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/codeInsight/daemon/impl/quickfix/VariableAccessFromInnerClassJava10Fix$DeclarationInfo";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 5: 
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[2] = "findExistingAnonymousClass";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[2] = "replace";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

