/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.editorActions;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.ide.PasteProvider;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorModificationUtil;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiRawStringLiteralUtil;
import java.awt.datatransfer.DataFlavor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RawStringLiteralPasteProcessor
implements PasteProvider {
    public void performPaste(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            RawStringLiteralPasteProcessor.$$$reportNull$$$0(0);
        }
        Editor editor = (Editor)CommonDataKeys.EDITOR.getData(dataContext);
        PsiFile file = (PsiFile)CommonDataKeys.PSI_FILE.getData(dataContext);
        if (editor == null || file == null) {
            return;
        }
        String text2 = RawStringLiteralPasteProcessor.getTextInClipboard();
        if (text2 == null) {
            return;
        }
        Document document = editor.getDocument();
        PsiDocumentManager.getInstance((Project)file.getProject()).commitDocument(document);
        int offset = editor.getCaretModel().getOffset();
        PsiElement stringLiteral = RawStringLiteralPasteProcessor.findRawStringLiteralAtCaret(file, offset);
        if (stringLiteral == null) {
            return;
        }
        int leadingTicsSequence = PsiRawStringLiteralUtil.getLeadingTicksSequence((CharSequence)text2);
        int trailingTicsSequence = PsiRawStringLiteralUtil.getTrailingTicksSequence((CharSequence)text2);
        String prefix = "";
        TextRange textRange = stringLiteral.getTextRange();
        if (offset == textRange.getStartOffset() + 1 && leadingTicsSequence > 0) {
            prefix = "\"" + StringUtil.repeat((String)"`", (int)leadingTicsSequence) + "\" + ";
            text2 = text2.substring(leadingTicsSequence);
        }
        String suffix = "";
        if (offset == textRange.getEndOffset() - 1 && trailingTicsSequence > 0) {
            suffix = "+ \"" + StringUtil.repeat((String)"`", (int)trailingTicsSequence) + "\"";
            text2 = text2.substring(0, text2.length() - trailingTicsSequence);
        }
        String literalText = stringLiteral.getText();
        int ticsLength = PsiRawStringLiteralUtil.getLeadingTicksSequence((CharSequence)literalText);
        String quotes = literalText.substring(0, ticsLength);
        String additionalQuotes = PsiRawStringLiteralUtil.getAdditionalTicks((String)text2, (String)quotes);
        RawStringLiteralPasteProcessor.insertAtCaret(StringUtil.convertLineSeparators((String)text2), additionalQuotes, stringLiteral, editor, prefix, suffix);
    }

    public boolean isPastePossible(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            RawStringLiteralPasteProcessor.$$$reportNull$$$0(1);
        }
        Editor editor = (Editor)CommonDataKeys.EDITOR.getData(dataContext);
        PsiFile file = (PsiFile)CommonDataKeys.PSI_FILE.getData(dataContext);
        return editor != null && file != null && RawStringLiteralPasteProcessor.findRawStringLiteralAtCaret(file, editor.getCaretModel().getOffset()) != null && RawStringLiteralPasteProcessor.getTextInClipboard() != null;
    }

    public boolean isPasteEnabled(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            RawStringLiteralPasteProcessor.$$$reportNull$$$0(2);
        }
        return this.isPastePossible(dataContext);
    }

    @Nullable
    private static String getTextInClipboard() {
        return (String)CopyPasteManager.getInstance().getContents(DataFlavor.stringFlavor);
    }

    @Nullable
    private static PsiElement findRawStringLiteralAtCaret(PsiFile file, int offset) {
        PsiElement elementAtSelectionStart = file.findElementAt(offset);
        if (elementAtSelectionStart == null) {
            return null;
        }
        ASTNode node = elementAtSelectionStart.getNode();
        return node != null && node.getElementType() == JavaTokenType.RAW_STRING_LITERAL ? elementAtSelectionStart : null;
    }

    private static void insertAtCaret(String text2, String additionalQuotes, PsiElement element, Editor editor, String prefix, String suffix) {
        Project project = editor.getProject();
        if (project == null) {
            return;
        }
        RangeMarker range = editor.getDocument().createRangeMarker(element.getTextRange());
        PsiDocumentManager documentManager = PsiDocumentManager.getInstance((Project)project);
        PsiFile file = documentManager.getPsiFile(editor.getDocument());
        if (!FileModificationService.getInstance().prepareFileForWrite(file)) {
            return;
        }
        WriteCommandAction.runWriteCommandAction((Project)project, (String)"Raw paste", null, () -> {
            Document document = editor.getDocument();
            documentManager.commitDocument(document);
            EditorModificationUtil.insertStringAtCaret((Editor)editor, (String)text2);
            if (!(additionalQuotes.isEmpty() && prefix.isEmpty() && suffix.isEmpty())) {
                document.insertString(range.getStartOffset(), (CharSequence)(prefix + additionalQuotes));
                document.insertString(range.getEndOffset(), (CharSequence)(additionalQuotes + suffix));
            }
        }, (PsiFile[])new PsiFile[0]);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "dataContext";
        objectArray2[1] = "com/intellij/codeInsight/editorActions/RawStringLiteralPasteProcessor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "performPaste";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "isPastePossible";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "isPasteEnabled";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

