/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.editorActions.smartEnter;

import com.intellij.codeInsight.editorActions.smartEnter.Fixer;
import com.intellij.codeInsight.editorActions.smartEnter.JavaSmartEnterProcessor;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiSwitchStatement;
import com.intellij.util.IncorrectOperationException;

public class SwitchExpressionFixer
implements Fixer {
    @Override
    public void apply(Editor editor, JavaSmartEnterProcessor processor, PsiElement psiElement) throws IncorrectOperationException {
        if (psiElement instanceof PsiSwitchStatement) {
            Document doc = editor.getDocument();
            PsiSwitchStatement switchStatement = (PsiSwitchStatement)psiElement;
            PsiJavaToken rParenth = switchStatement.getRParenth();
            PsiJavaToken lParenth = switchStatement.getLParenth();
            PsiExpression condition2 = switchStatement.getExpression();
            if (condition2 == null) {
                if (lParenth == null || rParenth == null) {
                    int stopOffset = doc.getLineEndOffset(doc.getLineNumber(switchStatement.getTextRange().getStartOffset()));
                    PsiCodeBlock block = switchStatement.getBody();
                    if (block != null) {
                        stopOffset = Math.min(stopOffset, block.getTextRange().getStartOffset());
                    }
                    doc.replaceString(switchStatement.getTextRange().getStartOffset(), stopOffset, (CharSequence)"switch ()");
                } else {
                    processor.registerUnresolvedError(lParenth.getTextRange().getEndOffset());
                }
            } else if (rParenth == null) {
                doc.insertString(condition2.getTextRange().getEndOffset(), (CharSequence)")");
            }
        }
    }
}

