/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.navigation.actions;

import com.intellij.codeInsight.navigation.actions.GotoDeclarationHandlerBase;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiBreakStatement;
import com.intellij.psi.PsiContinueStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiKeyword;
import com.intellij.psi.PsiLabeledStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.tree.IElementType;
import org.jetbrains.annotations.Nullable;

public class GotoBreakContinueHandler
extends GotoDeclarationHandlerBase {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.navigation.actions.GotoBreakContinueHandler");

    @Nullable
    public PsiElement getGotoDeclarationTarget(@Nullable PsiElement elementAt, Editor editor) {
        if (elementAt instanceof PsiKeyword) {
            IElementType type2 = ((PsiKeyword)elementAt).getTokenType();
            if (type2 == JavaTokenType.CONTINUE_KEYWORD) {
                if (elementAt.getParent() instanceof PsiContinueStatement) {
                    return ((PsiContinueStatement)elementAt.getParent()).findContinuedStatement();
                }
            } else if (type2 == JavaTokenType.BREAK_KEYWORD && elementAt.getParent() instanceof PsiBreakStatement) {
                PsiElement nextSibling;
                PsiStatement statement = ((PsiBreakStatement)elementAt.getParent()).findExitedStatement();
                if (statement == null) {
                    return null;
                }
                if (statement.getParent() instanceof PsiLabeledStatement) {
                    statement = (PsiStatement)statement.getParent();
                }
                for (nextSibling = statement.getNextSibling(); !(nextSibling instanceof PsiStatement) && nextSibling != null; nextSibling = nextSibling.getNextSibling()) {
                }
                if (nextSibling != null) {
                    return nextSibling;
                }
                nextSibling = statement.getNextSibling();
                if (nextSibling != null) {
                    return nextSibling;
                }
                return statement.getLastChild();
            }
        } else if (elementAt instanceof PsiIdentifier) {
            PsiElement parent = elementAt.getParent();
            PsiStatement statement = null;
            if (parent instanceof PsiContinueStatement) {
                statement = ((PsiContinueStatement)parent).findContinuedStatement();
            } else if (parent instanceof PsiBreakStatement) {
                statement = ((PsiBreakStatement)parent).findExitedStatement();
            }
            if (statement == null) {
                return null;
            }
            LOG.assertTrue(statement.getParent() instanceof PsiLabeledStatement);
            return ((PsiLabeledStatement)statement.getParent()).getLabelIdentifier();
        }
        return null;
    }
}

