/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.template.macro;

import com.intellij.codeInsight.completion.proc.VariablesProcessor;
import com.intellij.codeInsight.template.ExpressionContext;
import com.intellij.codeInsight.template.PsiElementResult;
import com.intellij.codeInsight.template.PsiTypeResult;
import com.intellij.codeInsight.template.Result;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.ResolveState;
import com.intellij.psi.scope.util.PsiScopesUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.HashSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MacroUtil {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.template.macro.MacroUtil");

    @Nullable
    public static PsiType resultToPsiType(Result result, ExpressionContext context) {
        PsiDeclarationStatement decl;
        if (result instanceof PsiTypeResult) {
            return ((PsiTypeResult)result).getType();
        }
        Project project = context.getProject();
        String text2 = result.toString();
        if (text2 == null) {
            return null;
        }
        PsiManager manager = PsiManager.getInstance((Project)project);
        PsiFile file = PsiDocumentManager.getInstance((Project)project).getPsiFile(context.getEditor().getDocument());
        PsiElement place = file != null ? file.findElementAt(context.getStartOffset()) : null;
        PsiDeclarationStatement psiDeclarationStatement = decl = file != null ? (PsiDeclarationStatement)PsiTreeUtil.getParentOfType((PsiElement)place, PsiDeclarationStatement.class) : null;
        if (decl != null) {
            place = file.findElementAt(decl.getTextOffset() - 1);
        }
        PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)manager.getProject());
        try {
            return factory.createTypeFromText(text2, place);
        }
        catch (IncorrectOperationException e) {
            return null;
        }
    }

    @Nullable
    public static PsiExpression resultToPsiExpression(Result result, ExpressionContext context) {
        PsiElement parentOfParent;
        PsiElement parent;
        PsiElement place;
        PsiElement element;
        if (result instanceof PsiElementResult && (element = ((PsiElementResult)result).getElement()) instanceof PsiExpression) {
            return (PsiExpression)element;
        }
        Project project = context.getProject();
        String text2 = result.toString();
        if (text2 == null) {
            return null;
        }
        PsiManager manager = PsiManager.getInstance((Project)project);
        PsiFile file = PsiDocumentManager.getInstance((Project)project).getPsiFile(context.getEditor().getDocument());
        PsiElement psiElement = place = file != null ? file.findElementAt(context.getStartOffset()) : null;
        if (place != null && (parent = place.getParent()) != null && (parentOfParent = parent.getParent()) instanceof PsiDeclarationStatement) {
            place = file.findElementAt(parentOfParent.getTextOffset() - 1);
        }
        PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)manager.getProject());
        try {
            return factory.createExpressionFromText(text2, place);
        }
        catch (IncorrectOperationException e) {
            return null;
        }
    }

    @NotNull
    private static PsiExpression[] getStandardExpressions(PsiElement place) {
        ArrayList<PsiExpression> array = new ArrayList<PsiExpression>();
        PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)place.getProject());
        try {
            array.add(factory.createExpressionFromText("true", null));
            array.add(factory.createExpressionFromText("false", null));
            boolean innermostClass = true;
            for (PsiElement scope = place; scope != null; scope = scope.getParent()) {
                if (scope instanceof PsiClass) {
                    PsiClass aClass = (PsiClass)scope;
                    String name = aClass.getName();
                    if (innermostClass) {
                        array.add(factory.createExpressionFromText("this", place));
                    } else if (name != null) {
                        array.add(factory.createExpressionFromText(name + ".this", place));
                    }
                    innermostClass = false;
                    if (!aClass.hasModifierProperty("static")) continue;
                } else if (!(scope instanceof PsiMember) || !((PsiMember)scope).hasModifierProperty("static")) {
                    continue;
                }
                break;
            }
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
        }
        PsiExpression[] psiExpressionArray = array.toArray(PsiExpression.EMPTY_ARRAY);
        if (psiExpressionArray == null) {
            MacroUtil.$$$reportNull$$$0(0);
        }
        return psiExpressionArray;
    }

    @NotNull
    public static PsiExpression[] getStandardExpressionsOfType(PsiElement place, PsiType type2) {
        PsiExpression[] expressions2;
        ArrayList<PsiExpression> array = new ArrayList<PsiExpression>();
        for (PsiExpression expr : expressions2 = MacroUtil.getStandardExpressions(place)) {
            PsiType type1 = expr.getType();
            if (type2 != null && (type1 == null || !type2.isAssignableFrom(type1))) continue;
            array.add(expr);
        }
        PsiExpression[] psiExpressionArray = array.toArray(PsiExpression.EMPTY_ARRAY);
        if (psiExpressionArray == null) {
            MacroUtil.$$$reportNull$$$0(1);
        }
        return psiExpressionArray;
    }

    @NotNull
    public static PsiVariable[] getVariablesVisibleAt(final @Nullable PsiElement place, String prefix) {
        if (place == null) {
            PsiVariable[] psiVariableArray = new PsiVariable[]{};
            if (psiVariableArray == null) {
                MacroUtil.$$$reportNull$$$0(2);
            }
            return psiVariableArray;
        }
        final HashSet usedNames = ContainerUtil.newHashSet();
        ArrayList list = new ArrayList();
        VariablesProcessor varproc = new VariablesProcessor(prefix, true, list){

            @Override
            public boolean execute(@NotNull PsiElement pe, @NotNull ResolveState state) {
                if (pe == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (state == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (pe instanceof PsiVariable) {
                    if (!usedNames.add(((PsiVariable)pe).getName())) {
                        return false;
                    }
                    PsiExpression initializer = ((PsiVariable)pe).getInitializer();
                    if (initializer != null && PsiTreeUtil.isAncestor((PsiElement)initializer, (PsiElement)place, (boolean)false)) {
                        return true;
                    }
                }
                return pe instanceof PsiField && !PsiUtil.isAccessible((PsiMember)((PsiField)pe), (PsiElement)place, null) || super.execute(pe, state);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "pe";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "state";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/codeInsight/template/macro/MacroUtil$1";
                objectArray[2] = "execute";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        PsiScopesUtil.treeWalkUp(varproc, place, null);
        PsiVariable[] psiVariableArray = varproc.getResultsAsArray();
        if (psiVariableArray == null) {
            MacroUtil.$$$reportNull$$$0(3);
        }
        return psiVariableArray;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/codeInsight/template/macro/MacroUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getStandardExpressions";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getStandardExpressionsOfType";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getVariablesVisibleAt";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

