/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.codeInspection.AbstractBaseJavaLocalInspectionTool;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiMethodReferenceUtil;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiThisExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.ObjectUtils;
import com.siyeh.ig.callMatcher.CallMatcher;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.VariableAccessUtils;
import java.util.Optional;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CapturingCleanerInspection
extends AbstractBaseJavaLocalInspectionTool {
    private static final CallMatcher CLEANER_REGISTER = CallMatcher.instanceCall("java.lang.ref.Cleaner", "register").parameterCount(2);

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            CapturingCleanerInspection.$$$reportNull$$$0(0);
        }
        if (!PsiUtil.isLanguageLevel9OrHigher((PsiElement)holder.getFile())) {
            PsiElementVisitor psiElementVisitor = PsiElementVisitor.EMPTY_VISITOR;
            if (psiElementVisitor == null) {
                CapturingCleanerInspection.$$$reportNull$$$0(1);
            }
            return psiElementVisitor;
        }
        JavaElementVisitor javaElementVisitor = new JavaElementVisitor(){

            public void visitMethodCallExpression(PsiMethodCallExpression call) {
                String referenceName;
                PsiElement highlightingElement;
                if (!CLEANER_REGISTER.test(call)) {
                    return;
                }
                PsiExpression[] expressions2 = call.getArgumentList().getExpressions();
                PsiExpression trackedObject = ExpressionUtils.resolveExpression(expressions2[0]);
                PsiExpression runnableExpression = ExpressionUtils.resolveExpression(expressions2[1]);
                if (trackedObject == null || runnableExpression == null) {
                    return;
                }
                if (trackedObject instanceof PsiThisExpression) {
                    PsiClassType classType = (PsiClassType)ObjectUtils.tryCast((Object)trackedObject.getType(), PsiClassType.class);
                    if (classType == null) {
                        return;
                    }
                    PsiClass trackedClass = classType.resolve();
                    if (trackedClass == null) {
                        return;
                    }
                    PsiElement elementCapturingThis = this.getElementCapturingThis(runnableExpression, trackedClass);
                    if (elementCapturingThis == null) {
                        return;
                    }
                    highlightingElement = elementCapturingThis;
                    referenceName = "this";
                } else if (trackedObject instanceof PsiReferenceExpression) {
                    PsiVariable variable = (PsiVariable)ObjectUtils.tryCast((Object)((PsiReferenceExpression)trackedObject).resolve(), PsiVariable.class);
                    if (variable == null) {
                        return;
                    }
                    if (variable instanceof PsiField) {
                        return;
                    }
                    if (!VariableAccessUtils.variableIsUsed(variable, (PsiElement)runnableExpression)) {
                        return;
                    }
                    Optional referenceExpression = StreamEx.ofTree((Object)runnableExpression, el -> StreamEx.of((Object[])el.getChildren())).findAny(el -> el instanceof PsiReferenceExpression && ((PsiReferenceExpression)el).isReferenceTo((PsiElement)variable));
                    if (!referenceExpression.isPresent()) {
                        return;
                    }
                    String variableName = variable.getName();
                    if (variableName == null) {
                        return;
                    }
                    highlightingElement = (PsiElement)referenceExpression.get();
                    referenceName = variableName;
                } else {
                    return;
                }
                holder.registerProblem(highlightingElement, InspectionsBundle.message((String)"inspection.capturing.cleaner", (Object[])new Object[]{referenceName}), new LocalQuickFix[0]);
            }

            @Nullable
            private PsiElement getElementCapturingThis(@NotNull PsiExpression runnableExpr, @NotNull PsiClass trackedClass) {
                if (runnableExpr == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (trackedClass == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (runnableExpr instanceof PsiMethodReferenceExpression) {
                    PsiMethodReferenceExpression methodReference = (PsiMethodReferenceExpression)runnableExpr;
                    if (PsiMethodReferenceUtil.isStaticallyReferenced((PsiMethodReferenceExpression)methodReference)) {
                        return null;
                    }
                    PsiElement qualifier = methodReference.getQualifier();
                    if (qualifier instanceof PsiThisExpression) {
                        PsiClass thisClass = PsiUtil.resolveClassInType((PsiType)((PsiThisExpression)qualifier).getType());
                        if (thisClass != trackedClass) {
                            return null;
                        }
                        return qualifier;
                    }
                    return null;
                }
                if (runnableExpr instanceof PsiLambdaExpression) {
                    PsiLambdaExpression lambda2 = (PsiLambdaExpression)runnableExpr;
                    if (!lambda2.getParameterList().isEmpty()) {
                        return null;
                    }
                    PsiElement lambdaBody = lambda2.getBody();
                    if (lambdaBody == null) {
                        return null;
                    }
                    return CapturingCleanerInspection.getLambdaElementCapturingThis(lambdaBody, trackedClass).orElse(null);
                }
                if (runnableExpr instanceof PsiNewExpression) {
                    PsiNewExpression newExpression = (PsiNewExpression)runnableExpr;
                    if (newExpression.getAnonymousClass() != null) {
                        return newExpression;
                    }
                    PsiJavaCodeReferenceElement classReference2 = newExpression.getClassReference();
                    if (classReference2 == null) {
                        return null;
                    }
                    PsiClass aClass = (PsiClass)ObjectUtils.tryCast((Object)classReference2.resolve(), PsiClass.class);
                    if (aClass == null) {
                        return null;
                    }
                    if (aClass.getContainingClass() != trackedClass) {
                        return null;
                    }
                    if (aClass.hasModifierProperty("static")) {
                        return null;
                    }
                    return classReference2;
                }
                return null;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "runnableExpr";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "trackedClass";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/codeInspection/CapturingCleanerInspection$1";
                objectArray[2] = "getElementCapturingThis";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        if (javaElementVisitor == null) {
            CapturingCleanerInspection.$$$reportNull$$$0(2);
        }
        return javaElementVisitor;
    }

    private static Optional<PsiElement> getLambdaElementCapturingThis(@NotNull PsiElement lambdaBody, @NotNull PsiClass containingClass) {
        if (lambdaBody == null) {
            CapturingCleanerInspection.$$$reportNull$$$0(3);
        }
        if (containingClass == null) {
            CapturingCleanerInspection.$$$reportNull$$$0(4);
        }
        return StreamEx.ofTree((Object)lambdaBody, el -> StreamEx.of((Object[])el.getChildren())).findAny(element -> {
            if (containingClass == null) {
                CapturingCleanerInspection.$$$reportNull$$$0(7);
            }
            return CapturingCleanerInspection.isThisCapturingElement(containingClass, element);
        });
    }

    private static boolean isThisCapturingElement(@NotNull PsiClass containingClass, PsiElement element) {
        if (containingClass == null) {
            CapturingCleanerInspection.$$$reportNull$$$0(5);
        }
        if (element instanceof PsiThisExpression) {
            return PsiUtil.resolveClassInType((PsiType)((PsiThisExpression)element).getType()) == containingClass;
        }
        if (element instanceof PsiReferenceExpression) {
            PsiReferenceExpression qualifierReference = (PsiReferenceExpression)ObjectUtils.tryCast((Object)((PsiReferenceExpression)element).getQualifierExpression(), PsiReferenceExpression.class);
            if (qualifierReference != null) {
                return false;
            }
            PsiMember member = (PsiMember)ObjectUtils.tryCast((Object)((PsiReferenceExpression)element).resolve(), PsiMember.class);
            return CapturingCleanerInspection.memberBringsThisRef(containingClass, member);
        }
        return false;
    }

    @Contract(value="_, null -> false")
    private static boolean memberBringsThisRef(@NotNull PsiClass containingClass, PsiMember member) {
        if (containingClass == null) {
            CapturingCleanerInspection.$$$reportNull$$$0(6);
        }
        if (member == null) {
            return false;
        }
        PsiClass memberContainingClass = member.getContainingClass();
        if (memberContainingClass == null) {
            return false;
        }
        if (!InheritanceUtil.isInheritorOrSelf((PsiClass)containingClass, (PsiClass)memberContainingClass, (boolean)true) && !CapturingCleanerInspection.isInnerClassOf(containingClass, memberContainingClass)) {
            return false;
        }
        return !member.hasModifierProperty("static");
    }

    @Contract(value="_, null -> false")
    private static boolean isInnerClassOf(@Nullable PsiClass inner, @Nullable PsiClass outer) {
        if (inner == null || inner.hasModifierProperty("static")) {
            return false;
        }
        return PsiTreeUtil.isAncestor((PsiElement)outer, (PsiElement)inner, (boolean)false);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/CapturingCleanerInspection";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lambdaBody";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "containingClass";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/CapturingCleanerInspection";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getLambdaElementCapturingThis";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isThisCapturingElement";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "memberBringsThisRef";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getLambdaElementCapturingThis$1";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

