/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.codeInspection.AbstractBaseJavaLocalInspectionTool;
import com.intellij.codeInspection.LambdaCanBeMethodReferenceInspection;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.codeStyle.SuggestedNameInfo;
import com.intellij.psi.codeStyle.VariableKind;
import com.intellij.psi.impl.PsiDiamondTypeUtil;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.siyeh.ig.psiutils.CommentTracker;
import com.siyeh.ig.psiutils.ControlFlowUtils;
import com.siyeh.ig.psiutils.EquivalenceChecker;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.MethodCallUtils;
import com.siyeh.ig.psiutils.VariableAccessUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ComparatorCombinatorsInspection
extends AbstractBaseJavaLocalInspectionTool {
    private static final Logger LOG = Logger.getInstance(ComparatorCombinatorsInspection.class);

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            ComparatorCombinatorsInspection.$$$reportNull$$$0(0);
        }
        if (!PsiUtil.isLanguageLevel8OrHigher((PsiElement)holder.getFile())) {
            PsiElementVisitor psiElementVisitor = PsiElementVisitor.EMPTY_VISITOR;
            if (psiElementVisitor == null) {
                ComparatorCombinatorsInspection.$$$reportNull$$$0(1);
            }
            return psiElementVisitor;
        }
        JavaElementVisitor javaElementVisitor = new JavaElementVisitor(){

            public void visitLambdaExpression(PsiLambdaExpression lambda2) {
                super.visitLambdaExpression(lambda2);
                PsiType type2 = lambda2.getFunctionalInterfaceType();
                PsiParameter[] parameters2 = lambda2.getParameterList().getParameters();
                if (parameters2.length != 2 || !(type2 instanceof PsiClassType) || !((PsiClassType)type2).rawType().equalsToText("java.util.Comparator")) {
                    return;
                }
                String replacementText = ComparatorCombinatorsInspection.generateSimpleCombinator(lambda2, parameters2[0], parameters2[1]);
                if (replacementText != null) {
                    if (!LambdaUtil.isSafeLambdaReplacement((PsiLambdaExpression)lambda2, (String)replacementText)) {
                        return;
                    }
                    String qualifiedName = Objects.requireNonNull(StringUtil.substringBefore((String)replacementText, (String)"("));
                    String methodName = StringUtil.getShortName((String)qualifiedName);
                    holder.registerProblem((PsiElement)lambda2, "Can be replaced with Comparator." + methodName, ProblemHighlightType.LIKE_UNUSED_SYMBOL, new LocalQuickFix[]{new ReplaceWithComparatorFix("Comparator." + methodName)});
                    return;
                }
                if (lambda2.getBody() instanceof PsiCodeBlock) {
                    PsiStatement[] statements = ((PsiCodeBlock)lambda2.getBody()).getStatements();
                    List blocks = ComparatorCombinatorsInspection.extractComparisonChain(statements, (PsiVariable)parameters2[0], (PsiVariable)parameters2[1]);
                    if (blocks == null) {
                        return;
                    }
                    String chainCombinator = ComparatorCombinatorsInspection.generateChainCombinator(blocks, (PsiVariable)parameters2[0], (PsiVariable)parameters2[1]);
                    if (chainCombinator == null) {
                        return;
                    }
                    if (!LambdaUtil.isSafeLambdaReplacement((PsiLambdaExpression)lambda2, (String)chainCombinator)) {
                        return;
                    }
                    holder.registerProblem((PsiElement)lambda2, "Can be replaced with Comparator chain", ProblemHighlightType.LIKE_UNUSED_SYMBOL, new LocalQuickFix[]{new ReplaceWithComparatorFix("Comparator chain")});
                }
            }
        };
        if (javaElementVisitor == null) {
            ComparatorCombinatorsInspection.$$$reportNull$$$0(2);
        }
        return javaElementVisitor;
    }

    @Nullable(value="when failed to extract")
    private static List<ComparisonBlock> extractComparisonChain(@NotNull PsiStatement[] statements, @NotNull PsiVariable first, @NotNull PsiVariable second) {
        if (statements == null) {
            ComparatorCombinatorsInspection.$$$reportNull$$$0(3);
        }
        if (first == null) {
            ComparatorCombinatorsInspection.$$$reportNull$$$0(4);
        }
        if (second == null) {
            ComparatorCombinatorsInspection.$$$reportNull$$$0(5);
        }
        if (statements.length == 0) {
            return null;
        }
        ComparisonBlock firstBlock = ComparisonBlock.extractBlock(statements[0], first, second, null);
        if (firstBlock == null) {
            return null;
        }
        ArrayList<ComparisonBlock> blocks = new ArrayList<ComparisonBlock>();
        blocks.add(firstBlock);
        PsiVariable lastResult = firstBlock.getResult();
        int index = 1;
        while (index < statements.length - 1) {
            ComparisonBlock block;
            PsiStatement current = statements[index];
            if (ComparatorCombinatorsInspection.isNotZeroCheck(current, lastResult)) {
                if (index + 1 >= statements.length) {
                    return null;
                }
                PsiStatement next = statements[index + 1];
                block = ComparisonBlock.extractBlock(next, first, second, lastResult);
                if (block == null) {
                    return null;
                }
                blocks.add(block);
                index += 2;
                continue;
            }
            PsiStatement nextComparisonStmt = ComparatorCombinatorsInspection.extractZeroCheckedWay(current, lastResult);
            if (nextComparisonStmt != null) {
                block = ComparisonBlock.extractBlock(nextComparisonStmt, first, second, lastResult);
                if (block == null) {
                    return null;
                }
                blocks.add(block);
                if (block.getResult() != lastResult) {
                    lastResult = block.getResult();
                }
                ++index;
                continue;
            }
            return null;
        }
        PsiStatement lastStmt = statements[statements.length - 1];
        if (lastStmt instanceof PsiReturnStatement) {
            PsiExpression returnExpr = ((PsiReturnStatement)lastStmt).getReturnValue();
            if (returnExpr == null) {
                return null;
            }
            if (ExpressionUtils.isReferenceTo(returnExpr, lastResult)) {
                return blocks;
            }
            ComparisonBlock lastBlock = ComparatorCombinatorsInspection.extractTernaryComparison(first, second, lastResult, returnExpr);
            if (lastBlock == null) {
                return null;
            }
            blocks.add(lastBlock);
            return blocks;
        }
        return null;
    }

    @Nullable
    private static ComparisonBlock extractTernaryComparison(@NotNull PsiVariable first, @NotNull PsiVariable second, PsiVariable lastResult, PsiExpression returnExpr) {
        PsiConditionalExpression ternary;
        if (first == null) {
            ComparatorCombinatorsInspection.$$$reportNull$$$0(6);
        }
        if (second == null) {
            ComparatorCombinatorsInspection.$$$reportNull$$$0(7);
        }
        if ((ternary = (PsiConditionalExpression)ObjectUtils.tryCast((Object)returnExpr, PsiConditionalExpression.class)) == null) {
            return null;
        }
        PsiExpression elseExpression2 = ternary.getElseExpression();
        PsiExpression thenExpression2 = ternary.getThenExpression();
        if (elseExpression2 == null || thenExpression2 == null) {
            return null;
        }
        PsiBinaryExpression binOp = (PsiBinaryExpression)ObjectUtils.tryCast((Object)ternary.getCondition(), PsiBinaryExpression.class);
        if (binOp == null) {
            return null;
        }
        PsiExpression finalResult = ExpressionUtils.getValueComparedWithZero(binOp);
        boolean inverted = false;
        if (finalResult == null) {
            finalResult = ExpressionUtils.getValueComparedWithZero(binOp, JavaTokenType.NE);
            inverted = true;
        }
        if (!ExpressionUtils.isReferenceTo(finalResult, lastResult)) {
            return null;
        }
        if (!ExpressionUtils.isReferenceTo(inverted ? thenExpression2 : elseExpression2, lastResult)) {
            return null;
        }
        PsiMethodCallExpression lastComparison = (PsiMethodCallExpression)ObjectUtils.tryCast((Object)(inverted ? elseExpression2 : thenExpression2), PsiMethodCallExpression.class);
        ComparisonBlock lastBlock = ComparisonBlock.extractBlock((PsiExpression)lastComparison, first, second, lastResult);
        if (lastBlock == null) {
            return null;
        }
        return lastBlock;
    }

    @Nullable
    private static PsiStatement extractZeroCheckedWay(@Nullable PsiStatement statement, @NotNull PsiVariable last) {
        PsiIfStatement ifStatement;
        if (last == null) {
            ComparatorCombinatorsInspection.$$$reportNull$$$0(8);
        }
        if ((ifStatement = (PsiIfStatement)ObjectUtils.tryCast((Object)statement, PsiIfStatement.class)) == null || ifStatement.getElseBranch() != null) {
            return null;
        }
        PsiBinaryExpression binOp = (PsiBinaryExpression)ObjectUtils.tryCast((Object)ifStatement.getCondition(), PsiBinaryExpression.class);
        if (binOp == null) {
            return null;
        }
        PsiExpression maybeResult = ExpressionUtils.getValueComparedWithZero(binOp);
        if (!ExpressionUtils.isReferenceTo(maybeResult, last)) {
            return null;
        }
        return ControlFlowUtils.stripBraces(ifStatement.getThenBranch());
    }

    private static boolean isNotZeroCheck(@NotNull PsiStatement statement, @NotNull PsiVariable last) {
        PsiIfStatement ifStatement;
        if (statement == null) {
            ComparatorCombinatorsInspection.$$$reportNull$$$0(9);
        }
        if (last == null) {
            ComparatorCombinatorsInspection.$$$reportNull$$$0(10);
        }
        if ((ifStatement = (PsiIfStatement)ObjectUtils.tryCast((Object)statement, PsiIfStatement.class)) == null || ifStatement.getElseBranch() != null) {
            return false;
        }
        PsiBinaryExpression binaryExpression = (PsiBinaryExpression)ObjectUtils.tryCast((Object)ifStatement.getCondition(), PsiBinaryExpression.class);
        if (binaryExpression == null) {
            return false;
        }
        if (!ExpressionUtils.isReferenceTo(ExpressionUtils.getValueComparedWithZero(binaryExpression, JavaTokenType.NE), last)) {
            return false;
        }
        PsiStatement thenStmt = ControlFlowUtils.stripBraces(ifStatement.getThenBranch());
        if (!(thenStmt instanceof PsiReturnStatement)) {
            return false;
        }
        return ExpressionUtils.isReferenceTo(((PsiReturnStatement)thenStmt).getReturnValue(), last);
    }

    @NotNull
    private static String generateComparison(@NotNull String methodName, @Nullable PsiType type2, @NotNull String varName, @NotNull PsiExpression expression2, @NotNull PsiVariable exprVariable) {
        if (methodName == null) {
            ComparatorCombinatorsInspection.$$$reportNull$$$0(11);
        }
        if (varName == null) {
            ComparatorCombinatorsInspection.$$$reportNull$$$0(12);
        }
        if (expression2 == null) {
            ComparatorCombinatorsInspection.$$$reportNull$$$0(13);
        }
        if (exprVariable == null) {
            ComparatorCombinatorsInspection.$$$reportNull$$$0(14);
        }
        String lambdaExpr = ComparatorCombinatorsInspection.getExpressionReplacingReferences(expression2, varName, exprVariable);
        String parameter2 = type2 == null ? varName : "(" + type2.getCanonicalText() + " " + varName + ")";
        String string = methodName + "(" + parameter2 + "->" + lambdaExpr + ")";
        if (string == null) {
            ComparatorCombinatorsInspection.$$$reportNull$$$0(15);
        }
        return string;
    }

    @Nullable
    private static String generateSimpleCombinator(PsiLambdaExpression lambda2, PsiParameter leftVar, PsiParameter rightVar) {
        String text2;
        PsiExpression left;
        PsiExpression body2 = PsiUtil.skipParenthesizedExprDown((PsiExpression)LambdaUtil.extractSingleExpressionFromBody((PsiElement)lambda2.getBody()));
        String methodName = null;
        if (body2 instanceof PsiMethodCallExpression) {
            PsiMethodCallExpression methodCall = (PsiMethodCallExpression)body2;
            if (MethodCallUtils.isCompareToCall(methodCall)) {
                left = methodCall.getMethodExpression().getQualifierExpression();
                PsiExpression right = (PsiExpression)ArrayUtil.getFirstElement((Object[])methodCall.getArgumentList().getExpressions());
                if (ExpressionUtils.isReferenceTo(left, (PsiVariable)leftVar) && ExpressionUtils.isReferenceTo(right, (PsiVariable)rightVar)) {
                    methodName = "naturalOrder";
                } else if (ExpressionUtils.isReferenceTo(right, (PsiVariable)leftVar) && ExpressionUtils.isReferenceTo(left, (PsiVariable)rightVar)) {
                    methodName = "reverseOrder";
                } else if (ComparatorCombinatorsInspection.areEquivalent((PsiVariable)leftVar, left, (PsiVariable)rightVar, right)) {
                    methodName = "comparing";
                }
            } else {
                PrimitiveComparison comparison = PrimitiveComparison.from(methodCall);
                if (comparison == null) {
                    return null;
                }
                PsiExpression[] args = methodCall.getArgumentList().getExpressions();
                if (!ComparatorCombinatorsInspection.areEquivalent((PsiVariable)leftVar, args[0], (PsiVariable)rightVar, args[1])) {
                    return null;
                }
                methodName = comparison.getMethodName();
                left = comparison.getKeyExtractor();
            }
        } else if (body2 instanceof PsiBinaryExpression) {
            PsiBinaryExpression binOp = (PsiBinaryExpression)body2;
            if (!binOp.getOperationTokenType().equals(JavaTokenType.MINUS)) {
                return null;
            }
            left = binOp.getLOperand();
            PsiType type2 = left.getType();
            if (type2 == null) {
                return null;
            }
            if (ComparatorCombinatorsInspection.areEquivalent((PsiVariable)leftVar, left, (PsiVariable)rightVar, binOp.getROperand())) {
                methodName = ComparatorCombinatorsInspection.getComparingMethodName(type2.getCanonicalText());
            }
        } else {
            return null;
        }
        if (methodName == null) {
            return null;
        }
        if (!methodName.startsWith("comparing")) {
            text2 = "java.util.Comparator." + methodName + "()";
        } else {
            String parameterName = leftVar.getName();
            PsiTypeElement typeElement = leftVar.getTypeElement();
            String parameterDeclaration = typeElement == null ? parameterName : "(" + typeElement.getText() + " " + parameterName + ")";
            text2 = "java.util.Comparator." + methodName + "(" + parameterDeclaration + " -> " + left.getText() + ")";
        }
        return text2;
    }

    @Nullable
    private static String generateChainCombinator(@NotNull List<ComparisonBlock> blocks, @NotNull PsiVariable firstVar, @NotNull PsiVariable secondVar) {
        if (blocks == null) {
            ComparatorCombinatorsInspection.$$$reportNull$$$0(16);
        }
        if (firstVar == null) {
            ComparatorCombinatorsInspection.$$$reportNull$$$0(17);
        }
        if (secondVar == null) {
            ComparatorCombinatorsInspection.$$$reportNull$$$0(18);
        }
        if (blocks.size() < 2) {
            return null;
        }
        ComparisonBlock first = blocks.get(0);
        StringBuilder builder = new StringBuilder();
        PsiType type2 = secondVar.getType();
        String name = ComparatorCombinatorsInspection.suggestVarName(firstVar);
        if (name == null) {
            return null;
        }
        PsiExpression firstKey = first.getKey();
        String firstMethodName = ComparatorCombinatorsInspection.getComparingMethodName(firstKey.getType(), true);
        if (firstMethodName == null) {
            return null;
        }
        builder.append("java.util.Comparator").append(".").append(ComparatorCombinatorsInspection.generateComparison(firstMethodName, type2, name, firstKey, secondVar));
        for (int i = 1; i < blocks.size(); ++i) {
            ComparisonBlock block = blocks.get(i);
            PsiExpression blockKey = block.getKey();
            String comparatorMethodName = ComparatorCombinatorsInspection.getComparingMethodName(blockKey.getType(), false);
            if (comparatorMethodName == null) {
                return null;
            }
            builder.append(".").append(ComparatorCombinatorsInspection.generateComparison(comparatorMethodName, null, name, blockKey, secondVar));
        }
        return builder.toString();
    }

    @Contract(value="null, _ -> null")
    @Nullable
    private static String getComparingMethodName(@Nullable PsiType exprType, boolean first) {
        if (exprType == null) {
            return null;
        }
        String name = ComparatorCombinatorsInspection.getComparingMethodName(exprType.getCanonicalText(), first);
        if (name != null) {
            return name;
        }
        if (InheritanceUtil.isInheritor((PsiType)exprType, (String)"java.lang.Comparable")) {
            return first ? "comparing" : "thenComparing";
        }
        return null;
    }

    @Nullable
    private static String suggestVarName(@NotNull PsiVariable variable) {
        String[] names;
        if (variable == null) {
            ComparatorCombinatorsInspection.$$$reportNull$$$0(19);
        }
        String name = variable.getName();
        JavaCodeStyleManager codeStyleManager = JavaCodeStyleManager.getInstance((Project)variable.getProject());
        SuggestedNameInfo nameCandidate = null;
        if (name != null) {
            if (name.length() > 1 && name.endsWith("1")) {
                nameCandidate = codeStyleManager.suggestVariableName(VariableKind.PARAMETER, name.substring(0, name.length() - 1), null, variable.getType(), true);
            } else if (name.equals("first")) {
                nameCandidate = codeStyleManager.suggestVariableName(VariableKind.PARAMETER, null, null, variable.getType(), true);
            }
        }
        if (nameCandidate != null && (names = codeStyleManager.suggestUniqueVariableName(nameCandidate, (PsiElement)variable, (boolean)true).names).length > 0) {
            return names[0];
        }
        return name;
    }

    private static String getExpressionReplacingReferences(@NotNull PsiExpression expression2, @NotNull String varName, @NotNull PsiVariable exprVariable) {
        if (expression2 == null) {
            ComparatorCombinatorsInspection.$$$reportNull$$$0(20);
        }
        if (varName == null) {
            ComparatorCombinatorsInspection.$$$reportNull$$$0(21);
        }
        if (exprVariable == null) {
            ComparatorCombinatorsInspection.$$$reportNull$$$0(22);
        }
        PsiExpression copy = (PsiExpression)expression2.copy();
        ReferencesSearch.search((PsiElement)exprVariable, (SearchScope)new LocalSearchScope((PsiElement)copy)).forEach(reference -> {
            PsiReferenceExpression ref;
            if (varName == null) {
                ComparatorCombinatorsInspection.$$$reportNull$$$0(23);
            }
            if ((ref = (PsiReferenceExpression)ObjectUtils.tryCast((Object)reference.getElement(), PsiReferenceExpression.class)) == null) {
                return;
            }
            ExpressionUtils.bindReferenceTo(ref, varName);
        });
        return copy.getText();
    }

    @Contract(value="null -> null", pure=true)
    @Nullable
    private static String getComparingMethodName(String type2) {
        return ComparatorCombinatorsInspection.getComparingMethodName(type2, true);
    }

    @Contract(value="null, _ -> null", pure=true)
    @Nullable
    private static String getComparingMethodName(String type2, boolean first) {
        if (type2 == null) {
            return null;
        }
        switch (PsiTypesUtil.unboxIfPossible((String)type2)) {
            case "int": 
            case "short": 
            case "byte": 
            case "char": {
                return first ? "comparingInt" : "thenComparingInt";
            }
            case "long": {
                return first ? "comparingLong" : "thenComparingLong";
            }
            case "double": {
                return first ? "comparingDouble" : "thenComparingDouble";
            }
        }
        return null;
    }

    @Contract(value="_, null, _, _ -> false; _, !null, _, null -> false")
    private static boolean areEquivalent(PsiVariable leftVar, @Nullable PsiExpression left, PsiVariable rightVar, @Nullable PsiExpression right) {
        if (left == null || right == null) {
            return false;
        }
        if (VariableAccessUtils.variableIsUsed(rightVar, (PsiElement)left) || VariableAccessUtils.variableIsUsed(leftVar, (PsiElement)right)) {
            return false;
        }
        PsiExpression copy = (PsiExpression)right.copy();
        PsiElement[] rightRefs = PsiTreeUtil.collectElements((PsiElement)copy, e -> e instanceof PsiReferenceExpression && ((PsiReferenceExpression)e).resolve() == rightVar);
        PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)left.getProject());
        String paramName = leftVar.getName();
        if (paramName == null) {
            return false;
        }
        for (PsiElement ref : rightRefs) {
            PsiElement nameElement = ((PsiReferenceExpression)ref).getReferenceNameElement();
            LOG.assertTrue(nameElement != null);
            nameElement.replace((PsiElement)factory.createIdentifier(paramName));
        }
        return EquivalenceChecker.getCanonicalPsiEquivalence().expressionsAreEquivalent(left, copy);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 15: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 15: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: 
            case 2: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/ComparatorCombinatorsInspection";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statements";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "first";
                break;
            }
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "second";
                break;
            }
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "last";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statement";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodName";
                break;
            }
            case 12: 
            case 21: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "varName";
                break;
            }
            case 13: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 14: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "exprVariable";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "blocks";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "firstVar";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "secondVar";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/ComparatorCombinatorsInspection";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "generateComparison";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 1: 
            case 2: 
            case 15: {
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "extractComparisonChain";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "extractTernaryComparison";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "extractZeroCheckedWay";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "isNotZeroCheck";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "generateComparison";
                break;
            }
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "generateChainCombinator";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "suggestVarName";
                break;
            }
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getExpressionReplacingReferences";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getExpressionReplacingReferences$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 15: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static class ReplaceWithComparatorFix
    implements LocalQuickFix {
        private final String myMessage;

        ReplaceWithComparatorFix(String message2) {
            this.myMessage = message2;
        }

        @Nls
        @NotNull
        public String getName() {
            String string = "Replace with " + this.myMessage;
            if (string == null) {
                ReplaceWithComparatorFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Nls
        @NotNull
        public String getFamilyName() {
            if ("Simplify comparator using Comparator static methods" == null) {
                ReplaceWithComparatorFix.$$$reportNull$$$0(1);
            }
            return "Simplify comparator using Comparator static methods";
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            PsiStatement[] statements;
            PsiElement element;
            if (project == null) {
                ReplaceWithComparatorFix.$$$reportNull$$$0(2);
            }
            if (descriptor == null) {
                ReplaceWithComparatorFix.$$$reportNull$$$0(3);
            }
            if (!((element = descriptor.getStartElement()) instanceof PsiLambdaExpression)) {
                return;
            }
            PsiLambdaExpression lambda2 = (PsiLambdaExpression)element;
            PsiParameter[] parameters2 = lambda2.getParameterList().getParameters();
            if (parameters2.length != 2) {
                return;
            }
            if (lambda2.getBody() instanceof PsiCodeBlock && (statements = ((PsiCodeBlock)lambda2.getBody()).getStatements()).length > 1) {
                List chain = ComparatorCombinatorsInspection.extractComparisonChain(statements, (PsiVariable)parameters2[0], (PsiVariable)parameters2[1]);
                if (chain == null) {
                    return;
                }
                String code = ComparatorCombinatorsInspection.generateChainCombinator(chain, (PsiVariable)parameters2[0], (PsiVariable)parameters2[1]);
                if (code == null) {
                    return;
                }
                PsiElement result = new CommentTracker().replaceAndRestoreComments((PsiElement)lambda2, code);
                PsiDiamondTypeUtil.removeRedundantTypeArguments(result);
                LambdaCanBeMethodReferenceInspection.replaceAllLambdasWithMethodReferences(result);
                CodeStyleManager.getInstance((Project)project).reformat(JavaCodeStyleManager.getInstance((Project)project).shortenClassReferences(result));
                return;
            }
            String text2 = ComparatorCombinatorsInspection.generateSimpleCombinator(lambda2, parameters2[0], parameters2[1]);
            if (text2 == null) {
                return;
            }
            PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)project);
            PsiExpression replacement = factory.createExpressionFromText(text2, element);
            PsiMethodCallExpression result = (PsiMethodCallExpression)lambda2.replace((PsiElement)replacement);
            ReplaceWithComparatorFix.normalizeLambda((PsiExpression)ArrayUtil.getFirstElement((Object[])result.getArgumentList().getExpressions()), factory);
            CodeStyleManager.getInstance((Project)project).reformat(JavaCodeStyleManager.getInstance((Project)project).shortenClassReferences((PsiElement)result));
        }

        private static void normalizeLambda(PsiExpression expression2, PsiElementFactory factory) {
            PsiParameter parameter2;
            String name;
            if (!(expression2 instanceof PsiLambdaExpression)) {
                return;
            }
            PsiLambdaExpression lambda2 = (PsiLambdaExpression)expression2;
            PsiParameter[] parameters2 = lambda2.getParameterList().getParameters();
            PsiElement body2 = lambda2.getBody();
            if (body2 == null) {
                return;
            }
            if (LambdaCanBeMethodReferenceInspection.replaceLambdaWithMethodReference(lambda2) == lambda2 && (name = ComparatorCombinatorsInspection.suggestVarName((PsiVariable)(parameter2 = parameters2[0]))) != null) {
                Collection references = PsiTreeUtil.collectElementsOfType((PsiElement)body2, (Class[])new Class[]{PsiReferenceExpression.class});
                ((StreamEx)StreamEx.of((Collection)references).filter(ref -> ref.isReferenceTo((PsiElement)parameter2))).map(PsiJavaCodeReferenceElement::getReferenceNameElement).nonNull().forEach(nameElement -> nameElement.replace((PsiElement)factory.createIdentifier(name)));
                parameter2.setName(name);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 2: 
                case 3: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 2: 
                case 3: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInspection/ComparatorCombinatorsInspection$ReplaceWithComparatorFix";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInspection/ComparatorCombinatorsInspection$ReplaceWithComparatorFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 2: 
                case 3: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class PrimitiveComparison {
        @NotNull
        private final PsiExpression myKeyExtractor;
        @NotNull
        private final String myMethodName;

        private PrimitiveComparison(@NotNull PsiExpression extractor, @NotNull String name) {
            if (extractor == null) {
                PrimitiveComparison.$$$reportNull$$$0(0);
            }
            if (name == null) {
                PrimitiveComparison.$$$reportNull$$$0(1);
            }
            this.myKeyExtractor = extractor;
            this.myMethodName = name;
        }

        @NotNull
        public PsiExpression getKeyExtractor() {
            PsiExpression psiExpression = this.myKeyExtractor;
            if (psiExpression == null) {
                PrimitiveComparison.$$$reportNull$$$0(2);
            }
            return psiExpression;
        }

        @NotNull
        public String getMethodName() {
            String string = this.myMethodName;
            if (string == null) {
                PrimitiveComparison.$$$reportNull$$$0(3);
            }
            return string;
        }

        @Nullable
        private static PrimitiveComparison from(PsiMethodCallExpression methodCall) {
            String className;
            PsiClass containingClass;
            PsiMethod method = methodCall.resolveMethod();
            if (method != null && method.getName().equals("compare") && (containingClass = method.getContainingClass()) != null && (className = containingClass.getQualifiedName()) != null) {
                PsiExpression[] args = methodCall.getArgumentList().getExpressions();
                if (args.length != 2) {
                    return null;
                }
                PsiExpression keyExtractor = args[0];
                String methodName = ComparatorCombinatorsInspection.getComparingMethodName(className);
                if (methodName == null) {
                    return null;
                }
                return new PrimitiveComparison(keyExtractor, methodName);
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "extractor";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInspection/ComparatorCombinatorsInspection$PrimitiveComparison";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInspection/ComparatorCombinatorsInspection$PrimitiveComparison";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getKeyExtractor";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getMethodName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class ComparisonBlock {
        private final PsiExpression myKey;
        private final PsiVariable myResult;

        private ComparisonBlock(PsiExpression key2, PsiVariable result) {
            this.myKey = key2;
            this.myResult = result;
        }

        public PsiExpression getKey() {
            return this.myKey;
        }

        public PsiVariable getResult() {
            return this.myResult;
        }

        @Nullable
        static ComparisonBlock extractBlock(@NotNull PsiStatement statement, @NotNull PsiVariable firstParam, @NotNull PsiVariable secondParam, @Nullable PsiVariable previousResult) {
            if (statement == null) {
                ComparisonBlock.$$$reportNull$$$0(0);
            }
            if (firstParam == null) {
                ComparisonBlock.$$$reportNull$$$0(1);
            }
            if (secondParam == null) {
                ComparisonBlock.$$$reportNull$$$0(2);
            }
            if (statement instanceof PsiDeclarationStatement) {
                PsiDeclarationStatement declaration2 = (PsiDeclarationStatement)statement;
                PsiElement[] elements = declaration2.getDeclaredElements();
                if (elements.length == 0) {
                    return null;
                }
                PsiLocalVariable variable = (PsiLocalVariable)ObjectUtils.tryCast((Object)elements[0], PsiLocalVariable.class);
                if (variable == null) {
                    return null;
                }
                PsiExpression initializer = PsiUtil.skipParenthesizedExprDown((PsiExpression)variable.getInitializer());
                return ComparisonBlock.extractBlock(initializer, firstParam, secondParam, (PsiVariable)variable);
            }
            if (previousResult != null && statement instanceof PsiExpressionStatement) {
                PsiExpression expr = ExpressionUtils.getAssignmentTo((PsiElement)((PsiExpressionStatement)statement).getExpression(), previousResult);
                return ComparisonBlock.extractBlock(expr, firstParam, secondParam, previousResult);
            }
            return null;
        }

        @Contract(value="null, _, _, _ -> null")
        @Nullable
        private static ComparisonBlock extractBlock(@Nullable PsiExpression expr, @NotNull PsiVariable firstParam, @NotNull PsiVariable secondParam, @NotNull PsiVariable variable) {
            if (firstParam == null) {
                ComparisonBlock.$$$reportNull$$$0(3);
            }
            if (secondParam == null) {
                ComparisonBlock.$$$reportNull$$$0(4);
            }
            if (variable == null) {
                ComparisonBlock.$$$reportNull$$$0(5);
            }
            PsiExpression first = null;
            PsiExpression second = null;
            if (expr instanceof PsiMethodCallExpression) {
                PsiMethodCallExpression call = (PsiMethodCallExpression)expr;
                PsiExpression[] parameters2 = call.getArgumentList().getExpressions();
                if (PrimitiveComparison.from(call) != null) {
                    first = parameters2[0];
                    second = parameters2[1];
                } else if (MethodCallUtils.isCompareToCall(call)) {
                    first = call.getMethodExpression().getQualifierExpression();
                    second = (PsiExpression)ArrayUtil.getFirstElement((Object[])call.getArgumentList().getExpressions());
                }
            } else if (expr instanceof PsiBinaryExpression) {
                PsiBinaryExpression binOp = (PsiBinaryExpression)expr;
                if (binOp.getOperationTokenType() != JavaTokenType.MINUS) {
                    return null;
                }
                first = binOp.getLOperand();
                if (ComparatorCombinatorsInspection.getComparingMethodName(first.getType(), true) == null) {
                    return null;
                }
                second = binOp.getROperand();
            }
            if (first == null || second == null) {
                return null;
            }
            if (!ComparisonBlock.usagesAreAllowed(firstParam, secondParam, first, second)) {
                return null;
            }
            if (!ComparisonBlock.keyAccessEquivalent(firstParam, secondParam, first, second)) {
                return null;
            }
            return new ComparisonBlock(second, variable);
        }

        private static boolean keyAccessEquivalent(@NotNull PsiVariable firstParam, @NotNull PsiVariable secondParam, PsiExpression first, PsiExpression second) {
            String secondParamName;
            if (firstParam == null) {
                ComparisonBlock.$$$reportNull$$$0(6);
            }
            if (secondParam == null) {
                ComparisonBlock.$$$reportNull$$$0(7);
            }
            if ((secondParamName = secondParam.getName()) == null) {
                return false;
            }
            return ComparatorCombinatorsInspection.areEquivalent(firstParam, first, secondParam, second);
        }

        private static boolean usagesAreAllowed(@NotNull PsiVariable firstParam, @NotNull PsiVariable secondParam, @Nullable PsiExpression firstExpr, @Nullable PsiExpression secondExpr) {
            if (firstParam == null) {
                ComparisonBlock.$$$reportNull$$$0(8);
            }
            if (secondParam == null) {
                ComparisonBlock.$$$reportNull$$$0(9);
            }
            return VariableAccessUtils.variableIsUsed(firstParam, (PsiElement)firstExpr) && VariableAccessUtils.variableIsUsed(secondParam, (PsiElement)secondExpr) && !VariableAccessUtils.variableIsUsed(firstParam, (PsiElement)secondExpr) && !VariableAccessUtils.variableIsUsed(secondParam, (PsiElement)firstExpr);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "statement";
                    break;
                }
                case 1: 
                case 3: 
                case 6: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "firstParam";
                    break;
                }
                case 2: 
                case 4: 
                case 7: 
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "secondParam";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "variable";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/codeInspection/ComparatorCombinatorsInspection$ComparisonBlock";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "extractBlock";
                    break;
                }
                case 6: 
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[2] = "keyAccessEquivalent";
                    break;
                }
                case 8: 
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[2] = "usagesAreAllowed";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

