/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.codeInspection.AbstractBaseJavaLocalInspectionTool;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiForStatement;
import com.intellij.psi.PsiLoopStatement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.PsiWhileStatement;
import com.intellij.psi.controlFlow.AnalysisCanceledException;
import com.intellij.psi.controlFlow.ControlFlow;
import com.intellij.psi.controlFlow.ControlFlowFactory;
import com.intellij.psi.controlFlow.ControlFlowSubRange;
import com.intellij.psi.controlFlow.ControlFlowUtil;
import com.intellij.psi.controlFlow.LocalsOrMyInstanceFieldsControlFlowPolicy;
import com.siyeh.ig.psiutils.SideEffectChecker;
import java.util.Collection;
import java.util.List;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;

public class IdempotentLoopBodyInspection
extends AbstractBaseJavaLocalInspectionTool {
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            IdempotentLoopBodyInspection.$$$reportNull$$$0(0);
        }
        JavaElementVisitor javaElementVisitor = new JavaElementVisitor(){

            public void visitWhileStatement(PsiWhileStatement loop) {
                ControlFlow controlFlow;
                PsiExpression condition2 = loop.getCondition();
                if (condition2 == null || SideEffectChecker.mayHaveSideEffects(condition2)) {
                    return;
                }
                PsiStatement body2 = loop.getBody();
                if (body2 == null) {
                    return;
                }
                if (SideEffectChecker.mayHaveNonLocalSideEffects((PsiElement)body2)) {
                    return;
                }
                try {
                    controlFlow = ControlFlowFactory.getInstance(loop.getProject()).getControlFlow((PsiElement)body2, LocalsOrMyInstanceFieldsControlFlowPolicy.getInstance());
                }
                catch (AnalysisCanceledException ignored) {
                    return;
                }
                this.checkControlFlow((PsiLoopStatement)loop, controlFlow, holder);
            }

            public void visitForStatement(PsiForStatement loop) {
                ControlFlow controlFlow;
                PsiExpression condition2 = loop.getCondition();
                if (condition2 != null && SideEffectChecker.mayHaveSideEffects(condition2)) {
                    return;
                }
                PsiStatement body2 = loop.getBody();
                if (body2 == null) {
                    return;
                }
                PsiStatement update2 = loop.getUpdate();
                if (SideEffectChecker.mayHaveNonLocalSideEffects((PsiElement)body2) || update2 != null && SideEffectChecker.mayHaveNonLocalSideEffects((PsiElement)update2)) {
                    return;
                }
                try {
                    controlFlow = ControlFlowFactory.getInstance(loop.getProject()).getControlFlow((PsiElement)loop, LocalsOrMyInstanceFieldsControlFlowPolicy.getInstance());
                }
                catch (AnalysisCanceledException ignored) {
                    return;
                }
                int start = controlFlow.getStartOffset((PsiElement)body2);
                int end = controlFlow.getEndOffset((PsiElement)(update2 == null ? body2 : update2));
                if (start == -1 || end == -1) {
                    return;
                }
                controlFlow = new ControlFlowSubRange(controlFlow, start, end);
                this.checkControlFlow((PsiLoopStatement)loop, controlFlow, holder);
            }

            private void checkControlFlow(PsiLoopStatement loop, ControlFlow bodyFlow, @NotNull ProblemsHolder holder2) {
                Collection<PsiVariable> variables;
                if (holder2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                if ((variables = ControlFlowUtil.getWrittenVariables(bodyFlow, 0, bodyFlow.getSize(), true)).isEmpty()) {
                    return;
                }
                List<PsiReferenceExpression> reads = ControlFlowUtil.getReadBeforeWrite(bodyFlow);
                if (StreamEx.of(reads).map(PsiReference::resolve).select(PsiVariable.class).noneMatch(variables::contains)) {
                    holder2.registerProblem(loop.getFirstChild(), InspectionsBundle.message((String)"inspection.idempotent.loop.body", (Object[])new Object[0]), new LocalQuickFix[0]);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/codeInspection/IdempotentLoopBodyInspection$1", "checkControlFlow"));
            }
        };
        if (javaElementVisitor == null) {
            IdempotentLoopBodyInspection.$$$reportNull$$$0(1);
        }
        return javaElementVisitor;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/IdempotentLoopBodyInspection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/IdempotentLoopBodyInspection";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

