/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.codeInsight.daemon.impl.analysis.HighlightControlFlowUtil;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.impl.PsiDiamondTypeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.ObjectUtils;
import com.siyeh.ig.psiutils.CommentTracker;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.HighlightUtils;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WrapWithMutableCollectionFix
implements LocalQuickFix {
    private final String myVariableName;
    private final String myCollectionName;
    private final boolean myOnTheFly;

    public WrapWithMutableCollectionFix(String variableName, String collectionName, boolean onTheFly) {
        this.myVariableName = variableName;
        this.myCollectionName = collectionName;
        this.myOnTheFly = onTheFly;
    }

    @Nls(capitalization=Nls.Capitalization.Sentence)
    @NotNull
    public String getName() {
        String string = "Wrap '" + this.myVariableName + "' with '" + StringUtil.getShortName((String)this.myCollectionName) + "'";
        if (string == null) {
            WrapWithMutableCollectionFix.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Nls(capitalization=Nls.Capitalization.Sentence)
    @NotNull
    public String getFamilyName() {
        if ("Wrap with mutable collection" == null) {
            WrapWithMutableCollectionFix.$$$reportNull$$$0(1);
        }
        return "Wrap with mutable collection";
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        PsiLocalVariable variable;
        if (project == null) {
            WrapWithMutableCollectionFix.$$$reportNull$$$0(2);
        }
        if (descriptor == null) {
            WrapWithMutableCollectionFix.$$$reportNull$$$0(3);
        }
        if ((variable = WrapWithMutableCollectionFix.getVariable(descriptor.getStartElement())) == null) {
            return;
        }
        PsiExpression initializer = variable.getInitializer();
        if (initializer == null) {
            return;
        }
        PsiClassType type2 = (PsiClassType)ObjectUtils.tryCast((Object)variable.getType(), PsiClassType.class);
        if (type2 == null) {
            return;
        }
        String typeParameters = "";
        if (this.myCollectionName.equals("java.util.HashMap")) {
            PsiType keyParameter = PsiUtil.substituteTypeParameter((PsiType)type2, (String)"java.util.Map", (int)0, (boolean)false);
            PsiType valueParameter = PsiUtil.substituteTypeParameter((PsiType)type2, (String)"java.util.Map", (int)1, (boolean)false);
            if (keyParameter != null && valueParameter != null) {
                typeParameters = "<" + keyParameter.getCanonicalText() + "," + valueParameter.getCanonicalText() + ">";
            }
        } else {
            PsiType elementParameter = PsiUtil.substituteTypeParameter((PsiType)type2, (String)"java.lang.Iterable", (int)0, (boolean)false);
            if (elementParameter != null) {
                typeParameters = "<" + elementParameter.getCanonicalText() + ">";
            }
        }
        CommentTracker ct = new CommentTracker();
        PsiElement replacement = ct.replaceAndRestoreComments((PsiElement)initializer, "new " + this.myCollectionName + typeParameters + "(" + ct.text((PsiElement)initializer) + ")");
        PsiDiamondTypeUtil.removeRedundantTypeArguments(replacement);
        if (this.myOnTheFly) {
            HighlightUtils.highlightElement(replacement);
        }
    }

    @Nullable
    public static WrapWithMutableCollectionFix createFix(@NotNull PsiElement anchor, boolean onTheFly) {
        PsiLocalVariable variable;
        if (anchor == null) {
            WrapWithMutableCollectionFix.$$$reportNull$$$0(4);
        }
        if ((variable = WrapWithMutableCollectionFix.getVariable(anchor)) == null) {
            return null;
        }
        PsiExpression initializer = variable.getInitializer();
        if (initializer == null) {
            return null;
        }
        String wrapper = WrapWithMutableCollectionFix.getWrapperByType(variable.getType());
        if (wrapper == null) {
            return null;
        }
        PsiElement block = PsiUtil.getVariableCodeBlock((PsiVariable)variable, null);
        if (block == null) {
            return null;
        }
        if (!HighlightControlFlowUtil.isEffectivelyFinal((PsiVariable)variable, block, null)) {
            return null;
        }
        return new WrapWithMutableCollectionFix(variable.getName(), wrapper, onTheFly);
    }

    @Nullable
    private static PsiLocalVariable getVariable(@NotNull PsiElement anchor) {
        if (anchor == null) {
            WrapWithMutableCollectionFix.$$$reportNull$$$0(5);
        }
        if (anchor.getParent() instanceof PsiReferenceExpression && anchor.getParent().getParent() instanceof PsiCallExpression) {
            anchor = ((PsiReferenceExpression)anchor.getParent()).getQualifierExpression();
        }
        if (!(anchor instanceof PsiExpression)) {
            return null;
        }
        return ExpressionUtils.resolveLocalVariable(PsiUtil.skipParenthesizedExprDown((PsiExpression)((PsiExpression)anchor)));
    }

    @Contract(value="null -> null")
    @Nullable
    private static String getWrapperByType(PsiType type2) {
        if (!(type2 instanceof PsiClassType)) {
            return null;
        }
        PsiClass aClass = ((PsiClassType)type2).resolve();
        if (aClass == null) {
            return null;
        }
        String name = aClass.getQualifiedName();
        if (name == null) {
            return null;
        }
        switch (name) {
            case "java.lang.Iterable": 
            case "java.util.Collection": 
            case "java.util.List": {
                return "java.util.ArrayList";
            }
            case "java.util.Set": {
                return "java.util.HashSet";
            }
            case "java.util.Map": {
                return "java.util.HashMap";
            }
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/WrapWithMutableCollectionFix";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "anchor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/WrapWithMutableCollectionFix";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "applyFix";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createFix";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getVariable";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

