/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.bytecodeAnalysis;

import com.intellij.codeInspection.bytecodeAnalysis.AbstractValues;
import com.intellij.codeInspection.bytecodeAnalysis.CombinedData;
import com.intellij.codeInspection.bytecodeAnalysis.LambdaIndy;
import com.intellij.codeInspection.bytecodeAnalysis.Member;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.org.objectweb.asm.Handle;
import org.jetbrains.org.objectweb.asm.Type;
import org.jetbrains.org.objectweb.asm.tree.AbstractInsnNode;
import org.jetbrains.org.objectweb.asm.tree.InsnList;
import org.jetbrains.org.objectweb.asm.tree.InvokeDynamicInsnNode;
import org.jetbrains.org.objectweb.asm.tree.LdcInsnNode;
import org.jetbrains.org.objectweb.asm.tree.MethodInsnNode;
import org.jetbrains.org.objectweb.asm.tree.TypeInsnNode;
import org.jetbrains.org.objectweb.asm.tree.analysis.AnalyzerException;
import org.jetbrains.org.objectweb.asm.tree.analysis.BasicInterpreter;
import org.jetbrains.org.objectweb.asm.tree.analysis.BasicValue;

final class CombinedInterpreter
extends BasicInterpreter {
    final boolean[] dereferencedParams;
    final boolean[] notNullableParams;
    final Set<CombinedData.ParamKey>[] parameterFlow;
    final boolean[] dereferencedValues;
    final List<CombinedData.TrackableCallValue> calls = new ArrayList<CombinedData.TrackableCallValue>();
    private final InsnList insns;

    CombinedInterpreter(InsnList insns, int arity) {
        super(458752);
        this.dereferencedParams = new boolean[arity];
        this.notNullableParams = new boolean[arity];
        this.parameterFlow = new Set[arity];
        this.insns = insns;
        this.dereferencedValues = new boolean[insns.size()];
    }

    private int insnIndex(AbstractInsnNode insn) {
        return this.insns.indexOf(insn);
    }

    private static BasicValue track(int origin, BasicValue basicValue) {
        return basicValue == null ? null : new CombinedData.TrackableValue(origin, basicValue.getType());
    }

    public BasicValue newOperation(AbstractInsnNode insn) throws AnalyzerException {
        int origin = this.insnIndex(insn);
        switch (insn.getOpcode()) {
            case 3: {
                return AbstractValues.FalseValue;
            }
            case 4: {
                return AbstractValues.TrueValue;
            }
            case 1: {
                return new CombinedData.TrackableNullValue(origin);
            }
            case 18: {
                Object cst = ((LdcInsnNode)insn).cst;
                if (cst instanceof Type) {
                    Type type2 = (Type)cst;
                    if (type2.getSort() == 10 || type2.getSort() == 9) {
                        return AbstractValues.CLASS_VALUE;
                    }
                    if (type2.getSort() != 11) break;
                    return AbstractValues.METHOD_VALUE;
                }
                if (cst instanceof String) {
                    return AbstractValues.STRING_VALUE;
                }
                if (!(cst instanceof Handle)) break;
                return AbstractValues.METHOD_HANDLE_VALUE;
            }
            case 187: {
                return new AbstractValues.NotNullValue(Type.getObjectType((String)((TypeInsnNode)insn).desc));
            }
        }
        return CombinedInterpreter.track(origin, super.newOperation(insn));
    }

    public BasicValue unaryOperation(AbstractInsnNode insn, BasicValue value2) throws AnalyzerException {
        int origin = this.insnIndex(insn);
        switch (insn.getOpcode()) {
            case 180: 
            case 190: 
            case 194: {
                if (value2 instanceof AbstractValues.NthParamValue) {
                    this.dereferencedParams[((AbstractValues.NthParamValue)value2).n] = true;
                }
                if (value2 instanceof CombinedData.Trackable) {
                    this.dereferencedValues[((CombinedData.Trackable)value2).getOriginInsnIndex()] = true;
                }
                return CombinedInterpreter.track(origin, super.unaryOperation(insn, value2));
            }
            case 192: {
                if (!(value2 instanceof AbstractValues.NthParamValue)) break;
                return new AbstractValues.NthParamValue(Type.getObjectType((String)((TypeInsnNode)insn).desc), ((AbstractValues.NthParamValue)value2).n);
            }
            case 188: 
            case 189: {
                return new AbstractValues.NotNullValue(super.unaryOperation(insn, value2).getType());
            }
        }
        return CombinedInterpreter.track(origin, super.unaryOperation(insn, value2));
    }

    public BasicValue binaryOperation(AbstractInsnNode insn, BasicValue value1, BasicValue value2) throws AnalyzerException {
        switch (insn.getOpcode()) {
            case 181: {
                if (value1 instanceof AbstractValues.NthParamValue) {
                    this.dereferencedParams[((AbstractValues.NthParamValue)value1).n] = true;
                }
                if (value1 instanceof CombinedData.Trackable) {
                    this.dereferencedValues[((CombinedData.Trackable)value1).getOriginInsnIndex()] = true;
                }
                if (!(value2 instanceof AbstractValues.NthParamValue)) break;
                this.notNullableParams[((AbstractValues.NthParamValue)value2).n] = true;
                break;
            }
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: {
                if (value1 instanceof AbstractValues.NthParamValue) {
                    this.dereferencedParams[((AbstractValues.NthParamValue)value1).n] = true;
                }
                if (!(value1 instanceof CombinedData.Trackable)) break;
                this.dereferencedValues[((CombinedData.Trackable)value1).getOriginInsnIndex()] = true;
                break;
            }
        }
        return CombinedInterpreter.track(this.insnIndex(insn), super.binaryOperation(insn, value1, value2));
    }

    public BasicValue ternaryOperation(AbstractInsnNode insn, BasicValue value1, BasicValue value2, BasicValue value3) {
        switch (insn.getOpcode()) {
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 84: 
            case 85: 
            case 86: {
                if (value1 instanceof AbstractValues.NthParamValue) {
                    this.dereferencedParams[((AbstractValues.NthParamValue)value1).n] = true;
                }
                if (!(value1 instanceof CombinedData.Trackable)) break;
                this.dereferencedValues[((CombinedData.Trackable)value1).getOriginInsnIndex()] = true;
                break;
            }
            case 83: {
                if (value1 instanceof AbstractValues.NthParamValue) {
                    this.dereferencedParams[((AbstractValues.NthParamValue)value1).n] = true;
                }
                if (value1 instanceof CombinedData.Trackable) {
                    this.dereferencedValues[((CombinedData.Trackable)value1).getOriginInsnIndex()] = true;
                }
                if (!(value3 instanceof AbstractValues.NthParamValue)) break;
                this.notNullableParams[((AbstractValues.NthParamValue)value3).n] = true;
                break;
            }
        }
        return null;
    }

    public BasicValue naryOperation(AbstractInsnNode insn, List<? extends BasicValue> values) throws AnalyzerException {
        int opCode = insn.getOpcode();
        int origin = this.insnIndex(insn);
        switch (opCode) {
            case 182: 
            case 183: 
            case 184: 
            case 185: {
                MethodInsnNode mNode = (MethodInsnNode)insn;
                Member method = new Member(mNode.owner, mNode.name, mNode.desc);
                CombinedData.TrackableCallValue value2 = this.methodCall(opCode, origin, method, values);
                this.calls.add(value2);
                return value2;
            }
            case 186: {
                int targetOpCode;
                InvokeDynamicInsnNode indy = (InvokeDynamicInsnNode)insn;
                if ("java/lang/invoke/StringConcatFactory".equals(indy.bsm.getOwner())) {
                    return new AbstractValues.NotNullValue(Type.getReturnType((String)indy.desc));
                }
                LambdaIndy lambda2 = LambdaIndy.from(indy);
                if (lambda2 == null || (targetOpCode = lambda2.getAssociatedOpcode()) == -1) break;
                this.methodCall(targetOpCode, origin, lambda2.getMethod(), lambda2.getLambdaMethodArguments(values, arg_0 -> ((CombinedInterpreter)this).newValue(arg_0)));
                return new AbstractValues.NotNullValue(lambda2.getFunctionalInterfaceType());
            }
            case 197: {
                return new AbstractValues.NotNullValue(super.naryOperation(insn, values).getType());
            }
        }
        return CombinedInterpreter.track(origin, super.naryOperation(insn, values));
    }

    @NotNull
    private CombinedData.TrackableCallValue methodCall(int opCode, int origin, Member method, List<? extends BasicValue> values) {
        Type retType = Type.getReturnType((String)method.methodDesc);
        boolean stable = opCode == 184 || opCode == 183;
        boolean thisCall = false;
        if (opCode != 184) {
            BasicValue receiver2 = values.remove(0);
            if (receiver2 instanceof AbstractValues.NthParamValue) {
                this.dereferencedParams[((AbstractValues.NthParamValue)receiver2).n] = true;
            }
            if (receiver2 instanceof CombinedData.Trackable) {
                this.dereferencedValues[((CombinedData.Trackable)receiver2).getOriginInsnIndex()] = true;
            }
            thisCall = receiver2 == CombinedData.ThisValue;
        }
        for (int i = 0; i < values.size(); ++i) {
            if (!(values.get(i) instanceof AbstractValues.NthParamValue)) continue;
            int n = ((AbstractValues.NthParamValue)values.get((int)i)).n;
            if (opCode == 185) {
                this.notNullableParams[n] = true;
                continue;
            }
            Set<CombinedData.ParamKey> npKeys = this.parameterFlow[n];
            if (npKeys == null) {
                this.parameterFlow[n] = npKeys = new HashSet<CombinedData.ParamKey>();
            }
            npKeys.add(new CombinedData.ParamKey(method, i, stable));
        }
        CombinedData.TrackableCallValue trackableCallValue = new CombinedData.TrackableCallValue(origin, retType, method, values, stable, thisCall);
        if (trackableCallValue == null) {
            CombinedInterpreter.$$$reportNull$$$0(0);
        }
        return trackableCallValue;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/bytecodeAnalysis/CombinedInterpreter", "methodCall"));
    }
}

