/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.bytecodeAnalysis;

import com.intellij.codeInspection.bytecodeAnalysis.Calls;
import com.intellij.codeInspection.bytecodeAnalysis.Constraint;
import com.intellij.codeInspection.bytecodeAnalysis.Direction;
import com.intellij.codeInspection.bytecodeAnalysis.EKey;
import com.intellij.codeInspection.bytecodeAnalysis.LabeledNull;
import com.intellij.codeInspection.bytecodeAnalysis.Member;
import com.intellij.codeInspection.bytecodeAnalysis.asm.ASMUtils;
import com.intellij.codeInspection.bytecodeAnalysis.asm.InterpreterExt;
import java.util.List;
import org.jetbrains.org.objectweb.asm.Type;
import org.jetbrains.org.objectweb.asm.tree.AbstractInsnNode;
import org.jetbrains.org.objectweb.asm.tree.InsnList;
import org.jetbrains.org.objectweb.asm.tree.JumpInsnNode;
import org.jetbrains.org.objectweb.asm.tree.MethodInsnNode;
import org.jetbrains.org.objectweb.asm.tree.analysis.AnalyzerException;
import org.jetbrains.org.objectweb.asm.tree.analysis.BasicInterpreter;
import org.jetbrains.org.objectweb.asm.tree.analysis.BasicValue;

class NullableMethodInterpreter
extends BasicInterpreter
implements InterpreterExt<Constraint> {
    private final InsnList insns;
    private final boolean[] origins;
    private final int[] originsMapping;
    final EKey[] keys;
    Constraint constraint;
    int delta;
    int nullsDelta;
    int notNullInsn = -1;
    int notNullCall;
    int notNullNull;

    NullableMethodInterpreter(InsnList insns, boolean[] origins, int[] originsMapping) {
        super(458752);
        this.insns = insns;
        this.origins = origins;
        this.originsMapping = originsMapping;
        this.keys = new EKey[originsMapping.length];
    }

    public BasicValue newValue(Type type2) {
        return ASMUtils.isThisType(type2) ? ASMUtils.THIS_VALUE : super.newValue(type2);
    }

    public BasicValue newOperation(AbstractInsnNode insn) throws AnalyzerException {
        int insnIndex;
        if (insn.getOpcode() == 1 && this.origins[insnIndex = this.insns.indexOf(insn)]) {
            return new LabeledNull(1 << this.originsMapping[insnIndex]);
        }
        return super.newOperation(insn);
    }

    public BasicValue unaryOperation(AbstractInsnNode insn, BasicValue value2) throws AnalyzerException {
        switch (insn.getOpcode()) {
            case 180: 
            case 190: 
            case 194: {
                if (!(value2 instanceof Calls)) break;
                this.delta = ((Calls)value2).mergedLabels;
                break;
            }
            case 198: {
                if (value2 instanceof Calls) {
                    this.notNullInsn = this.insns.indexOf(insn) + 1;
                    this.notNullCall = ((Calls)value2).mergedLabels;
                    break;
                }
                if (!(value2 instanceof LabeledNull)) break;
                this.notNullInsn = this.insns.indexOf(insn) + 1;
                this.notNullNull = ((LabeledNull)value2).origins;
                break;
            }
            case 199: {
                if (value2 instanceof Calls) {
                    this.notNullInsn = this.insns.indexOf((AbstractInsnNode)((JumpInsnNode)insn).label);
                    this.notNullCall = ((Calls)value2).mergedLabels;
                    break;
                }
                if (!(value2 instanceof LabeledNull)) break;
                this.notNullInsn = this.insns.indexOf((AbstractInsnNode)((JumpInsnNode)insn).label);
                this.notNullNull = ((LabeledNull)value2).origins;
                break;
            }
        }
        return super.unaryOperation(insn, value2);
    }

    public BasicValue binaryOperation(AbstractInsnNode insn, BasicValue value1, BasicValue value2) throws AnalyzerException {
        switch (insn.getOpcode()) {
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 181: {
                if (value1 instanceof Calls) {
                    this.delta = ((Calls)value1).mergedLabels;
                }
                if (!(value1 instanceof LabeledNull)) break;
                this.nullsDelta = ((LabeledNull)value1).origins;
                break;
            }
        }
        return super.binaryOperation(insn, value1, value2);
    }

    public BasicValue ternaryOperation(AbstractInsnNode insn, BasicValue value1, BasicValue value2, BasicValue value3) {
        if (value1 instanceof Calls) {
            this.delta = ((Calls)value1).mergedLabels;
        }
        if (value1 instanceof LabeledNull) {
            this.nullsDelta = ((LabeledNull)value1).origins;
        }
        return null;
    }

    public BasicValue naryOperation(AbstractInsnNode insn, List<? extends BasicValue> values) throws AnalyzerException {
        int opCode = insn.getOpcode();
        switch (opCode) {
            case 182: 
            case 183: 
            case 185: {
                BasicValue receiver2 = values.get(0);
                if (receiver2 instanceof Calls) {
                    this.delta = ((Calls)receiver2).mergedLabels;
                }
                if (!(receiver2 instanceof LabeledNull)) break;
                this.nullsDelta = ((LabeledNull)receiver2).origins;
                break;
            }
        }
        switch (opCode) {
            case 182: 
            case 183: 
            case 184: {
                int insnIndex = this.insns.indexOf(insn);
                if (!this.origins[insnIndex]) break;
                boolean stable = opCode == 184 || opCode == 183;
                MethodInsnNode mNode = (MethodInsnNode)insn;
                Member method = new Member(mNode.owner, mNode.name, mNode.desc);
                int label = 1 << this.originsMapping[insnIndex];
                if (this.keys[insnIndex] == null) {
                    this.keys[insnIndex] = new EKey(method, Direction.NullableOut, stable);
                }
                return new Calls(label);
            }
        }
        return super.naryOperation(insn, values);
    }

    @Override
    public BasicValue merge(BasicValue v1, BasicValue v2) {
        if (v1 instanceof LabeledNull) {
            if (v2 instanceof LabeledNull) {
                return new LabeledNull(((LabeledNull)v1).origins | ((LabeledNull)v2).origins);
            }
            return v1;
        }
        if (v2 instanceof LabeledNull) {
            return v2;
        }
        if (v1 instanceof Calls) {
            if (v2 instanceof Calls) {
                Calls calls1 = (Calls)v1;
                Calls calls2 = (Calls)v2;
                return new Calls(calls1.mergedLabels | calls2.mergedLabels);
            }
            return v1;
        }
        if (v2 instanceof Calls) {
            return v2;
        }
        return super.merge(v1, v2);
    }

    @Override
    public void init(Constraint previous) {
        this.constraint = previous;
        this.delta = 0;
        this.nullsDelta = 0;
        this.notNullInsn = -1;
        this.notNullCall = 0;
        this.notNullNull = 0;
    }

    @Override
    public Constraint getAfterData(int insn) {
        Constraint afterData = this.mkAfterData();
        if (this.notNullInsn == insn) {
            return new Constraint(afterData.calls | this.notNullCall, afterData.nulls | this.notNullNull);
        }
        return afterData;
    }

    private Constraint mkAfterData() {
        if (this.delta == 0 && this.nullsDelta == 0 && this.notNullInsn == -1) {
            return this.constraint;
        }
        return new Constraint(this.constraint.calls | this.delta, this.constraint.nulls | this.nullsDelta);
    }

    @Override
    public Constraint merge(Constraint data1, Constraint data2) {
        return data1.equals(data2) ? data1 : new Constraint(data1.calls | data2.calls, data1.nulls | data2.nulls);
    }
}

