/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.bytecodeAnalysis.asm;

import com.intellij.codeInspection.bytecodeAnalysis.asm.ASMUtils;
import com.intellij.codeInspection.bytecodeAnalysis.asm.ParamsValue;
import java.util.List;
import org.jetbrains.org.objectweb.asm.Type;
import org.jetbrains.org.objectweb.asm.tree.AbstractInsnNode;
import org.jetbrains.org.objectweb.asm.tree.FieldInsnNode;
import org.jetbrains.org.objectweb.asm.tree.InvokeDynamicInsnNode;
import org.jetbrains.org.objectweb.asm.tree.LdcInsnNode;
import org.jetbrains.org.objectweb.asm.tree.MethodInsnNode;
import org.jetbrains.org.objectweb.asm.tree.MethodNode;
import org.jetbrains.org.objectweb.asm.tree.analysis.Interpreter;

class ParametersUsage
extends Interpreter<ParamsValue> {
    private int param = -1;
    final int arity;
    final ParamsValue val1;
    final ParamsValue val2;

    ParametersUsage(MethodNode methodNode) {
        super(458752);
        this.arity = Type.getArgumentTypes((String)methodNode.desc).length;
        boolean[] emptyParams = new boolean[this.arity];
        this.val1 = new ParamsValue(emptyParams, 1);
        this.val2 = new ParamsValue(emptyParams, 2);
    }

    public ParamsValue newParameterValue(boolean isInstanceMethod, int local, Type type2) {
        int n;
        ++this.param;
        int n2 = n = isInstanceMethod ? this.param - 1 : this.param;
        if (n >= 0 && (ASMUtils.isReferenceType(type2) || ASMUtils.isBooleanType(type2))) {
            boolean[] params = new boolean[this.arity];
            params[n] = true;
            return new ParamsValue(params, type2.getSize());
        }
        return this.newValue(type2);
    }

    public ParamsValue newValue(Type type2) {
        if (type2 == null) {
            return this.val1;
        }
        if (type2 == Type.VOID_TYPE) {
            return null;
        }
        return type2.getSize() == 1 ? this.val1 : this.val2;
    }

    public ParamsValue newOperation(AbstractInsnNode insn) {
        int size;
        switch (insn.getOpcode()) {
            case 9: 
            case 10: 
            case 14: 
            case 15: {
                size = 2;
                break;
            }
            case 18: {
                Object cst = ((LdcInsnNode)insn).cst;
                size = cst instanceof Long || cst instanceof Double ? 2 : 1;
                break;
            }
            case 178: {
                size = Type.getType((String)((FieldInsnNode)insn).desc).getSize();
                break;
            }
            default: {
                size = 1;
            }
        }
        return size == 1 ? this.val1 : this.val2;
    }

    public ParamsValue copyOperation(AbstractInsnNode insn, ParamsValue value2) {
        return value2;
    }

    public ParamsValue unaryOperation(AbstractInsnNode insn, ParamsValue value2) {
        int size;
        switch (insn.getOpcode()) {
            case 192: {
                return value2;
            }
            case 117: 
            case 119: 
            case 133: 
            case 135: 
            case 138: 
            case 140: 
            case 141: 
            case 143: {
                size = 2;
                break;
            }
            case 180: {
                size = Type.getType((String)((FieldInsnNode)insn).desc).getSize();
                break;
            }
            default: {
                size = 1;
            }
        }
        return size == 1 ? this.val1 : this.val2;
    }

    public ParamsValue binaryOperation(AbstractInsnNode insn, ParamsValue value1, ParamsValue value2) {
        int size;
        switch (insn.getOpcode()) {
            case 47: 
            case 49: 
            case 97: 
            case 99: 
            case 101: 
            case 103: 
            case 105: 
            case 107: 
            case 109: 
            case 111: 
            case 113: 
            case 115: 
            case 121: 
            case 123: 
            case 125: 
            case 127: 
            case 129: 
            case 131: {
                size = 2;
                break;
            }
            default: {
                size = 1;
            }
        }
        return size == 1 ? this.val1 : this.val2;
    }

    public ParamsValue ternaryOperation(AbstractInsnNode insn, ParamsValue value1, ParamsValue value2, ParamsValue value3) {
        return null;
    }

    public ParamsValue naryOperation(AbstractInsnNode insn, List<? extends ParamsValue> values) {
        int size;
        int opcode = insn.getOpcode();
        if (opcode == 197) {
            size = 1;
        } else {
            String desc = opcode == 186 ? ((InvokeDynamicInsnNode)insn).desc : ((MethodInsnNode)insn).desc;
            size = Type.getReturnType((String)desc).getSize();
        }
        return size == 1 ? this.val1 : this.val2;
    }

    public void returnOperation(AbstractInsnNode insn, ParamsValue value2, ParamsValue expected) {
    }

    public ParamsValue merge(ParamsValue v1, ParamsValue v2) {
        if (v1.equals(v2)) {
            return v1;
        }
        boolean[] params = new boolean[this.arity];
        boolean[] params1 = v1.params;
        boolean[] params2 = v2.params;
        for (int i = 0; i < this.arity; ++i) {
            params[i] = params1[i] || params2[i];
        }
        return new ParamsValue(params, Math.min(v1.size, v2.size));
    }
}

