/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.canBeFinal;

import com.intellij.codeInsight.daemon.impl.analysis.JavaHighlightUtil;
import com.intellij.codeInspection.reference.RefClass;
import com.intellij.codeInspection.reference.RefClassImpl;
import com.intellij.codeInspection.reference.RefElement;
import com.intellij.codeInspection.reference.RefElementImpl;
import com.intellij.codeInspection.reference.RefField;
import com.intellij.codeInspection.reference.RefFieldImpl;
import com.intellij.codeInspection.reference.RefGraphAnnotatorEx;
import com.intellij.codeInspection.reference.RefManager;
import com.intellij.codeInspection.reference.RefMethod;
import com.intellij.codeInspection.reference.RefMethodImpl;
import com.intellij.codeInspection.reference.RefUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassInitializer;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.controlFlow.AnalysisCanceledException;
import com.intellij.psi.controlFlow.ControlFlow;
import com.intellij.psi.controlFlow.ControlFlowFactory;
import com.intellij.psi.controlFlow.ControlFlowUtil;
import com.intellij.psi.controlFlow.LocalsOrMyInstanceFieldsControlFlowPolicy;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UTypeReferenceExpression;

class CanBeFinalAnnotator
extends RefGraphAnnotatorEx {
    private final RefManager myManager;
    public static long CAN_BE_FINAL_MASK;

    CanBeFinalAnnotator(@NotNull RefManager manager) {
        if (manager == null) {
            CanBeFinalAnnotator.$$$reportNull$$$0(0);
        }
        this.myManager = manager;
    }

    public void initialize(RefManager refManager) {
        CAN_BE_FINAL_MASK = refManager.getLastUsedMask();
    }

    public void onInitialize(RefElement refElement) {
        PsiElement element;
        ((RefElementImpl)refElement).setFlag(true, CAN_BE_FINAL_MASK);
        if (refElement instanceof RefClass) {
            RefClass refClass = (RefClass)refElement;
            UClass psiClass = refClass.getUastElement();
            if (refClass.isEntry()) {
                ((RefClassImpl)refClass).setFlag(false, CAN_BE_FINAL_MASK);
                return;
            }
            if (psiClass != null && !refClass.isSelfInheritor(psiClass)) {
                for (UTypeReferenceExpression superRef : psiClass.getUastSuperTypes()) {
                    RefClass refSuperClass;
                    PsiClass psi = PsiTypesUtil.getPsiClass((PsiType)superRef.getType());
                    if (!this.myManager.belongsToScope((PsiElement)psi) || (refSuperClass = (RefClass)this.myManager.getReference((PsiElement)psi)) == null) continue;
                    ((RefClassImpl)refSuperClass).setFlag(false, CAN_BE_FINAL_MASK);
                }
            }
            if (refClass.isAbstract() || refClass.isAnonymous() || refClass.isInterface()) {
                ((RefClassImpl)refClass).setFlag(false, CAN_BE_FINAL_MASK);
            }
        } else if (refElement instanceof RefMethod) {
            RefMethod refMethod = (RefMethod)refElement;
            PsiElement element2 = refMethod.getPsiElement();
            if (element2 instanceof PsiMethod) {
                PsiMethod psiMethod = (PsiMethod)element2;
                RefClass aClass = refMethod.getOwnerClass();
                if (refMethod.isConstructor() || refMethod.isAbstract() || refMethod.isStatic() || "private".equals(refMethod.getAccessModifier()) || aClass != null && aClass.isAnonymous() || aClass != null && aClass.isInterface()) {
                    ((RefMethodImpl)refMethod).setFlag(false, CAN_BE_FINAL_MASK);
                }
                if ("private".equals(refMethod.getAccessModifier()) && refMethod.getOwner() != null && (aClass == null || !(aClass.getOwner() instanceof RefElement))) {
                    ((RefMethodImpl)refMethod).setFlag(false, CAN_BE_FINAL_MASK);
                }
                for (PsiMethod psiSuperMethod : psiMethod.findSuperMethods()) {
                    RefMethod refSuperMethod;
                    if (!this.myManager.belongsToScope((PsiElement)psiSuperMethod) || (refSuperMethod = (RefMethod)this.myManager.getReference((PsiElement)psiSuperMethod)) == null) continue;
                    ((RefMethodImpl)refSuperMethod).setFlag(false, CAN_BE_FINAL_MASK);
                }
            }
        } else if (refElement instanceof RefField && (element = refElement.getPsiElement()) != null && RefUtil.isImplicitWrite((PsiElement)element)) {
            ((RefElementImpl)refElement).setFlag(false, CAN_BE_FINAL_MASK);
        }
    }

    public void onMarkReferenced(RefElement refWhat, RefElement refFrom, boolean referencedFromClassInitializer, boolean forReading, boolean forWriting, PsiElement referenceElement) {
        if (!(refWhat instanceof RefField)) {
            return;
        }
        if (!(refFrom instanceof RefMethod) || !((RefMethod)refFrom).isConstructor() || ((RefField)refWhat).getUastElement().getUastInitializer() != null || ((RefMethod)refFrom).getOwnerClass() != ((RefField)refWhat).getOwnerClass() || ((RefField)refWhat).isStatic()) {
            if (forWriting && (!referencedFromClassInitializer || PsiTreeUtil.getParentOfType((PsiElement)referenceElement, PsiLambdaExpression.class, (boolean)true) != null)) {
                ((RefFieldImpl)refWhat).setFlag(false, CAN_BE_FINAL_MASK);
            }
        } else if (forWriting && PsiTreeUtil.getParentOfType((PsiElement)referenceElement, PsiLambdaExpression.class, (boolean)true) != null) {
            ((RefFieldImpl)refWhat).setFlag(false, CAN_BE_FINAL_MASK);
        }
    }

    public void onReferencesBuild(RefElement refElement) {
        RefMethod refMethod;
        if (refElement instanceof RefClass) {
            PsiClass psiClass = (PsiClass)ObjectUtils.tryCast((Object)refElement.getPsiElement(), PsiClass.class);
            if (psiClass != null) {
                Collection<Object> writtenVariables;
                ControlFlow flow;
                if (refElement.isEntry()) {
                    ((RefClassImpl)refElement).setFlag(false, CAN_BE_FINAL_MASK);
                }
                Object[] psiFields = psiClass.getFields();
                HashSet allFields = new HashSet();
                ContainerUtil.addAll(allFields, (Object[])psiFields);
                ArrayList<PsiVariable> instanceInitializerInitializedFields = new ArrayList<PsiVariable>();
                HashSet<PsiField> fieldsInitializedInInitializers = null;
                for (PsiClassInitializer psiClassInitializer : psiClass.getInitializers()) {
                    PsiCodeBlock body2 = psiClassInitializer.getBody();
                    try {
                        flow = ControlFlowFactory.getInstance(body2.getProject()).getControlFlow((PsiElement)body2, LocalsOrMyInstanceFieldsControlFlowPolicy.getInstance(), false);
                    }
                    catch (AnalysisCanceledException e) {
                        flow = ControlFlow.EMPTY;
                    }
                    writtenVariables = new ArrayList();
                    ControlFlowUtil.getWrittenVariables(flow, 0, flow.getSize(), false, writtenVariables);
                    if (fieldsInitializedInInitializers == null) {
                        fieldsInitializedInInitializers = new HashSet<PsiField>();
                    }
                    for (PsiVariable psiVariable : writtenVariables) {
                        if (!allFields.contains(psiVariable)) continue;
                        if (instanceInitializerInitializedFields.contains(psiVariable)) {
                            allFields.remove(psiVariable);
                            instanceInitializerInitializedFields.remove(psiVariable);
                        } else {
                            instanceInitializerInitializedFields.add(psiVariable);
                        }
                        fieldsInitializedInInitializers.add((PsiField)psiVariable);
                    }
                    for (PsiVariable psiVariable : writtenVariables) {
                        if (instanceInitializerInitializedFields.contains(psiVariable)) continue;
                        allFields.remove(psiVariable);
                    }
                }
                for (PsiMethod psiMethod : psiClass.getConstructors()) {
                    PsiCodeBlock body2 = psiMethod.getBody();
                    if (body2 == null) continue;
                    try {
                        flow = ControlFlowFactory.getInstance(body2.getProject()).getControlFlow((PsiElement)body2, LocalsOrMyInstanceFieldsControlFlowPolicy.getInstance(), false);
                    }
                    catch (AnalysisCanceledException e) {
                        flow = ControlFlow.EMPTY;
                    }
                    writtenVariables = ControlFlowUtil.getWrittenVariables(flow, 0, flow.getSize(), false);
                    for (PsiVariable psiVariable : writtenVariables) {
                        if (!instanceInitializerInitializedFields.contains(psiVariable)) continue;
                        allFields.remove(psiVariable);
                        instanceInitializerInitializedFields.remove(psiVariable);
                    }
                    List<PsiMethod> redirectedConstructors = JavaHighlightUtil.getChainedConstructors(psiMethod);
                    if (redirectedConstructors.isEmpty()) {
                        List<PsiVariable> list = ControlFlowUtil.getSSAVariables(flow);
                        ArrayList<PsiVariable> good = new ArrayList<PsiVariable>(list);
                        good.addAll(instanceInitializerInitializedFields);
                        allFields.retainAll(good);
                        continue;
                    }
                    allFields.removeAll(writtenVariables);
                }
                for (Object object : psiFields) {
                    RefFieldImpl refField;
                    if ((fieldsInitializedInInitializers == null || fieldsInitializedInInitializers.contains(object)) && allFields.contains(object) || object.getInitializer() != null || (refField = (RefFieldImpl)this.myManager.getReference((PsiElement)object)) == null) continue;
                    refField.setFlag(false, CAN_BE_FINAL_MASK);
                }
            }
        } else if (refElement instanceof RefMethod && (refMethod = (RefMethod)refElement).isEntry()) {
            ((RefMethodImpl)refMethod).setFlag(false, CAN_BE_FINAL_MASK);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/intellij/codeInspection/canBeFinal/CanBeFinalAnnotator", "<init>"));
    }
}

