/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.concurrencyAnnotations;

import com.intellij.codeInsight.PsiEquivalenceUtil;
import com.intellij.codeInsight.daemon.GroupNames;
import com.intellij.codeInspection.AbstractBaseJavaLocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.concurrencyAnnotations.JCiPUtil;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassObjectAccessExpression;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSynchronizedStatement;
import com.intellij.psi.PsiThisExpression;
import com.intellij.psi.PsiTryStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FieldAccessNotGuardedInspection
extends AbstractBaseJavaLocalInspectionTool {
    @NotNull
    public String getGroupDisplayName() {
        String string = GroupNames.CONCURRENCY_ANNOTATION_ISSUES;
        if (string == null) {
            FieldAccessNotGuardedInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Nls
    @NotNull
    public String getDisplayName() {
        if ("Unguarded field access" == null) {
            FieldAccessNotGuardedInspection.$$$reportNull$$$0(1);
        }
        return "Unguarded field access";
    }

    @NotNull
    public String getShortName() {
        if ("FieldAccessNotGuarded" == null) {
            FieldAccessNotGuardedInspection.$$$reportNull$$$0(2);
        }
        return "FieldAccessNotGuarded";
    }

    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            FieldAccessNotGuardedInspection.$$$reportNull$$$0(3);
        }
        Visitor visitor = new Visitor(holder);
        if (visitor == null) {
            FieldAccessNotGuardedInspection.$$$reportNull$$$0(4);
        }
        return visitor;
    }

    private static boolean isCallOnGuard(String guard, String lockMethodStart, PsiMethodCallExpression psiExpression) {
        PsiReferenceExpression methodExpression = psiExpression.getMethodExpression();
        PsiExpression qualifierExpression2 = methodExpression.getQualifierExpression();
        if (qualifierExpression2 != null) {
            PsiElement resolve;
            if (FieldAccessNotGuardedInspection.isCallOnGuard(guard, lockMethodStart, methodExpression, qualifierExpression2)) {
                return true;
            }
            if (qualifierExpression2 instanceof PsiReferenceExpression && (resolve = ((PsiReferenceExpression)qualifierExpression2).resolve()) instanceof PsiField && ((PsiField)resolve).hasModifierProperty("final")) {
                PsiExpression initializer = ((PsiField)resolve).getInitializer();
                return initializer != null && FieldAccessNotGuardedInspection.isCallOnGuard(guard, lockMethodStart, methodExpression, initializer);
            }
        }
        return false;
    }

    private static boolean isCallOnGuard(String guard, String lockMethodStart, PsiReferenceExpression methodExpression, PsiExpression qualifier) {
        String methodName;
        PsiElement resolve;
        String qualifierText = qualifier.getText();
        return (qualifierText.startsWith(guard + ".") || qualifierText.equals(guard)) && (resolve = methodExpression.resolve()) instanceof PsiMethod && (methodName = ((PsiMethod)resolve).getName()).startsWith(lockMethodStart);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 3: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 3: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/concurrencyAnnotations/FieldAccessNotGuardedInspection";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getGroupDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getShortName";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/concurrencyAnnotations/FieldAccessNotGuardedInspection";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class Visitor
    extends JavaElementVisitor {
        private final ProblemsHolder myHolder;

        Visitor(ProblemsHolder holder) {
            this.myHolder = holder;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void visitReferenceExpression(PsiReferenceExpression expression2) {
            PsiSynchronizedStatement syncStatement;
            PsiExpression guardExpression;
            PsiElement parent = PsiTreeUtil.skipParentsOfType((PsiElement)expression2, (Class[])new Class[]{PsiParenthesizedExpression.class});
            if (parent instanceof PsiSynchronizedStatement) {
                return;
            }
            PsiElement referent = expression2.resolve();
            if (!(referent instanceof PsiField)) {
                return;
            }
            PsiField field = (PsiField)referent;
            String guard = JCiPUtil.findGuardForMember((PsiMember)field);
            if (guard == null) {
                return;
            }
            try {
                guardExpression = JavaPsiFacade.getElementFactory((Project)expression2.getProject()).createExpressionFromText(guard, (PsiElement)field);
            }
            catch (IncorrectOperationException ignore) {
                return;
            }
            if (guardExpression instanceof PsiThisExpression && !PsiUtil.isAccessedForWriting((PsiExpression)expression2) && field.hasModifierProperty("volatile")) {
                return;
            }
            PsiMethod containingMethod = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)expression2, PsiMethod.class);
            if (containingMethod != null) {
                PsiClass psiClass;
                PsiThisExpression thisExpression;
                PsiClass aClass;
                if (JCiPUtil.isGuardedBy((PsiMember)containingMethod, guard) || containingMethod.isConstructor()) {
                    return;
                }
                if (containingMethod.hasModifierProperty("synchronized") && (guardExpression instanceof PsiThisExpression ? (aClass = Visitor.getClassFromThisExpression(thisExpression = (PsiThisExpression)guardExpression, (PsiElement)field)) == null || InheritanceUtil.isInheritorOrSelf((PsiClass)containingMethod.getContainingClass(), (PsiClass)aClass, (boolean)true) : containingMethod.hasModifierProperty("static") && guardExpression instanceof PsiClassObjectAccessExpression && ((psiClass = PsiUtil.resolveClassInType((PsiType)((PsiClassObjectAccessExpression)guardExpression).getOperand().getType())) == null || psiClass.equals(containingMethod.getContainingClass())))) {
                    return;
                }
            }
            if (Visitor.findLockTryStatement(expression2, guard) != null) {
                for (PsiReferenceExpression lockExpr = expression2; lockExpr != null; lockExpr = lockExpr.getParent()) {
                    for (PsiReferenceExpression child = lockExpr; child != null; child = child.getPrevSibling()) {
                        if (Visitor.isLockGuardStatement(guard, (PsiElement)child, "lock")) {
                            return;
                        }
                        PsiElement childParent = child.getParent();
                        if (!(child instanceof PsiMethodCallExpression) || !FieldAccessNotGuardedInspection.isCallOnGuard(guard, "tryLock", (PsiMethodCallExpression)child) || !(childParent instanceof PsiIfStatement) || ((PsiIfStatement)childParent).getCondition() != child) continue;
                        return;
                    }
                }
            }
            PsiReferenceExpression check = expression2;
            while ((syncStatement = (PsiSynchronizedStatement)PsiTreeUtil.getParentOfType((PsiElement)check, PsiSynchronizedStatement.class)) != null) {
                PsiClass aClass2;
                PsiClass aClass1;
                PsiExpression lockExpression2 = PsiUtil.skipParenthesizedExprDown((PsiExpression)syncStatement.getLockExpression());
                if (lockExpression2 == null) continue;
                if (guardExpression instanceof PsiThisExpression) {
                    PsiExpression qualifierExpression2;
                    if (lockExpression2 instanceof PsiThisExpression) {
                        PsiThisExpression thisExpression1 = (PsiThisExpression)guardExpression;
                        PsiThisExpression thisExpression2 = (PsiThisExpression)lockExpression2;
                        aClass1 = Visitor.getClassFromThisExpression(thisExpression1, (PsiElement)field);
                        aClass2 = Visitor.getClassFromThisExpression(thisExpression2, (PsiElement)expression2);
                        if (aClass1 == null || aClass1.equals(aClass2)) {
                            return;
                        }
                    } else if (lockExpression2 instanceof PsiReferenceExpression && (qualifierExpression2 = expression2.getQualifierExpression()) != null && PsiEquivalenceUtil.areElementsEquivalent((PsiElement)lockExpression2, (PsiElement)qualifierExpression2)) {
                        return;
                    }
                } else if (guardExpression instanceof PsiReferenceExpression && lockExpression2 instanceof PsiReferenceExpression) {
                    PsiReferenceExpression referenceExpression1 = (PsiReferenceExpression)guardExpression;
                    PsiReferenceExpression referenceExpression2 = (PsiReferenceExpression)lockExpression2;
                    PsiElement target1 = referenceExpression1.resolve();
                    PsiElement target2 = referenceExpression2.resolve();
                    if (target1 == null || target1.equals(target2)) {
                        PsiExpression lockQualifier = referenceExpression2.getQualifierExpression();
                        if (referenceExpression1.getQualifierExpression() != null || lockQualifier == null) return;
                        PsiExpression qualifierExpression3 = expression2.getQualifierExpression();
                        if (qualifierExpression3 != null && PsiEquivalenceUtil.areElementsEquivalent((PsiElement)lockQualifier, (PsiElement)qualifierExpression3)) {
                            return;
                        }
                    }
                } else if (guardExpression instanceof PsiMethodCallExpression && lockExpression2 instanceof PsiMethodCallExpression) {
                    PsiMethodCallExpression methodCallExpression1 = (PsiMethodCallExpression)guardExpression;
                    PsiMethodCallExpression methodCallExpression2 = (PsiMethodCallExpression)lockExpression2;
                    if (methodCallExpression2.getArgumentList().isEmpty()) {
                        PsiMethod method1 = methodCallExpression1.resolveMethod();
                        PsiMethod method2 = methodCallExpression2.resolveMethod();
                        if (method1 == null || method1.equals(method2)) {
                            PsiReferenceExpression methodExpression2 = methodCallExpression2.getMethodExpression();
                            PsiExpression qualifierExpression1 = expression2.getQualifierExpression();
                            PsiExpression qualifierExpression2 = methodExpression2.getQualifierExpression();
                            if (qualifierExpression1 == null && qualifierExpression2 == null) {
                                return;
                            }
                            if (qualifierExpression1 != null && qualifierExpression2 != null && PsiEquivalenceUtil.areElementsEquivalent((PsiElement)qualifierExpression1, (PsiElement)qualifierExpression2)) {
                                return;
                            }
                        }
                    }
                } else if (guardExpression instanceof PsiClassObjectAccessExpression && lockExpression2 instanceof PsiClassObjectAccessExpression) {
                    PsiClassObjectAccessExpression classObjectAccessExpression1 = (PsiClassObjectAccessExpression)guardExpression;
                    PsiClassObjectAccessExpression classObjectAccessExpression2 = (PsiClassObjectAccessExpression)lockExpression2;
                    aClass1 = PsiUtil.resolveClassInClassTypeOnly((PsiType)classObjectAccessExpression1.getOperand().getType());
                    aClass2 = PsiUtil.resolveClassInClassTypeOnly((PsiType)classObjectAccessExpression2.getOperand().getType());
                    if (aClass1 == null || aClass1.equals(aClass2)) {
                        return;
                    }
                }
                check = syncStatement;
            }
            this.myHolder.registerProblem((PsiElement)expression2, "Access to field <code>#ref</code> outside of declared guards #loc", new LocalQuickFix[0]);
        }

        private static PsiClass getClassFromThisExpression(PsiThisExpression thisExpression, PsiElement context) {
            PsiJavaCodeReferenceElement qualifier = thisExpression.getQualifier();
            if (qualifier == null) {
                return (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)context, PsiClass.class);
            }
            PsiElement target = qualifier.resolve();
            return target instanceof PsiClass ? (PsiClass)target : null;
        }

        @Nullable
        private static PsiTryStatement findLockTryStatement(PsiReferenceExpression expression2, String guard) {
            PsiTryStatement tryStatement = (PsiTryStatement)PsiTreeUtil.getParentOfType((PsiElement)expression2, PsiTryStatement.class);
            while (tryStatement != null) {
                PsiCodeBlock finallyBlock = tryStatement.getFinallyBlock();
                if (finallyBlock != null) {
                    for (PsiStatement psiStatement : finallyBlock.getStatements()) {
                        if (!Visitor.isLockGuardStatement(guard, (PsiElement)psiStatement, "unlock")) continue;
                        return tryStatement;
                    }
                }
                tryStatement = (PsiTryStatement)PsiTreeUtil.getParentOfType((PsiElement)tryStatement, PsiTryStatement.class);
            }
            return null;
        }

        private static boolean isLockGuardStatement(String guard, PsiElement element, String lockMethodStart) {
            PsiExpression psiExpression;
            if (element instanceof PsiExpressionStatement && (psiExpression = ((PsiExpressionStatement)element).getExpression()) instanceof PsiMethodCallExpression) {
                return FieldAccessNotGuardedInspection.isCallOnGuard(guard, lockMethodStart, (PsiMethodCallExpression)psiExpression);
            }
            return false;
        }
    }
}

