/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.concurrencyAnnotations;

import com.intellij.codeInsight.daemon.GroupNames;
import com.intellij.codeInspection.AbstractBaseJavaLocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.concurrencyAnnotations.JCiPUtil;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassObjectAccessExpression;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiThisExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.impl.source.DummyHolder;
import com.intellij.psi.javadoc.PsiDocTag;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UnknownGuardInspection
extends AbstractBaseJavaLocalInspectionTool {
    @NotNull
    public String getGroupDisplayName() {
        String string = GroupNames.CONCURRENCY_ANNOTATION_ISSUES;
        if (string == null) {
            UnknownGuardInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Nls
    @NotNull
    public String getDisplayName() {
        if ("Unknown @GuardedBy field" == null) {
            UnknownGuardInspection.$$$reportNull$$$0(1);
        }
        return "Unknown @GuardedBy field";
    }

    @NotNull
    public String getShortName() {
        if ("UnknownGuard" == null) {
            UnknownGuardInspection.$$$reportNull$$$0(2);
        }
        return "UnknownGuard";
    }

    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            UnknownGuardInspection.$$$reportNull$$$0(3);
        }
        Visitor visitor = new Visitor(holder);
        if (visitor == null) {
            UnknownGuardInspection.$$$reportNull$$$0(4);
        }
        return visitor;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 3: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 3: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/concurrencyAnnotations/UnknownGuardInspection";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getGroupDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getShortName";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/concurrencyAnnotations/UnknownGuardInspection";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class Visitor
    extends JavaElementVisitor {
        private final ProblemsHolder myHolder;

        Visitor(ProblemsHolder holder) {
            this.myHolder = holder;
        }

        public void visitAnnotation(PsiAnnotation annotation) {
            super.visitAnnotation(annotation);
            if (!JCiPUtil.isGuardedByAnnotation(annotation)) {
                return;
            }
            String guardValue = JCiPUtil.getGuardValue(annotation);
            if (Visitor.isValidGuardText(guardValue, (PsiElement)annotation)) {
                return;
            }
            PsiAnnotationMemberValue member = annotation.findAttributeValue("value");
            if (member == null) {
                return;
            }
            this.myHolder.registerProblem((PsiElement)member, "Unknown @GuardedBy reference #ref #loc", new LocalQuickFix[0]);
        }

        private static boolean isValidGuardText(@Nullable String guardText, @NotNull PsiElement context) {
            if (context == null) {
                Visitor.$$$reportNull$$$0(0);
            }
            if (guardText == null || "itself".equals(guardText)) {
                return false;
            }
            try {
                JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)context.getProject());
                PsiExpression expression2 = facade.getElementFactory().createExpressionFromText(guardText, context);
                return Visitor.isValidGuard(expression2, context);
            }
            catch (IncorrectOperationException ignore) {
                return false;
            }
        }

        private static boolean isValidGuard(PsiExpression expression2, PsiElement context) {
            if (expression2 instanceof PsiReferenceExpression) {
                PsiReferenceExpression referenceExpression = (PsiReferenceExpression)expression2;
                JavaResolveResult result = referenceExpression.advancedResolve(false);
                if (!result.isAccessible() || !result.isValidResult()) {
                    return false;
                }
                PsiElement target = result.getElement();
                PsiElement parent = expression2.getParent();
                if (!(parent instanceof DummyHolder)) {
                    return target != null;
                }
                if (!(target instanceof PsiField)) {
                    return false;
                }
                PsiField field = (PsiField)target;
                PsiType type2 = field.getType();
                if (type2 instanceof PsiPrimitiveType) {
                    return false;
                }
                PsiExpression qualifier = referenceExpression.getQualifierExpression();
                return qualifier == null || Visitor.isValidGuard(qualifier, context);
            }
            if (expression2 instanceof PsiMethodCallExpression) {
                PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)expression2;
                PsiExpressionList argumentList = methodCallExpression.getArgumentList();
                if (!argumentList.isEmpty()) {
                    return false;
                }
                JavaResolveResult result = methodCallExpression.resolveMethodGenerics();
                if (!result.isAccessible() || !result.isValidResult()) {
                    return false;
                }
                PsiElement element = result.getElement();
                if (!(element instanceof PsiMethod)) {
                    return false;
                }
                PsiMethod method = (PsiMethod)element;
                PsiType type3 = method.getReturnType();
                if (type3 instanceof PsiPrimitiveType) {
                    return false;
                }
                PsiReferenceExpression methodExpression = methodCallExpression.getMethodExpression();
                PsiExpression qualifierExpression2 = methodExpression.getQualifierExpression();
                return qualifierExpression2 == null || Visitor.isValidGuard(qualifierExpression2, context);
            }
            if (expression2 instanceof PsiThisExpression) {
                PsiThisExpression thisExpression = (PsiThisExpression)expression2;
                PsiJavaCodeReferenceElement qualifier = thisExpression.getQualifier();
                if (qualifier == null) {
                    return true;
                }
                JavaResolveResult result = qualifier.advancedResolve(false);
                if (!result.isValidResult() || !result.isAccessible()) {
                    return false;
                }
                PsiElement target = result.getElement();
                if (!(target instanceof PsiClass)) {
                    return false;
                }
                PsiClass aClass = (PsiClass)target;
                return InheritanceUtil.hasEnclosingInstanceInScope((PsiClass)aClass, (PsiElement)context, (boolean)false, (boolean)false);
            }
            if (expression2 instanceof PsiClassObjectAccessExpression) {
                PsiClassObjectAccessExpression classObjectAccessExpression = (PsiClassObjectAccessExpression)expression2;
                PsiTypeElement operand2 = classObjectAccessExpression.getOperand();
                PsiType type4 = operand2.getType();
                if (!(type4 instanceof PsiClassType)) {
                    return false;
                }
                PsiClassType classType = (PsiClassType)type4;
                PsiClass target = classType.resolve();
                return target != null;
            }
            return false;
        }

        public void visitDocTag(PsiDocTag psiDocTag) {
            super.visitDocTag(psiDocTag);
            if (!JCiPUtil.isGuardedByTag(psiDocTag)) {
                return;
            }
            String guardValue = JCiPUtil.getGuardValue(psiDocTag);
            if (Visitor.isValidGuardText(guardValue, (PsiElement)psiDocTag)) {
                return;
            }
            this.myHolder.registerProblem((PsiElement)psiDocTag, "Unknown @GuardedBy reference \"" + guardValue + "\" #loc", new LocalQuickFix[0]);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/codeInspection/concurrencyAnnotations/UnknownGuardInspection$Visitor", "isValidGuardText"));
        }
    }
}

