/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow;

import com.intellij.codeInsight.Nullability;
import com.intellij.codeInspection.dataFlow.DfaFactMap;
import com.intellij.codeInspection.dataFlow.DfaFactType;
import com.intellij.codeInspection.dataFlow.DfaNullability;
import com.intellij.codeInspection.dataFlow.TypeConstraint;
import com.intellij.codeInspection.dataFlow.value.DfaPsiType;
import com.intellij.codeInspection.dataFlow.value.DfaValue;
import com.intellij.codeInspection.dataFlow.value.DfaVariableValue;
import com.intellij.psi.PsiPrimitiveType;
import java.util.Objects;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class DfaVariableState {
    @NotNull
    final DfaFactMap myFactMap;
    private final int myHash;

    DfaVariableState(@NotNull DfaVariableValue dfaVar) {
        if (dfaVar == null) {
            DfaVariableState.$$$reportNull$$$0(0);
        }
        this(dfaVar.getInherentFacts());
    }

    public boolean isSuperStateOf(DfaVariableState that) {
        return this.myFactMap.isSuperStateOf(that.myFactMap);
    }

    DfaVariableState(@NotNull DfaFactMap factMap) {
        if (factMap == null) {
            DfaVariableState.$$$reportNull$$$0(1);
        }
        this.myFactMap = factMap;
        this.myHash = this.myFactMap.hashCode();
    }

    @Nullable
    DfaVariableState withInstanceofValue(@NotNull DfaPsiType dfaType) {
        if (dfaType == null) {
            DfaVariableState.$$$reportNull$$$0(2);
        }
        if (dfaType.getPsiType() instanceof PsiPrimitiveType) {
            return this;
        }
        return this.withFacts(TypeConstraint.withInstanceOf(this.myFactMap, dfaType));
    }

    @Nullable
    DfaVariableState withNotInstanceofValue(@NotNull DfaPsiType dfaType) {
        TypeConstraint typeConstraint;
        TypeConstraint newTypeConstraint;
        if (dfaType == null) {
            DfaVariableState.$$$reportNull$$$0(3);
        }
        return (newTypeConstraint = (typeConstraint = this.getTypeConstraint()).withNotInstanceofValue(dfaType)) == null ? null : this.withFact(DfaFactType.TYPE_CONSTRAINT, newTypeConstraint);
    }

    @NotNull
    DfaVariableState withoutType(@NotNull DfaPsiType type2) {
        if (type2 == null) {
            DfaVariableState.$$$reportNull$$$0(4);
        }
        DfaVariableState dfaVariableState = this.withFact(DfaFactType.TYPE_CONSTRAINT, this.getTypeConstraint().withoutType(type2));
        if (dfaVariableState == null) {
            DfaVariableState.$$$reportNull$$$0(5);
        }
        return dfaVariableState;
    }

    public int hashCode() {
        return this.myHash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof DfaVariableState)) {
            return false;
        }
        DfaVariableState aState = (DfaVariableState)obj;
        return this.myHash == aState.myHash && Objects.equals(this.myFactMap, aState.myFactMap);
    }

    @NotNull
    protected DfaVariableState createCopy(@NotNull DfaFactMap factMap) {
        if (factMap == null) {
            DfaVariableState.$$$reportNull$$$0(6);
        }
        DfaVariableState dfaVariableState = new DfaVariableState(factMap);
        if (dfaVariableState == null) {
            DfaVariableState.$$$reportNull$$$0(7);
        }
        return dfaVariableState;
    }

    public String toString() {
        return "State: " + this.myFactMap;
    }

    @NotNull
    Nullability getNullability() {
        Nullability nullability = DfaNullability.toNullability(this.myFactMap.get(DfaFactType.NULLABILITY));
        if (nullability == null) {
            DfaVariableState.$$$reportNull$$$0(8);
        }
        return nullability;
    }

    public boolean isNotNull() {
        return DfaNullability.isNotNull(this.myFactMap);
    }

    @NotNull
    DfaVariableState withNotNull() {
        DfaVariableState dfaVariableState = this.getNullability() == Nullability.NOT_NULL ? this : this.withoutFact(DfaFactType.NULLABILITY);
        if (dfaVariableState == null) {
            DfaVariableState.$$$reportNull$$$0(9);
        }
        return dfaVariableState;
    }

    @NotNull
    <T> DfaVariableState withFact(DfaFactType<T> type2, T value2) {
        DfaVariableState dfaVariableState = this.withFacts(this.myFactMap.with(type2, value2));
        if (dfaVariableState == null) {
            DfaVariableState.$$$reportNull$$$0(10);
        }
        return dfaVariableState;
    }

    @NotNull
    <T> DfaVariableState withoutFact(DfaFactType<T> type2) {
        DfaVariableState dfaVariableState = this.withFact(type2, null);
        if (dfaVariableState == null) {
            DfaVariableState.$$$reportNull$$$0(11);
        }
        return dfaVariableState;
    }

    @Nullable
    <T> DfaVariableState intersectFact(DfaFactType<T> type2, T value2) {
        return this.withFacts(this.myFactMap.intersect(type2, value2));
    }

    @Nullable
    DfaVariableState intersectMap(DfaFactMap map2) {
        return this.withFacts(this.myFactMap.intersect(map2));
    }

    @Contract(value="null -> null;!null -> !null")
    public DfaVariableState withFacts(@Nullable DfaFactMap facts) {
        return facts == null ? null : (facts.equals(this.myFactMap) ? this : this.createCopy(facts));
    }

    @NotNull
    public DfaVariableState withValue(DfaValue value2) {
        DfaVariableState dfaVariableState = this;
        if (dfaVariableState == null) {
            DfaVariableState.$$$reportNull$$$0(12);
        }
        return dfaVariableState;
    }

    @Nullable
    public DfaValue getValue() {
        return null;
    }

    @NotNull
    public TypeConstraint getTypeConstraint() {
        TypeConstraint fact = this.getFact(DfaFactType.TYPE_CONSTRAINT);
        TypeConstraint typeConstraint = fact == null ? TypeConstraint.empty() : fact;
        if (typeConstraint == null) {
            DfaVariableState.$$$reportNull$$$0(13);
        }
        return typeConstraint;
    }

    @Nullable
    public <T> T getFact(@NotNull DfaFactType<T> factType) {
        if (factType == null) {
            DfaVariableState.$$$reportNull$$$0(14);
        }
        return this.myFactMap.get(factType);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dfaVar";
                break;
            }
            case 1: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "factMap";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dfaType";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/dataFlow/DfaVariableState";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "factType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/dataFlow/DfaVariableState";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "withoutType";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "createCopy";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getNullability";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "withNotNull";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "withFact";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "withoutFact";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "withValue";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeConstraint";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "withInstanceofValue";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "withNotInstanceofValue";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "withoutType";
                break;
            }
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createCopy";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getFact";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

