/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow;

import com.intellij.codeInspection.dataFlow.ContractReturnValue;
import com.intellij.codeInspection.dataFlow.ContractValue;
import com.intellij.codeInspection.dataFlow.value.DfaRelationValue;
import java.util.Collections;
import java.util.List;

public abstract class MethodContract {
    private final ContractReturnValue myReturnValue;

    MethodContract(ContractReturnValue returnValue) {
        this.myReturnValue = returnValue;
    }

    public ContractReturnValue getReturnValue() {
        return this.myReturnValue;
    }

    public boolean isTrivial() {
        return this.getConditions().isEmpty();
    }

    abstract String getArgumentsPresentation();

    public abstract List<ContractValue> getConditions();

    public String toString() {
        return this.getArgumentsPresentation() + " -> " + this.getReturnValue();
    }

    public static MethodContract trivialContract(ContractReturnValue value2) {
        return new MethodContract(value2){

            @Override
            String getArgumentsPresentation() {
                return "(any)";
            }

            @Override
            public List<ContractValue> getConditions() {
                return Collections.emptyList();
            }
        };
    }

    public static MethodContract singleConditionContract(ContractValue left, DfaRelationValue.RelationType relationType, ContractValue right, ContractReturnValue returnValue) {
        final ContractValue condition2 = ContractValue.condition(left, relationType, right);
        return new MethodContract(returnValue){

            @Override
            String getArgumentsPresentation() {
                return condition2.toString();
            }

            @Override
            public List<ContractValue> getConditions() {
                return Collections.singletonList(condition2);
            }
        };
    }
}

