/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow.inference;

import com.intellij.codeInspection.dataFlow.JavaMethodContractUtil;
import com.intellij.codeInspection.dataFlow.StandardMethodContract;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.FileIndexFacade;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.impl.source.PsiMethodImpl;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.MethodReferencesSearch;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.PsiUtilCore;
import org.jetbrains.annotations.NotNull;

public class InferenceFromSourceUtil {
    static boolean shouldInferFromSource(@NotNull PsiMethodImpl method) {
        if (method == null) {
            InferenceFromSourceUtil.$$$reportNull$$$0(0);
        }
        return (Boolean)CachedValuesManager.getCachedValue((PsiElement)method, () -> {
            if (method == null) {
                InferenceFromSourceUtil.$$$reportNull$$$0(4);
            }
            return CachedValueProvider.Result.create((Object)InferenceFromSourceUtil.calcShouldInferFromSource(method), (Object[])new Object[]{method, PsiModificationTracker.JAVA_STRUCTURE_MODIFICATION_COUNT});
        });
    }

    private static boolean calcShouldInferFromSource(@NotNull PsiMethod method) {
        if (method == null) {
            InferenceFromSourceUtil.$$$reportNull$$$0(1);
        }
        if (InferenceFromSourceUtil.isLibraryCode(method) || method.hasModifierProperty("abstract") || PsiUtil.canBeOverridden((PsiMethod)method)) {
            return false;
        }
        if (method.hasModifierProperty("static")) {
            return true;
        }
        return !InferenceFromSourceUtil.isUnusedInAnonymousClass(method);
    }

    private static boolean isUnusedInAnonymousClass(@NotNull PsiMethod method) {
        PsiClass containingClass;
        if (method == null) {
            InferenceFromSourceUtil.$$$reportNull$$$0(2);
        }
        if (!((containingClass = method.getContainingClass()) instanceof PsiAnonymousClass)) {
            return false;
        }
        if (containingClass.getParent() instanceof PsiNewExpression && containingClass.getParent().getParent() instanceof PsiVariable && !method.getHierarchicalMethodSignature().getSuperSignatures().isEmpty()) {
            return false;
        }
        return MethodReferencesSearch.search((PsiMethod)method, (SearchScope)new LocalSearchScope((PsiElement)containingClass), (boolean)false).findFirst() == null;
    }

    private static boolean isLibraryCode(@NotNull PsiMethod method) {
        if (method == null) {
            InferenceFromSourceUtil.$$$reportNull$$$0(3);
        }
        if (method instanceof PsiCompiledElement) {
            return true;
        }
        VirtualFile virtualFile = PsiUtilCore.getVirtualFile((PsiElement)method);
        return virtualFile != null && FileIndexFacade.getInstance((Project)method.getProject()).isInLibrarySource(virtualFile);
    }

    public static boolean suppressNullable(PsiMethod method) {
        if (method.getParameterList().isEmpty()) {
            return false;
        }
        for (StandardMethodContract contract : JavaMethodContractUtil.getMethodContracts(method)) {
            if (!contract.getReturnValue().isNull()) continue;
            return true;
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "method";
        objectArray2[1] = "com/intellij/codeInspection/dataFlow/inference/InferenceFromSourceUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "shouldInferFromSource";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "calcShouldInferFromSource";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "isUnusedInAnonymousClass";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "isLibraryCode";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$shouldInferFromSource$0";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

