/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow.inference;

import com.intellij.codeInspection.dataFlow.inference.ExpressionRange;
import com.intellij.codeInspection.dataFlow.inference.PurityInferenceResult;
import com.intellij.lang.LighterAST;
import com.intellij.lang.LighterASTNode;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.impl.source.FileLocalResolver;
import com.intellij.psi.impl.source.JavaLightTreeUtil;
import com.intellij.psi.impl.source.tree.JavaElementType;
import com.intellij.psi.impl.source.tree.LightTreeUtil;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class PurityInferenceVisitor {
    private final LighterAST tree;
    private final LighterASTNode body;
    private final Set<String> myVolatileFieldNames;
    private final List<LighterASTNode> mutatedRefs = new ArrayList<LighterASTNode>();
    private boolean hasReturns;
    private boolean hasVolatileReads;
    private final List<LighterASTNode> calls = new ArrayList<LighterASTNode>();

    PurityInferenceVisitor(LighterAST tree, LighterASTNode body2, Set<String> volatileFieldNames) {
        this.tree = tree;
        this.body = body2;
        this.myVolatileFieldNames = volatileFieldNames;
    }

    void visitNode(LighterASTNode element) {
        LighterASTNode target;
        LighterASTNode qualifier;
        IElementType type2 = element.getTokenType();
        if (type2 == JavaElementType.ASSIGNMENT_EXPRESSION) {
            this.mutatedRefs.add((LighterASTNode)this.tree.getChildren(element).get(0));
        } else if (type2 == JavaElementType.RETURN_STATEMENT && JavaLightTreeUtil.findExpressionChild(this.tree, element) != null) {
            this.hasReturns = true;
        } else if ((type2 == JavaElementType.PREFIX_EXPRESSION || type2 == JavaElementType.POSTFIX_EXPRESSION) && this.isMutatingOperation(element)) {
            ContainerUtil.addIfNotNull(this.mutatedRefs, (Object)JavaLightTreeUtil.findExpressionChild(this.tree, element));
        } else if (this.isCall(element, type2)) {
            this.calls.add(element);
        } else if (type2 == JavaElementType.REFERENCE_EXPRESSION && !this.myVolatileFieldNames.isEmpty() && ((qualifier = JavaLightTreeUtil.findExpressionChild(this.tree, element)) == null || qualifier.getTokenType() == JavaElementType.THIS_EXPRESSION) && this.myVolatileFieldNames.contains(JavaLightTreeUtil.getNameIdentifierText(this.tree, element)) && (target = new FileLocalResolver(this.tree).resolveLocally(element).getTarget()) != null && target.getTokenType() == JavaElementType.FIELD && JavaLightTreeUtil.hasExplicitModifier(this.tree, target, JavaTokenType.VOLATILE_KEYWORD)) {
            this.hasVolatileReads = true;
        }
    }

    private boolean isCall(@NotNull LighterASTNode element, IElementType type2) {
        if (element == null) {
            PurityInferenceVisitor.$$$reportNull$$$0(0);
        }
        return type2 == JavaElementType.NEW_EXPRESSION && LightTreeUtil.firstChildOfType((LighterAST)this.tree, (LighterASTNode)element, (IElementType)JavaElementType.EXPRESSION_LIST) != null || type2 == JavaElementType.METHOD_CALL_EXPRESSION;
    }

    private boolean isMutatingOperation(@NotNull LighterASTNode element) {
        if (element == null) {
            PurityInferenceVisitor.$$$reportNull$$$0(1);
        }
        return LightTreeUtil.firstChildOfType((LighterAST)this.tree, (LighterASTNode)element, (IElementType)JavaTokenType.PLUSPLUS) != null || LightTreeUtil.firstChildOfType((LighterAST)this.tree, (LighterASTNode)element, (IElementType)JavaTokenType.MINUSMINUS) != null;
    }

    @Nullable
    PurityInferenceResult getResult() {
        if (this.calls.size() > 1 || !this.hasReturns || this.hasVolatileReads) {
            return null;
        }
        int bodyStart = this.body.getStartOffset();
        return new PurityInferenceResult(ContainerUtil.map(this.mutatedRefs, node -> ExpressionRange.create(node, bodyStart)), this.calls.isEmpty() ? null : ExpressionRange.create(this.calls.get(0), bodyStart));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "element";
        objectArray2[1] = "com/intellij/codeInspection/dataFlow/inference/PurityInferenceVisitor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isCall";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "isMutatingOperation";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

